/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.algorithm.descriptor;

import junit.framework.TestCase;
import org.n52.wps.algorithm.descriptor.BoundDescriptor;

public class BoundDataDescriptorTest
extends TestCase {
    public BoundDataDescriptorTest(String testName) {
        super(testName);
    }

    public void testBinding() {
        BoundDescriptorImpl descriptor = null;
        boolean thrown = false;
        try {
            descriptor = new BoundDescriptorImpl.Builder(null).build();
            BoundDataDescriptorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        BoundDataDescriptorTest.assertTrue((boolean)thrown);
        descriptor = new BoundDescriptorImpl.Builder(Double.class).build();
        BoundDataDescriptorTest.assertEquals(Double.class, (Object)descriptor.getBinding());
        descriptor = new BoundDescriptorImpl.Builder(MockNumber.class).build();
        BoundDataDescriptorTest.assertEquals(MockNumber.class, (Object)descriptor.getBinding());
    }

    public static class MockNumber
    extends Number {
        @Override
        public int intValue() {
            return Integer.MAX_VALUE;
        }

        @Override
        public long longValue() {
            return Long.MAX_VALUE;
        }

        @Override
        public float floatValue() {
            return Float.MAX_VALUE;
        }

        @Override
        public double doubleValue() {
            return Double.MAX_VALUE;
        }
    }

    public static class BoundDescriptorImpl
    extends BoundDescriptor<Class<? extends Number>> {
        private BoundDescriptorImpl(Builder builder) {
            super((BoundDescriptor.Builder)builder);
        }

        public static class Builder
        extends BoundDescriptor.Builder<Builder, Class<? extends Number>> {
            Builder(Class<? extends Number> binding) {
                super("mock_identifier", binding);
            }

            protected Builder self() {
                return this;
            }

            public BoundDescriptorImpl build() {
                return new BoundDescriptorImpl(this);
            }
        }
    }
}

