/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.n52.wps.algorithm.descriptor.AlgorithmDescriptor;
import org.n52.wps.algorithm.descriptor.InputDescriptor;
import org.n52.wps.algorithm.descriptor.LiteralDataInputDescriptor;
import org.n52.wps.algorithm.descriptor.LiteralDataOutputDescriptor;
import org.n52.wps.algorithm.descriptor.OutputDescriptor;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;
import org.n52.wps.server.AbstractDescriptorAlgorithm;

public class StringJoinSelfDescribingAlgorithm
extends AbstractDescriptorAlgorithm {
    public static final String INPUT_STRINGS = "INPUT_STRINGS";
    public static final String INPUT_DELIMITER = "INPUT_DELIMITER";
    public static final String OUTPUT_STRING = "OUTPUT_STRING";
    private static AlgorithmDescriptor DESCRIPTOR;

    protected static synchronized AlgorithmDescriptor getAlgorithmDescriptorStatic() {
        if (DESCRIPTOR == null) {
            DESCRIPTOR = ((AlgorithmDescriptor.Builder)((AlgorithmDescriptor.Builder)AlgorithmDescriptor.builder(StringJoinSelfDescribingAlgorithm.class).version("0.0.1").title("String Join Algorithm (Self Describing)")).abstrakt("This is an example algorithm implementation described using a chained builder that joins strings using the specified delimiter.")).statusSupported(false).storeSupported(false).addInputDescriptor(((LiteralDataInputDescriptor.Builder)((LiteralDataInputDescriptor.Builder)((LiteralDataInputDescriptor.Builder)LiteralDataInputDescriptor.stringBuilder((String)INPUT_STRINGS).title("Input Strings")).abstrakt("The strings you want joined.")).minOccurs(2)).maxOccurs(32)).addInputDescriptor((InputDescriptor.Builder)((LiteralDataInputDescriptor.Builder)((LiteralDataInputDescriptor.Builder)LiteralDataInputDescriptor.stringBuilder((String)INPUT_DELIMITER).title("Delimiter")).abstrakt("The value to use when joining strings")).allowedValues(Delimiter.class)).addOutputDescriptor((OutputDescriptor.Builder)((LiteralDataOutputDescriptor.Builder)LiteralDataOutputDescriptor.stringBuilder((String)OUTPUT_STRING).title("Output String")).abstrakt("The strings joined with the delimiter")).build();
        }
        return DESCRIPTOR;
    }

    public AlgorithmDescriptor createAlgorithmDescriptor() {
        return StringJoinSelfDescribingAlgorithm.getAlgorithmDescriptorStatic();
    }

    public Map<String, IData> run(Map<String, List<IData>> inputMap) {
        List<IData> inputBoundStringList = inputMap.get(INPUT_STRINGS);
        if (inputBoundStringList == null || inputBoundStringList.size() < 2) {
            this.addError("Invalid parameter count forINPUT_STRINGS");
            return null;
        }
        ArrayList<String> inputStringList = new ArrayList<String>();
        for (IData boundString : inputBoundStringList) {
            if (boundString == null || !(boundString instanceof LiteralStringBinding)) {
                this.addError("unexpected binding ecountered unbinding INPUT_STRINGS parameter list");
                return null;
            }
            String inputString = ((LiteralStringBinding)boundString).getPayload();
            if (inputString == null || inputString.length() == 0) {
                this.addError("invalid value encounterd in INPUT_STRINGS parameter list");
            }
            inputStringList.add(inputString);
        }
        List<IData> inputBoundDelimiterList = inputMap.get(INPUT_DELIMITER);
        if (inputBoundDelimiterList == null || inputBoundDelimiterList.size() != 1) {
            this.addError("Invalid parameter count forINPUT_DELIMITER");
            return null;
        }
        IData inputBoundDelimiterData = inputBoundDelimiterList.get(0);
        if (inputBoundDelimiterData == null || !(inputBoundDelimiterData instanceof LiteralStringBinding)) {
            this.addError("Something wierd happened with the request parser!");
            return null;
        }
        String inputDelimiterString = ((LiteralStringBinding)inputBoundDelimiterData).getPayload();
        Delimiter inputDelimiter = null;
        try {
            inputDelimiter = Delimiter.valueOf(inputDelimiterString);
        }
        catch (IllegalArgumentException e) {
            this.addError("invalid value encounterd for INPUT_DELIMITER parameter");
            return null;
        }
        String outputString = Joiner.on((char)inputDelimiter.value).join(inputStringList);
        HashMap<String, IData> outputMap = new HashMap<String, IData>();
        outputMap.put(OUTPUT_STRING, (IData)new LiteralStringBinding(outputString));
        return outputMap;
    }

    public static enum Delimiter {
        SPACE(' '),
        TAB('\t'),
        PIPE('|'),
        COMMA(','),
        SEMI_COLON(';'),
        COLON(':');

        public final char value;

        private Delimiter(char value) {
            this.value = value;
        }
    }
}

