/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server;

import java.util.HashMap;
import junit.framework.TestCase;
import net.opengis.wps.x100.ProcessDescriptionType;
import org.apache.xmlbeans.XmlOptions;
import org.n52.test.mock.MockUtil;
import org.n52.wps.server.ComplexAnnotatedAlgorithm;
import org.n52.wps.server.ComplexSelfDescribingAlgorithmUsingDescriptor;
import org.n52.wps.server.IAlgorithm;
import org.n52.wps.server.StringJoinAnnotatedAlgorithm;
import org.n52.wps.server.StringJoinSelfDescribingAlgorithm;
import org.n52.wps.server.StringReverseAnnotatedAlgorithm;
import org.n52.wps.server.StringReverseSelfDescribingAlgorithm;

public class AbstractSelfDescribingAlgorithmTest
extends TestCase {
    public AbstractSelfDescribingAlgorithmTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        MockUtil.getMockConfig();
    }

    public void testComplexSelfDescribingAlgorithmUsingDescriptor() {
        ComplexSelfDescribingAlgorithmUsingDescriptor algorithm = new ComplexSelfDescribingAlgorithmUsingDescriptor();
        this.printAlgorithmProcessDescription((IAlgorithm)algorithm);
    }

    public void testComplexAnnotatedAlgorithm() {
        ComplexAnnotatedAlgorithm algorithm = new ComplexAnnotatedAlgorithm();
        this.printAlgorithmProcessDescription((IAlgorithm)algorithm);
    }

    public void testStringReverseSelfDescribingAlgorithm() {
        StringReverseSelfDescribingAlgorithm algorithm = new StringReverseSelfDescribingAlgorithm();
        this.printAlgorithmProcessDescription((IAlgorithm)algorithm);
    }

    public void testStringReverseAnnotatedAlgorithm() {
        StringReverseAnnotatedAlgorithm algorithm = new StringReverseAnnotatedAlgorithm();
        this.printAlgorithmProcessDescription((IAlgorithm)algorithm);
    }

    public void testStringJoinSelfDescribingAlgorithm() {
        StringJoinSelfDescribingAlgorithm algorithm = new StringJoinSelfDescribingAlgorithm();
        this.printAlgorithmProcessDescription((IAlgorithm)algorithm);
    }

    public void testStringJoinAnnotatedAlgorithm() {
        StringJoinAnnotatedAlgorithm algorithm = new StringJoinAnnotatedAlgorithm();
        this.printAlgorithmProcessDescription((IAlgorithm)algorithm);
    }

    private void printAlgorithmProcessDescription(IAlgorithm algorithm) {
        System.out.println();
        System.out.println(" ### DescribeProcess for " + algorithm.getClass().getName() + " ###");
        System.out.println(this.getXMLAsStringFromDescription(algorithm.getDescription()));
        System.out.println();
    }

    private String getXMLAsStringFromDescription(ProcessDescriptionType decription) {
        XmlOptions options = new XmlOptions();
        options.setSavePrettyPrint();
        options.setSaveOuter();
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("http://www.opengis.net/wps/1.0.0", "wps");
        ns.put("http://www.opengis.net/ows/1.1", "ows");
        options.setSaveNamespacesFirst().setSaveSuggestedPrefixes(ns).setSaveAggressiveNamespaces();
        return decription.xmlText(options);
    }
}

