/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.algorithm.descriptor;

import junit.framework.TestCase;
import org.n52.wps.algorithm.descriptor.LiteralDataOutputDescriptor;
import org.n52.wps.io.data.binding.literal.LiteralAnyURIBinding;
import org.n52.wps.io.data.binding.literal.LiteralBooleanBinding;
import org.n52.wps.io.data.binding.literal.LiteralByteBinding;
import org.n52.wps.io.data.binding.literal.LiteralDateTimeBinding;
import org.n52.wps.io.data.binding.literal.LiteralDoubleBinding;
import org.n52.wps.io.data.binding.literal.LiteralFloatBinding;
import org.n52.wps.io.data.binding.literal.LiteralIntBinding;
import org.n52.wps.io.data.binding.literal.LiteralLongBinding;
import org.n52.wps.io.data.binding.literal.LiteralShortBinding;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;

public class LiteralDataOutputDescriptorTest
extends TestCase {
    public LiteralDataOutputDescriptorTest(String testName) {
        super(testName);
    }

    public void testStaticBuilder() {
        LiteralDataOutputDescriptor descriptor = LiteralDataOutputDescriptor.builder((String)"mock_identifier", LiteralStringBinding.class).build();
        LiteralDataOutputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataOutputDescriptorTest.assertEquals(LiteralStringBinding.class, (Object)descriptor.getBinding());
        boolean thrown = false;
        try {
            LiteralDataOutputDescriptor.builder(null, LiteralStringBinding.class);
            LiteralDataOutputDescriptorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        LiteralDataOutputDescriptorTest.assertTrue((boolean)thrown);
        thrown = false;
        try {
            LiteralDataOutputDescriptor.builder((String)"", LiteralStringBinding.class);
            LiteralDataOutputDescriptorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        LiteralDataOutputDescriptorTest.assertTrue((boolean)thrown);
        thrown = false;
        try {
            LiteralDataOutputDescriptor.builder((String)"mock_identifier", null);
            LiteralDataOutputDescriptorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        LiteralDataOutputDescriptorTest.assertTrue((boolean)thrown);
    }

    public void testAnyURIBuilder() {
        LiteralDataOutputDescriptor descriptor = LiteralDataOutputDescriptor.anyURIBuilder((String)"mock_identifier").build();
        LiteralDataOutputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataOutputDescriptorTest.assertEquals(LiteralAnyURIBinding.class, (Object)descriptor.getBinding());
        LiteralDataOutputDescriptorTest.assertEquals((String)"xs:anyURI", (String)descriptor.getDataType());
    }

    public void testBase64BinaryBuilder() {
        LiteralDataOutputDescriptor descriptor = LiteralDataOutputDescriptor.anyURIBuilder((String)"mock_identifier").build();
        LiteralDataOutputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataOutputDescriptorTest.assertEquals(LiteralAnyURIBinding.class, (Object)descriptor.getBinding());
        LiteralDataOutputDescriptorTest.assertEquals((String)"xs:anyURI", (String)descriptor.getDataType());
    }

    public void testBooleanBuilder() {
        LiteralDataOutputDescriptor descriptor = LiteralDataOutputDescriptor.booleanBuilder((String)"mock_identifier").build();
        LiteralDataOutputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataOutputDescriptorTest.assertEquals(LiteralBooleanBinding.class, (Object)descriptor.getBinding());
        LiteralDataOutputDescriptorTest.assertEquals((String)"xs:boolean", (String)descriptor.getDataType());
    }

    public void testByteBuilder() {
        LiteralDataOutputDescriptor descriptor = LiteralDataOutputDescriptor.byteBuilder((String)"mock_identifier").build();
        LiteralDataOutputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataOutputDescriptorTest.assertEquals(LiteralByteBinding.class, (Object)descriptor.getBinding());
        LiteralDataOutputDescriptorTest.assertEquals((String)"xs:byte", (String)descriptor.getDataType());
    }

    public void testDateTimeBuilder() {
        LiteralDataOutputDescriptor descriptor = LiteralDataOutputDescriptor.dateTimeBuilder((String)"mock_identifier").build();
        LiteralDataOutputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataOutputDescriptorTest.assertEquals(LiteralDateTimeBinding.class, (Object)descriptor.getBinding());
        LiteralDataOutputDescriptorTest.assertEquals((String)"xs:dateTime", (String)descriptor.getDataType());
    }

    public void testDoubleBuilder() {
        LiteralDataOutputDescriptor descriptor = LiteralDataOutputDescriptor.doubleBuilder((String)"mock_identifier").build();
        LiteralDataOutputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataOutputDescriptorTest.assertEquals(LiteralDoubleBinding.class, (Object)descriptor.getBinding());
        LiteralDataOutputDescriptorTest.assertEquals((String)"xs:double", (String)descriptor.getDataType());
    }

    public void testFloatBuilder() {
        LiteralDataOutputDescriptor descriptor = LiteralDataOutputDescriptor.floatBuilder((String)"mock_identifier").build();
        LiteralDataOutputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataOutputDescriptorTest.assertEquals(LiteralFloatBinding.class, (Object)descriptor.getBinding());
        LiteralDataOutputDescriptorTest.assertEquals((String)"xs:float", (String)descriptor.getDataType());
    }

    public void testIntBuilder() {
        LiteralDataOutputDescriptor descriptor = LiteralDataOutputDescriptor.intBuilder((String)"mock_identifier").build();
        LiteralDataOutputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataOutputDescriptorTest.assertEquals(LiteralIntBinding.class, (Object)descriptor.getBinding());
        LiteralDataOutputDescriptorTest.assertEquals((String)"xs:int", (String)descriptor.getDataType());
    }

    public void testLongBuilder() {
        LiteralDataOutputDescriptor descriptor = LiteralDataOutputDescriptor.longBuilder((String)"mock_identifier").build();
        LiteralDataOutputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataOutputDescriptorTest.assertEquals(LiteralLongBinding.class, (Object)descriptor.getBinding());
        LiteralDataOutputDescriptorTest.assertEquals((String)"xs:long", (String)descriptor.getDataType());
    }

    public void testShortBuilder() {
        LiteralDataOutputDescriptor descriptor = LiteralDataOutputDescriptor.shortBuilder((String)"mock_identifier").build();
        LiteralDataOutputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataOutputDescriptorTest.assertEquals(LiteralShortBinding.class, (Object)descriptor.getBinding());
        LiteralDataOutputDescriptorTest.assertEquals((String)"xs:short", (String)descriptor.getDataType());
    }

    public void testStringBuilder() {
        LiteralDataOutputDescriptor descriptor = LiteralDataOutputDescriptor.stringBuilder((String)"mock_identifier").build();
        LiteralDataOutputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataOutputDescriptorTest.assertEquals(LiteralStringBinding.class, (Object)descriptor.getBinding());
        LiteralDataOutputDescriptorTest.assertEquals((String)"xs:string", (String)descriptor.getDataType());
    }
}

