/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.algorithm.descriptor;

import java.math.BigInteger;
import junit.framework.TestCase;
import org.n52.test.mock.MockEnum;
import org.n52.wps.algorithm.descriptor.InputDescriptor;
import org.n52.wps.io.data.IData;

public class InputDataDescriptorTest
extends TestCase {
    public InputDataDescriptorTest(String testName) {
        super(testName);
    }

    public void testMinOccurs() {
        InputDescriptorImpl inputDescriptor = null;
        inputDescriptor = new InputDescriptorImpl.Builder().build();
        InputDataDescriptorTest.assertEquals((Object)BigInteger.valueOf(1L), (Object)inputDescriptor.getMinOccurs());
        inputDescriptor = ((InputDescriptorImpl.Builder)new InputDescriptorImpl.Builder().minOccurs(1)).build();
        InputDataDescriptorTest.assertEquals((Object)BigInteger.valueOf(1L), (Object)inputDescriptor.getMinOccurs());
        inputDescriptor = ((InputDescriptorImpl.Builder)new InputDescriptorImpl.Builder().minOccurs(BigInteger.valueOf(1L))).build();
        InputDataDescriptorTest.assertEquals((Object)BigInteger.valueOf(1L), (Object)inputDescriptor.getMinOccurs());
        inputDescriptor = ((InputDescriptorImpl.Builder)new InputDescriptorImpl.Builder().minOccurs(0)).build();
        InputDataDescriptorTest.assertEquals((Object)BigInteger.valueOf(0L), (Object)inputDescriptor.getMinOccurs());
        inputDescriptor = ((InputDescriptorImpl.Builder)new InputDescriptorImpl.Builder().minOccurs(BigInteger.valueOf(0L))).build();
        InputDataDescriptorTest.assertEquals((Object)BigInteger.valueOf(0L), (Object)inputDescriptor.getMinOccurs());
        boolean thrown = false;
        try {
            new InputDescriptorImpl.Builder().minOccurs(-1);
            InputDataDescriptorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        InputDataDescriptorTest.assertTrue((boolean)thrown);
        thrown = false;
        try {
            new InputDescriptorImpl.Builder().minOccurs(BigInteger.valueOf(-1L));
            InputDataDescriptorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        InputDataDescriptorTest.assertTrue((boolean)thrown);
        thrown = false;
        try {
            ((InputDescriptorImpl.Builder)new InputDescriptorImpl.Builder().minOccurs(2)).build();
            InputDataDescriptorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException e) {
            thrown = true;
        }
        InputDataDescriptorTest.assertTrue((boolean)thrown);
        thrown = false;
        try {
            ((InputDescriptorImpl.Builder)new InputDescriptorImpl.Builder().minOccurs(BigInteger.valueOf(2L))).build();
            InputDataDescriptorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException e) {
            thrown = true;
        }
        InputDataDescriptorTest.assertTrue((boolean)thrown);
    }

    public void testMaxOccurs() {
        InputDescriptorImpl inputDescriptor = null;
        inputDescriptor = new InputDescriptorImpl.Builder().build();
        InputDataDescriptorTest.assertEquals((Object)BigInteger.valueOf(1L), (Object)inputDescriptor.getMaxOccurs());
        inputDescriptor = ((InputDescriptorImpl.Builder)new InputDescriptorImpl.Builder().maxOccurs(1)).build();
        InputDataDescriptorTest.assertEquals((Object)BigInteger.valueOf(1L), (Object)inputDescriptor.getMaxOccurs());
        inputDescriptor = ((InputDescriptorImpl.Builder)new InputDescriptorImpl.Builder().maxOccurs(BigInteger.valueOf(1L))).build();
        InputDataDescriptorTest.assertEquals((Object)BigInteger.valueOf(1L), (Object)inputDescriptor.getMaxOccurs());
        inputDescriptor = ((InputDescriptorImpl.Builder)new InputDescriptorImpl.Builder().maxOccurs(2)).build();
        InputDataDescriptorTest.assertEquals((Object)BigInteger.valueOf(2L), (Object)inputDescriptor.getMaxOccurs());
        inputDescriptor = ((InputDescriptorImpl.Builder)new InputDescriptorImpl.Builder().maxOccurs(BigInteger.valueOf(2L))).build();
        InputDataDescriptorTest.assertEquals((Object)BigInteger.valueOf(2L), (Object)inputDescriptor.getMaxOccurs());
        inputDescriptor = ((InputDescriptorImpl.Builder)new InputDescriptorImpl.Builder().maxOccurs(MockEnum.class)).build();
        InputDataDescriptorTest.assertEquals((Object)BigInteger.valueOf(MockEnum.values().length), (Object)inputDescriptor.getMaxOccurs());
        boolean thrown = false;
        try {
            new InputDescriptorImpl.Builder().maxOccurs(0);
            InputDataDescriptorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        InputDataDescriptorTest.assertTrue((boolean)thrown);
        thrown = false;
        try {
            new InputDescriptorImpl.Builder().maxOccurs(BigInteger.valueOf(0L));
            InputDataDescriptorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        InputDataDescriptorTest.assertTrue((boolean)thrown);
        thrown = false;
        try {
            ((InputDescriptorImpl.Builder)((InputDescriptorImpl.Builder)new InputDescriptorImpl.Builder().minOccurs(3)).maxOccurs(2)).build();
            InputDataDescriptorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException e) {
            thrown = true;
        }
        InputDataDescriptorTest.assertTrue((boolean)thrown);
        thrown = false;
        try {
            ((InputDescriptorImpl.Builder)((InputDescriptorImpl.Builder)new InputDescriptorImpl.Builder().minOccurs(BigInteger.valueOf(3L))).maxOccurs(BigInteger.valueOf(2L))).build();
            InputDataDescriptorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException e) {
            thrown = true;
        }
        InputDataDescriptorTest.assertTrue((boolean)thrown);
    }

    public static class InputDescriptorImpl
    extends InputDescriptor<Class<IData>> {
        private InputDescriptorImpl(Builder builder) {
            super((InputDescriptor.Builder)builder);
        }

        public static class Builder
        extends InputDescriptor.Builder<Builder, Class<IData>> {
            Builder() {
                super("mock_identifier", IData.class);
            }

            protected Builder self() {
                return this;
            }

            public InputDescriptorImpl build() {
                return new InputDescriptorImpl(this);
            }
        }
    }
}

