/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.algorithm.descriptor;

import java.math.BigInteger;
import junit.framework.TestCase;
import org.n52.test.mock.MockBinding;
import org.n52.wps.algorithm.descriptor.ComplexDataInputDescriptor;

public class ComplexDataInputDescriptorTest
extends TestCase {
    public ComplexDataInputDescriptorTest(String testName) {
        super(testName);
    }

    public void testMaximumMegabytes() {
        ComplexDataInputDescriptor descriptor = null;
        descriptor = ComplexDataInputDescriptor.builder((String)"mock_identifier", MockBinding.class).build();
        ComplexDataInputDescriptorTest.assertNull((Object)descriptor.getMaximumMegaBytes());
        ComplexDataInputDescriptorTest.assertFalse((boolean)descriptor.hasMaximumMegaBytes());
        descriptor = ComplexDataInputDescriptor.builder((String)"mock_identifier", MockBinding.class).maximumMegaBytes(0).build();
        ComplexDataInputDescriptorTest.assertNotNull((Object)descriptor.getMaximumMegaBytes());
        ComplexDataInputDescriptorTest.assertEquals((Object)BigInteger.valueOf(0L), (Object)descriptor.getMaximumMegaBytes());
        ComplexDataInputDescriptorTest.assertFalse((boolean)descriptor.hasMaximumMegaBytes());
        descriptor = ComplexDataInputDescriptor.builder((String)"mock_identifier", MockBinding.class).maximumMegaBytes(BigInteger.valueOf(0L)).build();
        ComplexDataInputDescriptorTest.assertNotNull((Object)descriptor.getMaximumMegaBytes());
        ComplexDataInputDescriptorTest.assertEquals((Object)BigInteger.valueOf(0L), (Object)descriptor.getMaximumMegaBytes());
        ComplexDataInputDescriptorTest.assertFalse((boolean)descriptor.hasMaximumMegaBytes());
        descriptor = ComplexDataInputDescriptor.builder((String)"mock_identifier", MockBinding.class).maximumMegaBytes(1).build();
        ComplexDataInputDescriptorTest.assertNotNull((Object)descriptor.getMaximumMegaBytes());
        ComplexDataInputDescriptorTest.assertEquals((Object)BigInteger.valueOf(1L), (Object)descriptor.getMaximumMegaBytes());
        descriptor = ComplexDataInputDescriptor.builder((String)"mock_identifier", MockBinding.class).maximumMegaBytes(BigInteger.valueOf(1L)).build();
        ComplexDataInputDescriptorTest.assertNotNull((Object)descriptor.getMaximumMegaBytes());
        ComplexDataInputDescriptorTest.assertEquals((Object)BigInteger.valueOf(1L), (Object)descriptor.getMaximumMegaBytes());
        descriptor = ComplexDataInputDescriptor.builder((String)"mock_identifier", MockBinding.class).maximumMegaBytes(Integer.MAX_VALUE).build();
        ComplexDataInputDescriptorTest.assertNotNull((Object)descriptor.getMaximumMegaBytes());
        ComplexDataInputDescriptorTest.assertEquals((Object)BigInteger.valueOf(Integer.MAX_VALUE), (Object)descriptor.getMaximumMegaBytes());
        descriptor = ComplexDataInputDescriptor.builder((String)"mock_identifier", MockBinding.class).maximumMegaBytes(BigInteger.valueOf(Integer.MAX_VALUE)).build();
        ComplexDataInputDescriptorTest.assertNotNull((Object)descriptor.getMaximumMegaBytes());
        ComplexDataInputDescriptorTest.assertEquals((Object)BigInteger.valueOf(Integer.MAX_VALUE), (Object)descriptor.getMaximumMegaBytes());
        boolean thrown = false;
        try {
            ComplexDataInputDescriptor.builder((String)"mock_identifier", MockBinding.class).maximumMegaBytes(-1);
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        ComplexDataInputDescriptorTest.assertTrue((boolean)thrown);
        thrown = false;
        try {
            ComplexDataInputDescriptor.builder((String)"mock_identifier", MockBinding.class).maximumMegaBytes(BigInteger.valueOf(-1L));
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        ComplexDataInputDescriptorTest.assertTrue((boolean)thrown);
        thrown = false;
        try {
            ComplexDataInputDescriptor.builder((String)"mock_identifier", MockBinding.class).maximumMegaBytes(Integer.MIN_VALUE);
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        ComplexDataInputDescriptorTest.assertTrue((boolean)thrown);
        thrown = false;
        try {
            ComplexDataInputDescriptor.builder((String)"mock_identifier", MockBinding.class).maximumMegaBytes(BigInteger.valueOf(Integer.MIN_VALUE));
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        ComplexDataInputDescriptorTest.assertTrue((boolean)thrown);
    }

    public void testStaticBuilder() {
        ComplexDataInputDescriptor descriptor = ComplexDataInputDescriptor.builder((String)"mock_identifier", MockBinding.class).build();
        ComplexDataInputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        ComplexDataInputDescriptorTest.assertEquals(MockBinding.class, (Object)descriptor.getBinding());
        boolean thrown = false;
        try {
            ComplexDataInputDescriptor.builder(null, MockBinding.class);
            ComplexDataInputDescriptorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        ComplexDataInputDescriptorTest.assertTrue((boolean)thrown);
        thrown = false;
        try {
            ComplexDataInputDescriptor.builder((String)"", MockBinding.class);
            ComplexDataInputDescriptorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        ComplexDataInputDescriptorTest.assertTrue((boolean)thrown);
        thrown = false;
        try {
            ComplexDataInputDescriptor.builder((String)"mock_identifier", null);
            ComplexDataInputDescriptorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        ComplexDataInputDescriptorTest.assertTrue((boolean)thrown);
    }
}

