/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.algorithm.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.n52.test.mock.MockBinding;
import org.n52.wps.algorithm.descriptor.AlgorithmDescriptor;
import org.n52.wps.algorithm.descriptor.ComplexDataInputDescriptor;
import org.n52.wps.algorithm.descriptor.ComplexDataOutputDescriptor;
import org.n52.wps.algorithm.descriptor.InputDescriptor;
import org.n52.wps.algorithm.descriptor.LiteralDataInputDescriptor;
import org.n52.wps.algorithm.descriptor.LiteralDataOutputDescriptor;
import org.n52.wps.algorithm.descriptor.OutputDescriptor;

public class AlgorithmDescriptorTest
extends TestCase {
    private LiteralDataOutputDescriptor.Builder MOCK_OUPUT1_BUILDER;
    private List<InputDescriptor.Builder<?, ?>> MOCK_INPUT_BUILDERS;
    private List<OutputDescriptor.Builder<?, ?>> MOCK_OUTPUT_BUILDERS;

    public AlgorithmDescriptorTest(String testName) {
        super(testName);
    }

    protected void setUp() {
        this.MOCK_INPUT_BUILDERS = new ArrayList();
        this.MOCK_INPUT_BUILDERS.add((InputDescriptor.Builder<?, ?>)LiteralDataInputDescriptor.booleanBuilder((String)"mock_input1"));
        this.MOCK_INPUT_BUILDERS.add((InputDescriptor.Builder<?, ?>)LiteralDataInputDescriptor.booleanBuilder((String)"mock_input2"));
        this.MOCK_INPUT_BUILDERS.add((InputDescriptor.Builder<?, ?>)ComplexDataInputDescriptor.builder((String)"mock_input3", MockBinding.class));
        this.MOCK_INPUT_BUILDERS.add((InputDescriptor.Builder<?, ?>)ComplexDataInputDescriptor.builder((String)"mock_input4", MockBinding.class));
        this.MOCK_INPUT_BUILDERS = Collections.unmodifiableList(this.MOCK_INPUT_BUILDERS);
        this.MOCK_OUPUT1_BUILDER = LiteralDataOutputDescriptor.booleanBuilder((String)"mock_output1");
        this.MOCK_OUTPUT_BUILDERS = new ArrayList();
        this.MOCK_OUTPUT_BUILDERS.add((OutputDescriptor.Builder<?, ?>)LiteralDataOutputDescriptor.booleanBuilder((String)"mock_output2"));
        this.MOCK_OUTPUT_BUILDERS.add((OutputDescriptor.Builder<?, ?>)ComplexDataOutputDescriptor.builder((String)"mock_output3", MockBinding.class));
        this.MOCK_OUTPUT_BUILDERS.add((OutputDescriptor.Builder<?, ?>)ComplexDataOutputDescriptor.builder((String)"mock_output4", MockBinding.class));
        this.MOCK_OUTPUT_BUILDERS = Collections.unmodifiableList(this.MOCK_OUTPUT_BUILDERS);
    }

    public void testStaticBuilder_String() {
        AlgorithmDescriptor descriptor = null;
        boolean thrown = false;
        try {
            AlgorithmDescriptor.builder((String)null);
            AlgorithmDescriptorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        AlgorithmDescriptorTest.assertTrue((boolean)thrown);
        descriptor = AlgorithmDescriptor.builder((String)"mock_identifier").addOutputDescriptor((OutputDescriptor.Builder)this.MOCK_OUPUT1_BUILDER).build();
        AlgorithmDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        AlgorithmDescriptorTest.assertTrue((boolean)descriptor.hasTitle());
        AlgorithmDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getTitle());
    }

    public void testStaticBuilder_Class() {
        AlgorithmDescriptor descriptor = null;
        boolean thrown = false;
        try {
            AlgorithmDescriptor.builder((Class)null);
            AlgorithmDescriptorTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException e) {
            thrown = true;
        }
        AlgorithmDescriptorTest.assertTrue((boolean)thrown);
        descriptor = AlgorithmDescriptor.builder(((Object)((Object)this)).getClass()).addOutputDescriptor((OutputDescriptor.Builder)this.MOCK_OUPUT1_BUILDER).build();
        AlgorithmDescriptorTest.assertEquals((String)((Object)((Object)this)).getClass().getCanonicalName(), (String)descriptor.getIdentifier());
        AlgorithmDescriptorTest.assertTrue((boolean)descriptor.hasTitle());
        AlgorithmDescriptorTest.assertEquals((String)((Object)((Object)this)).getClass().getCanonicalName(), (String)descriptor.getTitle());
    }

    public void testVersion() {
        AlgorithmDescriptor descriptor = null;
        descriptor = this.createMinimumCompliantBuilder().build();
        AlgorithmDescriptorTest.assertEquals((String)"1.0.0", (String)descriptor.getVersion());
        descriptor = this.createMinimumCompliantBuilder().version("X.Y.Z").build();
        AlgorithmDescriptorTest.assertEquals((String)"X.Y.Z", (String)descriptor.getVersion());
    }

    public void testStoreSupported() {
        AlgorithmDescriptor descriptor = null;
        descriptor = this.createMinimumCompliantBuilder().build();
        AlgorithmDescriptorTest.assertTrue((boolean)descriptor.getStoreSupported());
        descriptor = this.createMinimumCompliantBuilder().storeSupported(true).build();
        AlgorithmDescriptorTest.assertTrue((boolean)descriptor.getStoreSupported());
        descriptor = this.createMinimumCompliantBuilder().storeSupported(false).build();
        AlgorithmDescriptorTest.assertFalse((boolean)descriptor.getStoreSupported());
    }

    public void testStatusSupported() {
        AlgorithmDescriptor descriptor = null;
        descriptor = this.createMinimumCompliantBuilder().build();
        AlgorithmDescriptorTest.assertTrue((boolean)descriptor.getStatusSupported());
        descriptor = this.createMinimumCompliantBuilder().statusSupported(true).build();
        AlgorithmDescriptorTest.assertTrue((boolean)descriptor.getStatusSupported());
        descriptor = this.createMinimumCompliantBuilder().statusSupported(false).build();
        AlgorithmDescriptorTest.assertFalse((boolean)descriptor.getStatusSupported());
    }

    public void testInputDescriptorHandling() {
        AlgorithmDescriptor descriptor = null;
        descriptor = this.createMinimumCompliantBuilder().build();
        AlgorithmDescriptorTest.assertNotNull((Object)descriptor.getInputDescriptors());
        AlgorithmDescriptorTest.assertEquals((int)0, (int)descriptor.getInputDescriptors().size());
        AlgorithmDescriptorTest.assertNotNull((Object)descriptor.getInputIdentifiers());
        AlgorithmDescriptorTest.assertEquals((int)0, (int)descriptor.getInputIdentifiers().size());
        AlgorithmDescriptor.Builder<?> builder = this.createMinimumCompliantBuilder();
        for (InputDescriptor.Builder<?, ?> inputBuilder : this.MOCK_INPUT_BUILDERS) {
            builder.addInputDescriptor(inputBuilder);
        }
        this.validateInputDescriptors(builder.build());
        builder = this.createMinimumCompliantBuilder();
        for (InputDescriptor.Builder<?, ?> inputBuilder : this.MOCK_INPUT_BUILDERS) {
            builder.addInputDescriptor(inputBuilder.build());
        }
        this.validateInputDescriptors(builder.build());
        builder = this.createMinimumCompliantBuilder();
        ArrayList<InputDescriptor> inputDescriptorList = new ArrayList<InputDescriptor>(this.MOCK_INPUT_BUILDERS.size());
        for (InputDescriptor.Builder<?, ?> inputBuilder : this.MOCK_INPUT_BUILDERS) {
            inputDescriptorList.add(inputBuilder.build());
        }
        builder.addInputDescriptors(inputDescriptorList);
        this.validateInputDescriptors(builder.build());
    }

    public void testOutputDescriptorHanding() {
        AlgorithmDescriptor descriptor = null;
        boolean thrown = false;
        try {
            AlgorithmDescriptor.builder((String)"mock_identifier").build();
            AlgorithmDescriptorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalStateException e) {
            thrown = true;
        }
        AlgorithmDescriptorTest.assertTrue((boolean)thrown);
        descriptor = this.createMinimumCompliantBuilder().build();
        AlgorithmDescriptorTest.assertNotNull((Object)descriptor.getOutputDescriptors());
        AlgorithmDescriptorTest.assertEquals((int)1, (int)descriptor.getOutputDescriptors().size());
        AlgorithmDescriptorTest.assertNotNull((Object)descriptor.getOutputIdentifiers());
        AlgorithmDescriptorTest.assertEquals((int)1, (int)descriptor.getOutputIdentifiers().size());
        AlgorithmDescriptor.Builder<?> builder = this.createMinimumCompliantBuilder();
        for (OutputDescriptor.Builder<?, ?> outputBuilder : this.MOCK_OUTPUT_BUILDERS) {
            builder.addOutputDescriptor(outputBuilder);
        }
        this.validateOutputDescriptors(builder.build());
        builder = this.createMinimumCompliantBuilder();
        for (OutputDescriptor.Builder<?, ?> outputBuilder : this.MOCK_OUTPUT_BUILDERS) {
            builder.addOutputDescriptor(outputBuilder.build());
        }
        this.validateOutputDescriptors(builder.build());
        builder = this.createMinimumCompliantBuilder();
        ArrayList<OutputDescriptor> outputDescriptorList = new ArrayList<OutputDescriptor>(this.MOCK_OUTPUT_BUILDERS.size());
        for (OutputDescriptor.Builder<?, ?> outputBuilder : this.MOCK_OUTPUT_BUILDERS) {
            outputDescriptorList.add(outputBuilder.build());
        }
        builder.addOutputDescriptors(outputDescriptorList);
        this.validateOutputDescriptors(builder.build());
    }

    private AlgorithmDescriptor.Builder<?> createMinimumCompliantBuilder() {
        return AlgorithmDescriptor.builder((String)"mock_identifier").addOutputDescriptor((OutputDescriptor.Builder)this.MOCK_OUPUT1_BUILDER);
    }

    private void validateInputDescriptors(AlgorithmDescriptor algorithmDescriptor) {
        AlgorithmDescriptorTest.assertNotNull((Object)algorithmDescriptor.getInputDescriptors());
        Collection collection = algorithmDescriptor.getInputDescriptors();
        AlgorithmDescriptorTest.assertEquals((int)4, (int)collection.size());
        Iterator iterator = collection.iterator();
        InputDescriptor inputDescriptor = (InputDescriptor)iterator.next();
        AlgorithmDescriptorTest.assertNotNull((Object)inputDescriptor);
        AlgorithmDescriptorTest.assertEquals((String)"mock_input1", (String)inputDescriptor.getIdentifier());
        inputDescriptor = (InputDescriptor)iterator.next();
        AlgorithmDescriptorTest.assertNotNull((Object)inputDescriptor);
        AlgorithmDescriptorTest.assertEquals((String)"mock_input2", (String)inputDescriptor.getIdentifier());
        inputDescriptor = (InputDescriptor)iterator.next();
        AlgorithmDescriptorTest.assertNotNull((Object)inputDescriptor);
        AlgorithmDescriptorTest.assertEquals((String)"mock_input3", (String)inputDescriptor.getIdentifier());
        inputDescriptor = (InputDescriptor)iterator.next();
        AlgorithmDescriptorTest.assertNotNull((Object)inputDescriptor);
        AlgorithmDescriptorTest.assertEquals((String)"mock_input4", (String)inputDescriptor.getIdentifier());
        AlgorithmDescriptorTest.assertFalse((boolean)iterator.hasNext());
        AlgorithmDescriptorTest.assertNotNull((Object)algorithmDescriptor.getInputDescriptor("mock_input1"));
        AlgorithmDescriptorTest.assertNotNull((Object)algorithmDescriptor.getInputDescriptor("mock_input2"));
        AlgorithmDescriptorTest.assertNotNull((Object)algorithmDescriptor.getInputDescriptor("mock_input3"));
        AlgorithmDescriptorTest.assertNotNull((Object)algorithmDescriptor.getInputDescriptor("mock_input4"));
        AlgorithmDescriptorTest.assertEquals((String)algorithmDescriptor.getInputDescriptor("mock_input1").getIdentifier(), (String)"mock_input1");
        AlgorithmDescriptorTest.assertEquals((String)algorithmDescriptor.getInputDescriptor("mock_input2").getIdentifier(), (String)"mock_input2");
        AlgorithmDescriptorTest.assertEquals((String)algorithmDescriptor.getInputDescriptor("mock_input3").getIdentifier(), (String)"mock_input3");
        AlgorithmDescriptorTest.assertEquals((String)algorithmDescriptor.getInputDescriptor("mock_input4").getIdentifier(), (String)"mock_input4");
        List inputIdentifierList = algorithmDescriptor.getInputIdentifiers();
        AlgorithmDescriptorTest.assertEquals((int)4, (int)inputIdentifierList.size());
        AlgorithmDescriptorTest.assertEquals((String)"mock_input1", (String)((String)inputIdentifierList.get(0)));
        AlgorithmDescriptorTest.assertEquals((String)"mock_input2", (String)((String)inputIdentifierList.get(1)));
        AlgorithmDescriptorTest.assertEquals((String)"mock_input3", (String)((String)inputIdentifierList.get(2)));
        AlgorithmDescriptorTest.assertEquals((String)"mock_input4", (String)((String)inputIdentifierList.get(3)));
    }

    private void validateOutputDescriptors(AlgorithmDescriptor algorithmDescriptor) {
        AlgorithmDescriptorTest.assertNotNull((Object)algorithmDescriptor.getOutputDescriptors());
        Collection collection = algorithmDescriptor.getOutputDescriptors();
        AlgorithmDescriptorTest.assertEquals((int)4, (int)collection.size());
        Iterator iterator = collection.iterator();
        OutputDescriptor outputDescriptor = (OutputDescriptor)iterator.next();
        AlgorithmDescriptorTest.assertNotNull((Object)outputDescriptor);
        AlgorithmDescriptorTest.assertEquals((String)"mock_output1", (String)outputDescriptor.getIdentifier());
        outputDescriptor = (OutputDescriptor)iterator.next();
        AlgorithmDescriptorTest.assertNotNull((Object)outputDescriptor);
        AlgorithmDescriptorTest.assertEquals((String)"mock_output2", (String)outputDescriptor.getIdentifier());
        outputDescriptor = (OutputDescriptor)iterator.next();
        AlgorithmDescriptorTest.assertNotNull((Object)outputDescriptor);
        AlgorithmDescriptorTest.assertEquals((String)"mock_output3", (String)outputDescriptor.getIdentifier());
        outputDescriptor = (OutputDescriptor)iterator.next();
        AlgorithmDescriptorTest.assertNotNull((Object)outputDescriptor);
        AlgorithmDescriptorTest.assertEquals((String)"mock_output4", (String)outputDescriptor.getIdentifier());
        AlgorithmDescriptorTest.assertFalse((boolean)iterator.hasNext());
        AlgorithmDescriptorTest.assertNotNull((Object)algorithmDescriptor.getOutputDescriptor("mock_output1"));
        AlgorithmDescriptorTest.assertNotNull((Object)algorithmDescriptor.getOutputDescriptor("mock_output2"));
        AlgorithmDescriptorTest.assertNotNull((Object)algorithmDescriptor.getOutputDescriptor("mock_output3"));
        AlgorithmDescriptorTest.assertNotNull((Object)algorithmDescriptor.getOutputDescriptor("mock_output4"));
        AlgorithmDescriptorTest.assertEquals((String)algorithmDescriptor.getOutputDescriptor("mock_output1").getIdentifier(), (String)"mock_output1");
        AlgorithmDescriptorTest.assertEquals((String)algorithmDescriptor.getOutputDescriptor("mock_output2").getIdentifier(), (String)"mock_output2");
        AlgorithmDescriptorTest.assertEquals((String)algorithmDescriptor.getOutputDescriptor("mock_output3").getIdentifier(), (String)"mock_output3");
        AlgorithmDescriptorTest.assertEquals((String)algorithmDescriptor.getOutputDescriptor("mock_output4").getIdentifier(), (String)"mock_output4");
        List outputIdentifierList = algorithmDescriptor.getOutputIdentifiers();
        AlgorithmDescriptorTest.assertEquals((int)4, (int)outputIdentifierList.size());
        AlgorithmDescriptorTest.assertEquals((String)"mock_output1", (String)((String)outputIdentifierList.get(0)));
        AlgorithmDescriptorTest.assertEquals((String)"mock_output2", (String)((String)outputIdentifierList.get(1)));
        AlgorithmDescriptorTest.assertEquals((String)"mock_output3", (String)((String)outputIdentifierList.get(2)));
        AlgorithmDescriptorTest.assertEquals((String)"mock_output4", (String)((String)outputIdentifierList.get(3)));
    }
}

