/*
 * Decompiled with CFR 0.152.
 */
package org.n52.test.mock;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.n52.test.mock.MockBinding;
import org.n52.test.mock.MockParser;
import org.n52.test.mock.MockUtil;
import org.n52.wps.FormatDocument;
import org.n52.wps.io.IGenerator;
import org.n52.wps.io.data.IData;

public class MockGenerator
implements IGenerator {
    public static final List<String> schemaSet = Collections.unmodifiableList(new ArrayList<String>(MockUtil.getParserSupportedSchemas(MockParser.class)));
    public static final List<String> formatSet = Collections.unmodifiableList(new ArrayList<String>(MockUtil.getParserSupportedFormats(MockParser.class)));
    public static final List<String> encodingSet = Collections.unmodifiableList(new ArrayList<String>(MockUtil.getParserSupportedEncodings(MockParser.class)));

    public boolean isSupportedSchema(String schema) {
        return schemaSet.contains(schema);
    }

    public boolean isSupportedFormat(String format) {
        return formatSet.contains(format);
    }

    public boolean isSupportedEncoding(String encoding) {
        return encodingSet.contains(encoding);
    }

    public String[] getSupportedSchemas() {
        return schemaSet.toArray(new String[0]);
    }

    public String[] getSupportedFormats() {
        return formatSet.toArray(new String[0]);
    }

    public String[] getSupportedEncodings() {
        return encodingSet.toArray(new String[0]);
    }

    public InputStream generateStream(IData data, String mimeType, String schema) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public InputStream generateBase64Stream(IData data, String mimeType, String schema) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isSupportedDataBinding(Class<?> clazz) {
        return Arrays.binarySearch(this.getSupportedDataBindings(), clazz) > -1;
    }

    public FormatDocument.Format[] getSupportedFullFormats() {
        FormatDocument.Format f = FormatDocument.Format.Factory.newInstance();
        f.setSchema(schemaSet.get(0));
        f.setEncoding(encodingSet.get(0));
        f.setMimetype(formatSet.get(0));
        return new FormatDocument.Format[]{f};
    }

    public Class<?>[] getSupportedDataBindings() {
        return new Class[]{MockBinding.class};
    }
}

