/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.testsuite.test.scan.namemapping;

import java.io.IOException;
import java.util.Set;
import org.apache.log4j.Logger;
import org.gcube.data.spd.plugin.fwk.capabilities.NamesMappingCapability;
import org.gcube.data.spd.testsuite.provider.CloseableIterator;
import org.gcube.data.spd.testsuite.test.AbstractTest;
import org.gcube.data.spd.testsuite.test.Result;
import org.gcube.data.spd.testsuite.test.TestType;
import org.gcube.data.spd.testsuite.test.scan.namemapping.NamesMappingMethodCall;

public abstract class NamesMappingScanTest
extends AbstractTest {
    protected Logger logger = Logger.getLogger(NamesMappingScanTest.class);
    protected NamesMappingMethodCall callMethod;

    public NamesMappingScanTest(String name, String description, NamesMappingMethodCall callMethod) {
        super(name, description, TestType.SCAN);
        this.callMethod = callMethod;
    }

    public Result scanNamesMappingMethod(NamesMappingCapability namesMapping, CloseableIterator<String> valuesProvider) {
        int valuesCounter = 0;
        int success = 0;
        this.logger.trace((Object)"starting");
        while (valuesProvider.hasNext()) {
            String sn = (String)valuesProvider.next();
            ++valuesCounter;
            Result result = this.test(namesMapping, sn);
            if (result != Result.SUCCESS) continue;
            ++success;
        }
        try {
            valuesProvider.close();
        }
        catch (IOException e) {
            this.logger.warn((Object)"Failed closing the values stream", (Throwable)e);
        }
        int failed = valuesCounter - success;
        this.logger.info((Object)("Tested " + valuesCounter + " values, " + success + " successfully and " + failed + " failed"));
        return failed == 0 ? Result.SUCCESS : Result.FAILED;
    }

    protected Result test(NamesMappingCapability namesMapping, String value) {
        Set<String> result;
        this.logger.trace((Object)("testing value \"" + value + "\""));
        try {
            result = this.callMethod.call(namesMapping, value);
        }
        catch (Throwable throwable) {
            this.logger.info((Object)("Failed call to " + this.callMethod.getMethodName() + " method with value \"" + value + "\""), throwable);
            return Result.FAILED;
        }
        this.logger.debug((Object)("Tested value \"" + value + "\" found " + result.size() + " elements"));
        return Result.SUCCESS;
    }
}

