/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.testsuite.test.scan.classification;

import java.io.IOException;
import org.gcube.data.spd.model.TaxonomyItem;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.testsuite.provider.CloseableIterator;
import org.gcube.data.spd.testsuite.provider.Transformator;
import org.gcube.data.spd.testsuite.provider.common.Transformators;
import org.gcube.data.spd.testsuite.provider.sn.ScientificNameProvider;
import org.gcube.data.spd.testsuite.test.NeedsScientificNameProvider;
import org.gcube.data.spd.testsuite.test.Result;
import org.gcube.data.spd.testsuite.test.scan.classification.ClassificationMethodCall;
import org.gcube.data.spd.testsuite.test.scan.classification.ClassificationScanTest;

public class ClassificationSNScanTest
extends ClassificationScanTest
implements NeedsScientificNameProvider {
    protected ScientificNameProvider scientificNameProvider;

    public ClassificationSNScanTest(String name, String description, ClassificationMethodCall method) {
        super(name, description, method);
    }

    @Override
    public void setScientificNameProvider(ScientificNameProvider scientificNameProvider) {
        this.scientificNameProvider = scientificNameProvider;
    }

    @Override
    public Result run(AbstractPlugin plugin) {
        ClassificationCapability classification = plugin.getClassificationInterface();
        CloseableIterator<String> provider = this.getScientificNames();
        Transformator<String, CloseableIterator<TaxonomyItem>> generator = Transformators.fromSearchableWithScientificName(classification);
        return this.run(classification, provider, generator);
    }

    protected CloseableIterator<String> getScientificNames() {
        try {
            return this.scientificNameProvider.getScientificNames();
        }
        catch (IOException e) {
            this.logger.fatal((Object)"Error occurred getting the scientific names", (Throwable)e);
            throw new RuntimeException("Error occurred getting the scientific names", e);
        }
    }
}

