/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.testsuite.test.scan.classification;

import java.io.IOException;
import org.gcube.data.spd.model.TaxonomyItem;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.testsuite.provider.CloseableIterator;
import org.gcube.data.spd.testsuite.provider.Transformator;
import org.gcube.data.spd.testsuite.provider.cn.CommonNameProvider;
import org.gcube.data.spd.testsuite.provider.common.Transformators;
import org.gcube.data.spd.testsuite.test.NeedsCommonNameProvider;
import org.gcube.data.spd.testsuite.test.Result;
import org.gcube.data.spd.testsuite.test.scan.classification.ClassificationMethodCall;
import org.gcube.data.spd.testsuite.test.scan.classification.ClassificationScanTest;

public class ClassificationCNScanTest
extends ClassificationScanTest
implements NeedsCommonNameProvider {
    protected CommonNameProvider commonNameProvider;

    public ClassificationCNScanTest(String name, String description, ClassificationMethodCall method) {
        super(name, description, method);
    }

    @Override
    public void setCommonNameProvider(CommonNameProvider scientificNameProvider) {
        this.commonNameProvider = scientificNameProvider;
    }

    @Override
    public Result run(AbstractPlugin plugin) {
        ClassificationCapability classification = plugin.getClassificationInterface();
        CloseableIterator<String> provider = this.getScientificNames();
        Transformator<String, CloseableIterator<TaxonomyItem>> generator = Transformators.fromSearchableWithCommonName(classification);
        return this.run(classification, provider, generator);
    }

    protected CloseableIterator<String> getScientificNames() {
        try {
            return this.commonNameProvider.getCommonNames();
        }
        catch (IOException e) {
            this.logger.fatal((Object)"Error occurred getting the common names", (Throwable)e);
            throw new RuntimeException("Error occurred getting the common names", e);
        }
    }
}

