/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.testsuite.provider;

import java.io.IOException;
import java.util.List;
import org.gcube.data.spd.testsuite.provider.CloseableIterator;

public class CloseableIteratorMerger<E>
implements CloseableIterator<E> {
    protected List<CloseableIterator<E>> iterators;
    protected int currentIteratorIndex;

    public CloseableIteratorMerger(List<CloseableIterator<E>> iterators) {
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() {
        this.ensureProvider();
        return this.currentIteratorIndex < this.iterators.size() && this.iterators.get(this.currentIteratorIndex).hasNext();
    }

    protected void ensureProvider() {
        if (this.currentIteratorIndex < this.iterators.size() && !this.iterators.get(this.currentIteratorIndex).hasNext()) {
            try {
                this.iterators.get(this.currentIteratorIndex).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++this.currentIteratorIndex;
        }
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("No more elements");
        }
        return this.iterators.get(this.currentIteratorIndex).next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        int i = this.currentIteratorIndex;
        while (i < this.iterators.size()) {
            try {
                this.iterators.get(i).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
    }
}

