/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.testsuite.provider;

import java.io.IOException;
import org.gcube.data.spd.testsuite.provider.CloseableIterator;

public class CloseableIteratorIterator<E>
implements CloseableIterator<E> {
    protected CloseableIterator<CloseableIterator<E>> iterators;
    protected CloseableIterator<E> currentIterator;

    public CloseableIteratorIterator(CloseableIterator<CloseableIterator<E>> iterators) {
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() {
        this.ensureProvider();
        return this.currentIterator != null && this.currentIterator.hasNext();
    }

    protected void ensureProvider() {
        while (this.iterators.hasNext() && (this.currentIterator == null || !this.currentIterator.hasNext())) {
            try {
                if (this.currentIterator != null) {
                    this.currentIterator.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.currentIterator = (CloseableIterator)this.iterators.next();
        }
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("No more elements");
        }
        return this.currentIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        if (this.currentIterator != null) {
            this.currentIterator.close();
        }
        while (this.iterators.hasNext()) {
            try {
                ((CloseableIterator)this.iterators.next()).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

