/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.testsuite.provider;

import java.io.IOException;
import org.gcube.data.spd.testsuite.provider.CloseableIterator;
import org.gcube.data.spd.testsuite.provider.Provider;

public class ProviderIterator<E>
implements CloseableIterator<E> {
    protected Provider<E> provider;
    protected E nextElement;
    protected boolean nextConsumed;
    protected boolean closed;

    public ProviderIterator(Provider<E> provider) {
        this.provider = provider;
        this.nextConsumed = true;
        this.closed = false;
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            throw new IllegalStateException("Iterator closed");
        }
        this.ensureNext();
        return !this.nextConsumed && this.nextElement != null;
    }

    protected void ensureNext() {
        if (this.nextConsumed) {
            this.nextElement = this.provider.next();
            this.nextConsumed = false;
        }
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("There are no more elements");
        }
        this.nextConsumed = true;
        return this.nextElement;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.provider.close();
    }
}

