/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.testsuite.provider.common;

import org.gcube.data.spd.plugin.fwk.Capabilities;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.model.Product;
import org.gcube.data.spd.plugin.fwk.model.ResultElement;
import org.gcube.data.spd.plugin.fwk.model.ResultItem;
import org.gcube.data.spd.plugin.fwk.model.Searchable;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.testsuite.provider.CloseableIterator;
import org.gcube.data.spd.testsuite.provider.IteratorWrapper;
import org.gcube.data.spd.testsuite.provider.Transformator;
import org.gcube.data.spd.testsuite.test.common.ListObjectWriter;
import org.gcube.data.spd.testsuite.test.scan.searchable.SearchableMethodCall;

public class Transformators {
    public static Transformator<TaxonomyItem, String> ID_EXTRACTOR = new Transformator<TaxonomyItem, String>(){

        @Override
        public String transform(TaxonomyItem input) {
            return input.getId();
        }
    };
    public static Transformator<OccurrencePoint, String> OP_ID_EXTRACTOR = new Transformator<OccurrencePoint, String>(){

        @Override
        public String transform(OccurrencePoint input) {
            return input.getId();
        }
    };

    public static Transformator<ResultItem, String> extractProductKey(final Capabilities capability) {
        return new Transformator<ResultItem, String>(){

            @Override
            public String transform(ResultItem input) {
                for (Product product : input.getProducts()) {
                    if (product.getType() != capability) continue;
                    return product.getKey();
                }
                return null;
            }
        };
    }

    public static <S extends Searchable<T>, T extends ResultElement> Transformator<String, CloseableIterator<T>> fromSearchableWithScientificName(S searchable) {
        return Transformators.fromSearchable(searchable, SearchableMethodCall.SCIENTIFIC_NAME);
    }

    public static <S extends Searchable<T>, T extends ResultElement> Transformator<String, CloseableIterator<T>> fromSearchableWithCommonName(S searchable) {
        return Transformators.fromSearchable(searchable, SearchableMethodCall.COMMON_NAME);
    }

    public static <S extends Searchable<T>, T extends ResultElement> Transformator<String, CloseableIterator<T>> fromSearchable(final S searchable, final SearchableMethodCall methodCall) {
        return new Transformator<String, CloseableIterator<T>>(){

            @Override
            public CloseableIterator<T> transform(String value) {
                ListObjectWriter writer = new ListObjectWriter();
                methodCall.call(searchable, value, writer, new Property[0]);
                return new IteratorWrapper(writer.getElements().iterator());
            }
        };
    }
}

