/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.testsuite.provider.common;

import java.io.IOException;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.model.Searchable;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.testsuite.provider.CloseableIterator;
import org.gcube.data.spd.testsuite.provider.IteratorWrapper;
import org.gcube.data.spd.testsuite.test.common.ListObjectWriter;

public class TaxonomyIteratorGenerator
implements CloseableIterator<CloseableIterator<TaxonomyItem>> {
    protected CloseableIterator<String> scientificNameStream;
    protected Searchable<TaxonomyItem> searchable;

    public TaxonomyIteratorGenerator(CloseableIterator<String> scientificNameStream, Searchable<TaxonomyItem> searchable) {
        this.scientificNameStream = scientificNameStream;
        this.searchable = searchable;
    }

    @Override
    public boolean hasNext() {
        return this.scientificNameStream.hasNext();
    }

    @Override
    public CloseableIterator<TaxonomyItem> next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("There are no more elements");
        }
        String scientificName = (String)this.scientificNameStream.next();
        ListObjectWriter writer = new ListObjectWriter();
        this.searchable.searchByScientificName(scientificName, writer, new Property[0]);
        return new IteratorWrapper<TaxonomyItem>(writer.getElements().iterator());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.scientificNameStream.close();
    }
}

