/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.databases.structure;

import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataaccess.databases.structure.AbstractTableStructure;
import org.gcube.dataaccess.databases.utils.DatabaseFactory;
import org.hibernate.SessionFactory;

public class PostgresTableStructure
extends AbstractTableStructure {
    public PostgresTableStructure(String Schemaname, String TableName, SessionFactory dbSession) throws Exception {
        super(Schemaname, TableName, dbSession);
    }

    @Override
    protected void buildStructure(SessionFactory dbSession) throws Exception {
        String queryForStructure = this.getQueryForTableStructure(dbSession);
        String queryStructure = String.format(queryForStructure, this.tableName, this.databaseName);
        List<Object> resultSet = DatabaseFactory.executeSQLQuery(queryStructure, dbSession);
        if (resultSet == null) {
            AnalysisLogger.getLogger().debug((Object)("PostgresTableStructure->Error: Results not available. Check that the database and schema names are correct" + queryStructure));
            throw new Exception("Results not available. Check that the database and schema names are correct");
        }
        AnalysisLogger.getLogger().debug((Object)("PostgresTableStructure->Building Structure with query: " + queryStructure));
        int resultsNumber = resultSet.size();
        int i = 0;
        while (i < resultsNumber) {
            String tot;
            Object result = resultSet.get(i);
            Object[] resultArray = (Object[])result;
            String columnname = ((String)resultArray[0]).toLowerCase();
            if (columnname.equalsIgnoreCase("class")) {
                columnname = "classcolumn";
            }
            this.ColumnNames.add(columnname);
            String yesno = (String)resultArray[2];
            if (yesno.equalsIgnoreCase("YES")) {
                this.IsNullables.add(true);
            } else {
                this.IsNullables.add(false);
            }
            String type = (String)resultArray[3];
            if (resultArray[1] != null && resultArray[3].toString().equals("integer")) {
                if (resultArray[1].toString().startsWith("nextval('")) {
                    type = "serial";
                }
                if (resultArray[4] != null) {
                    tot = "";
                    this.charset = resultArray[4].toString();
                    tot = String.valueOf(type) + "(" + this.charset + ")";
                    this.TypesList.add(tot);
                } else {
                    this.TypesList.add(type);
                }
            } else if (type.equals("USER-DEFINED")) {
                type = (String)resultArray[5];
                if (resultArray[4] != null) {
                    tot = "";
                    this.charset = resultArray[4].toString();
                    tot = String.valueOf(type) + "(" + this.charset + ")";
                    this.TypesList.add(tot);
                } else {
                    this.TypesList.add(type);
                }
            } else if (resultArray[4] != null) {
                tot = "";
                this.charset = resultArray[4].toString();
                tot = String.valueOf(type) + "(" + this.charset + ")";
                this.TypesList.add(tot);
            } else {
                this.TypesList.add(type);
            }
            if (resultArray[1] == null || resultArray[1].toString().startsWith("nextval('")) {
                this.DefaultValues.add(null);
            } else {
                this.DefaultValues.add((String)resultArray[1]);
            }
            ++i;
        }
        this.parseIndexes(dbSession);
    }

    private void parseIndexes(SessionFactory dbSession) throws Exception {
        String queryForIndexes = this.getQueryForIndexes(dbSession);
        String queryStructure = String.format(queryForIndexes, this.tableName);
        List<Object> resultSet = DatabaseFactory.executeSQLQuery(queryStructure, dbSession);
        AnalysisLogger.getLogger().debug((Object)("PostgresTableStructure->Building Structure with query adding keys: " + queryStructure));
        if (resultSet != null) {
            int resultsNumber = resultSet.size();
            int i = 0;
            while (i < resultsNumber) {
                Object result = resultSet.get(i);
                Object[] resultArray = (Object[])result;
                String columnKey = (String)resultArray[1];
                if (columnKey.equals("PRIMARY KEY")) {
                    this.ColumnKeys.add((String)resultArray[3]);
                } else if (columnKey.equals("UNIQUE KEY")) {
                    this.UniqueKeys.add((String)resultArray[3]);
                } else if (columnKey.equals("FOREIGN KEY")) {
                    this.UniqueKeys.add((String)resultArray[3]);
                }
                ++i;
            }
        }
    }

    @Override
    protected String getQueryForTableStructure(SessionFactory dbSession) throws Exception {
        String queryForStructure = "SELECT column_name,column_default,is_nullable,data_type,character_maximum_length,udt_name  FROM information_schema.COLUMNS WHERE table_name ='%1$s' and table_schema='%2$s' order by ordinal_position asc;";
        return queryForStructure;
    }

    @Override
    protected String getQueryForIndexes(SessionFactory dbSession) throws Exception {
        String queryForIndexes = "SELECT tc.constraint_name,tc.constraint_type,tc.table_name,kcu.column_name,tc.is_deferrable,tc.initially_deferred,rc.match_option AS match_type,rc.update_rule AS on_update,rc.delete_rule AS on_delete,ccu.table_name AS references_table,ccu.column_name AS references_field FROM information_schema.table_constraints tc LEFT JOIN information_schema.key_column_usage kcu ON tc.constraint_catalog = kcu.constraint_catalog AND tc.constraint_schema = kcu.constraint_schema AND tc.constraint_name = kcu.constraint_name LEFT JOIN information_schema.referential_constraints rc ON tc.constraint_catalog = rc.constraint_catalog AND tc.constraint_schema = rc.constraint_schema AND tc.constraint_name = rc.constraint_name LEFT JOIN information_schema.constraint_column_usage ccu ON rc.unique_constraint_catalog = ccu.constraint_catalog AND rc.unique_constraint_schema = ccu.constraint_schema AND rc.unique_constraint_name = ccu.constraint_name where tc.table_name='%1$s' and tc.constraint_type<>'CHECK'";
        return queryForIndexes;
    }
}

