/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.databases.utils;

import java.io.ByteArrayInputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.FileTools;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;

public class DatabaseFactory {
    public static SessionFactory initDBConnection(String configurationFile) throws Exception {
        String xml = FileTools.readXMLDoc((String)configurationFile);
        SessionFactory DBSessionFactory = null;
        Configuration cfg = new Configuration();
        cfg = cfg.configure(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes())));
        DBSessionFactory = cfg.buildSessionFactory();
        return DBSessionFactory;
    }

    public static List<Object> executeSQLQuery(String query, SessionFactory DBSessionFactory) throws Exception {
        return DatabaseFactory.executeHQLQuery(query, DBSessionFactory, true);
    }

    public static List<Object> executeHQLQuery(String query, SessionFactory DBSessionFactory, boolean useSQL) throws Exception, MappingException {
        Session ss = null;
        List obj = null;
        ss = DBSessionFactory.getCurrentSession();
        ss.beginTransaction();
        Object qr = null;
        qr = useSQL ? ss.createSQLQuery(query) : ss.createQuery(query);
        List result = null;
        AnalysisLogger.getLogger().debug((Object)("In DatabaseFactory->" + qr.getQueryString()));
        try {
            result = qr.list();
            ss.getTransaction().commit();
            if (result == null) {
                System.out.println("Hibernate doesn't return a valid object when org.gcube.contentmanagement.lexicalmatcher retrieve UserState Object");
            }
            if (result != null && result.size() != 0) {
                obj = result;
            }
            DatabaseFactory.rollback((org.hibernate.Session)ss);
            return obj;
        }
        catch (Exception e) {
            if (e.getClass().toString().contains("org.hibernate.exception.SQLGrammarException")) {
                AnalysisLogger.getLogger().debug((Object)("In DatabaseFactory-> " + e.getCause().getLocalizedMessage()));
                throw new Exception(e.getCause().getMessage());
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rollback(org.hibernate.Session ss) {
        try {
            if (ss != null && ss.getTransaction() != null) {
                ss.getTransaction().rollback();
            }
        }
        catch (Exception ex) {
        }
        finally {
            try {
                ss.close();
            }
            catch (Exception ee) {}
        }
    }
}

