/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.databases.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.FileTools;
import org.gcube.dataaccess.databases.utils.AliasToEntityOrderedMapResultTransformer;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.transform.ResultTransformer;

public class ConnectionManager {
    public SessionFactory initDBConnection(AlgorithmConfiguration config) {
        SessionFactory dbconnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)config);
        return dbconnection;
    }

    public SessionFactory initDBConnection(String configurationFile) throws Exception {
        String xml = FileTools.readXMLDoc((String)configurationFile);
        SessionFactory DBSessionFactory = null;
        Configuration cfg = new Configuration();
        cfg = cfg.configure(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes())));
        DBSessionFactory = cfg.buildSessionFactory();
        return DBSessionFactory;
    }

    public AlgorithmConfiguration setconfiguration(String ConfigPath, String DatabaseUserName, String DatabasePassword, String DatabaseDriver, String DatabaseDialect, String DatabaseURL, String DatabaseName) throws IOException {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        if (DatabaseName.equals("")) {
            throw new MalformedURLException("Invalid Url: the database's name is not present");
        }
        if (!ConfigPath.equals("")) {
            config.setConfigPath(ConfigPath);
        }
        if (!DatabaseUserName.equals("")) {
            config.setParam("DatabaseUserName", DatabaseUserName);
        }
        if (!DatabasePassword.equals("")) {
            config.setParam("DatabasePassword", DatabasePassword);
        }
        if (!DatabaseDriver.equals("")) {
            config.setParam("DatabaseDriver", DatabaseDriver);
        }
        if (!DatabaseDialect.equals("")) {
            config.setParam("DatabaseDialect", DatabaseDialect);
        }
        if (!DatabaseURL.equals("")) {
            config.setParam("DatabaseURL", DatabaseURL);
        }
        return config;
    }

    public List<Object> executeQuery(String query, SessionFactory DBSessionFactory) throws Exception {
        List obj = null;
        Session ss = null;
        try {
            ss = DBSessionFactory.getCurrentSession();
            ss.beginTransaction();
            SQLQuery qr = null;
            String keyword = "show create table";
            String regex = ".*\\b" + keyword.replaceAll(" +", "[ ]\\+") + "\\b.*";
            if (!query.toLowerCase().contains("explain") && !query.toLowerCase().matches(regex)) {
                if ((query = query.trim()).endsWith(";")) {
                    int endIndex = query.indexOf(";");
                    query = query.substring(0, endIndex);
                }
                query = "select * from (" + query + ") as query";
            }
            AnalysisLogger.getLogger().debug((Object)("In ConnectionManager-> executing query: " + query));
            qr = ss.createSQLQuery(query);
            qr.setResultTransformer((ResultTransformer)AliasToEntityOrderedMapResultTransformer.INSTANCE);
            List result = qr.list();
            AnalysisLogger.getLogger().debug((Object)("In ConnectionManager-> result's size: " + result.size()));
            ss.getTransaction().commit();
            if (result == null || result.size() == 0) {
                AnalysisLogger.getLogger().debug((Object)"ConnectionManager->Error: Result not available");
                throw new Exception("Result not available");
            }
            obj = result;
        }
        catch (Exception e) {
            if (e.getClass().toString().contains("org.hibernate.MappingException")) {
                AnalysisLogger.getLogger().debug((Object)"In ConnectionManager-> ERROR The query could not be executed: Error in retrieving a user defined type. Try to use a store procedure to convert the type");
                throw new Exception("The query could not be executed: Error in retrieving a user defined type. Try to use a store procedure to convert the type");
            }
            if (e.getClass().toString().contains("org.hibernate.exception.SQLGrammarException")) {
                AnalysisLogger.getLogger().debug((Object)("In ConnectionManager-> " + e.getCause().getLocalizedMessage()));
                throw new Exception(e.getCause().getMessage());
            }
            throw e;
        }
        return obj;
    }
}

