/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.algorithms.test.regressiontest;

import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;
import org.gcube.dataanalysis.ecoengine.test.regression.Regressor;

public class RegressionSubmitQuery {
    static String[] algorithms = new String[]{"Postgres1"};
    static AlgorithmConfiguration[] configs = new AlgorithmConfiguration[]{RegressionSubmitQuery.testPostgres1()};

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < algorithms.length; ++i) {
            AnalysisLogger.getLogger().debug((Object)("Executing:" + algorithms[i]));
            List trans = null;
            trans = TransducerersFactory.getTransducerers((AlgorithmConfiguration)configs[i]);
            ((ComputationalAgent)trans.get(0)).init();
            Regressor.process((ComputationalAgent)((ComputationalAgent)trans.get(0)));
            StatisticalType st = ((ComputationalAgent)trans.get(0)).getOutput();
            AnalysisLogger.getLogger().debug((Object)("ST:" + st));
            Object var2_2 = null;
        }
    }

    private static AlgorithmConfiguration testPostgres1() {
        System.out.println("TEST 1: Postgres table without rows");
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setAgent("LISTSUBMITQUERY");
        config.setParam("ResourceName", "Geoserver database ");
        config.setParam("DatabaseName", "aquamapsdb");
        config.setParam("SchemaName", "public");
        config.setParam("Read-Only Query", "true");
        config.setParam("Apply Smart Correction", "FALSE");
        config.setParam("Language", "NONE");
        config.setParam("Query", "select st_astext(the_geom) from\"SeaVoX_sea_areas_polygons_v14\"limit 1");
        config.setGcubeScope("/gcube/devsec");
        return config;
    }

    private static AlgorithmConfiguration Mysql() {
        System.out.println("TEST 2: Mysql");
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setAgent("LISTSUBMITQUERY");
        config.setParam("ResourceName", "CatalogOfLife2010");
        config.setParam("DatabaseName", "col2oct2010");
        config.setParam("TableName", "Common_names");
        config.setParam("Read-Only Query", "TRUE");
        config.setParam("Apply Smart Correction", "FALSE");
        config.setParam("Language", "NONE");
        config.setParam("Query", "select * from common_names as a join distribution as b on a.name_code=b.name_code");
        config.setGcubeScope("/gcube/devsec");
        return config;
    }

    private static AlgorithmConfiguration Postgres3() {
        System.out.println("TEST 3: Postgis");
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setAgent("LISTSUBMITQUERY");
        config.setParam("ResourceName", "Geoserver database ");
        config.setParam("DatabaseName", "aquamapsdb");
        config.setParam("SchemaName", "public");
        config.setParam("TableName", "Divisions");
        config.setParam("Query", "select the_geom from Divisions limit 3");
        config.setGcubeScope("/gcube/devsec");
        return config;
    }

    private static AlgorithmConfiguration Postgres4() {
        System.out.println("TEST 4: Postgis filter query");
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setAgent("LISTSUBMITQUERY");
        config.setParam("ResourceName", "Geoserver database ");
        config.setParam("DatabaseName", "aquamapsdb");
        config.setParam("SchemaName", "public");
        config.setParam("TableName", "Divisions");
        config.setParam("Query", "EXPLAIN ANALYZE select gid from Divisions limit 3");
        config.setGcubeScope("/gcube/devsec");
        return config;
    }

    private static AlgorithmConfiguration NullInputValue1() {
        System.out.println("TEST 5: Postgis NullInputValue1");
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setAgent("LISTSUBMITQUERY");
        config.setParam("DatabaseName", "aquamapsdb");
        config.setParam("SchemaName", "public");
        config.setParam("TableName", "Divisions");
        config.setParam("Query", "EXPLAIN ANALYZE select gid from Divisions limit 3");
        config.setGcubeScope("/gcube/devsec");
        return config;
    }

    private static AlgorithmConfiguration NullInputValue2() {
        System.out.println("TEST 5: Postgis NullInputValue2");
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setAgent("LISTSUBMITQUERY");
        config.setParam("ResourceName", "Geoserver database ");
        config.setParam("SchemaName", "public");
        config.setParam("TableName", "Divisions");
        config.setParam("Query", "EXPLAIN ANALYZE select gid from Divisions limit 3");
        config.setGcubeScope("/gcube/devsec");
        return config;
    }

    private static AlgorithmConfiguration NullInputValue3() {
        System.out.println("TEST 5: Postgis NullInputValue3");
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setAgent("LISTSUBMITQUERY");
        config.setParam("ResourceName", "Geoserver database ");
        config.setParam("DatabaseName", "aquamapsdb");
        config.setParam("TableName", "Divisions");
        config.setParam("Query", "EXPLAIN ANALYZE select gid from Divisions limit 3");
        config.setGcubeScope("/gcube/devsec");
        return config;
    }

    private static AlgorithmConfiguration NullInputValue4() {
        System.out.println("TEST 5: Postgis NullInputValue4");
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setAgent("LISTSUBMITQUERY");
        config.setParam("ResourceName", "Geoserver database ");
        config.setParam("DatabaseName", "aquamapsdb");
        config.setParam("SchemaName", "public");
        config.setParam("Query", "EXPLAIN ANALYZE select gid from Divisions limit 3");
        config.setGcubeScope("/gcube/devsec");
        return config;
    }

    private static AlgorithmConfiguration NullInputValue5() {
        System.out.println("TEST 6: Postgis NullInputValue5");
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setAgent("LISTSUBMITQUERY");
        config.setParam("ResourceName", "Geoserver database ");
        config.setParam("DatabaseName", "aquamapsdb");
        config.setParam("SchemaName", "public");
        config.setParam("TableName", "Divisions");
        config.setGcubeScope("/gcube/devsec");
        return config;
    }

    private static AlgorithmConfiguration Postgis() {
        System.out.println("TEST 7: Postgis");
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setAgent("LISTSUBMITQUERY");
        config.setParam("ResourceName", "Geoserver database ");
        config.setParam("DatabaseName", "aquamapsdb");
        config.setParam("SchemaName", "public");
        config.setParam("TableName", "Divisions");
        config.setParam("Query", "select * from \"Divisions\" limit 1");
        config.setGcubeScope("/gcube/devsec");
        return config;
    }
}

