/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.algorithms.drmalgorithms;

import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.parser.ParseException;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataaccess.algorithms.drmalgorithms.SmartCorrectionEnum;
import org.gcube.dataaccess.databases.access.DatabasesDiscoverer;
import org.gcube.dataaccess.databases.lexer.MySQLLexicalAnalyzer;
import org.gcube.dataaccess.databases.lexer.PostgresLexicalAnalyzer;
import org.gcube.dataaccess.databases.resources.DBResource;
import org.gcube.dataaccess.databases.utils.DatabaseManagement;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalInfraAlgorithm;
import org.gcube.resources.discovery.client.api.DiscoveryException;
import org.gcube.resources.discovery.client.api.InvalidResultException;
import org.hibernate.HibernateException;

public class SubmitQuery
extends StandardLocalInfraAlgorithm {
    private static final String FILE = "File";
    private static final String TOTAL_ROWS = "Total Rows";
    static long maximum_execution_time = 1800000L;
    private LinkedHashMap<String, StatisticalType> map = new LinkedHashMap();
    private DatabaseManagement mgt;
    private String driverInfo;
    private Connection dbconnection;
    private String resourceName = null;
    private String databaseName = null;
    private String query = null;
    private String valueReadOnly = "Read-Only Query";
    private String smartCorrection = "Apply Smart Correction";
    private String dialect = "Language";
    private String valueRO;
    private String valueSC;
    private String valueDialect = "";
    private boolean NotAllowedQuery = false;

    public void init() throws Exception {
        this.mgt = new DatabaseManagement(this.config.getConfigPath());
        AnalysisLogger.getLogger().debug((Object)"In SubmitQuery->Initialization");
        String scope = this.config.getGcubeScope();
        AnalysisLogger.getLogger().debug((Object)("In SubmitQuery->scope set by config object: " + scope));
        this.valueRO = this.config.getParam(this.valueReadOnly);
        this.valueSC = this.config.getParam(this.smartCorrection);
    }

    public String getDescription() {
        return "Algorithm that allows to submit a query";
    }

    protected void process() throws Exception, IOException, IllegalStateException, DiscoveryException, InvalidResultException, HibernateException {
        AnalysisLogger.getLogger().debug((Object)"In SubmitQuery->Processing");
        Timer stopper = new Timer();
        stopper.schedule((TimerTask)new ExecutionStopper(), maximum_execution_time);
        try {
            List<String> Info = this.retrieveInfo();
            this.dbconnection = this.getConnection(Info);
            this.map = this.submitQuery();
        }
        catch (HibernateException h) {
            AnalysisLogger.getLogger().debug((Object)("In SubmitQuery-> " + h.getMessage()));
            throw h;
        }
        catch (IllegalStateException e) {
            AnalysisLogger.getLogger().debug((Object)("In SubmitQuery-> " + e.getMessage()));
            throw e;
        }
        catch (DiscoveryException e1) {
            AnalysisLogger.getLogger().debug((Object)("In SubmitQuery-> " + e1.getMessage()));
            throw e1;
        }
        catch (InvalidResultException e2) {
            AnalysisLogger.getLogger().debug((Object)("In SubmitQuery-> " + e2.getMessage()));
            throw e2;
        }
        catch (IOException e3) {
            AnalysisLogger.getLogger().debug((Object)("In SubmitQuery-> " + e3.getMessage()));
            throw e3;
        }
        catch (Exception e4) {
            AnalysisLogger.getLogger().debug((Object)("In SubmitQuery-> " + e4.getMessage()));
            throw e4;
        }
        finally {
            if (this.dbconnection != null) {
                this.dbconnection.close();
                AnalysisLogger.getLogger().debug((Object)"In SubmitQuery-> Connection closed");
                this.dbconnection = null;
            }
            if (stopper != null) {
                try {
                    stopper.cancel();
                    stopper.purge();
                    AnalysisLogger.getLogger().debug((Object)"In SubmitQuery-> Execution stopper terminated");
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().debug((Object)("In SubmitQuery-> Could not stop execution stopper " + e.getMessage()));
                }
            }
        }
    }

    public StatisticalType getOutput() {
        AnalysisLogger.getLogger().debug((Object)"In SubmitQuery->retrieving outputs");
        PrimitiveType output = new PrimitiveType(LinkedHashMap.class.getName(), this.map, PrimitiveTypes.MAP, "ResultsMap" + UUID.randomUUID(), "Results Map");
        return output;
    }

    public List<StatisticalType> getInputParameters() {
        ArrayList<StatisticalType> parameters = new ArrayList<StatisticalType>();
        PrimitiveType p0 = new PrimitiveType(String.class.getName(), (Object)"", PrimitiveTypes.STRING, "ResourceName", "The name of the resource");
        PrimitiveType p1 = new PrimitiveType(String.class.getName(), (Object)"", PrimitiveTypes.STRING, "DatabaseName", "The name of the database");
        PrimitiveType p2 = new PrimitiveType(Boolean.class.getName(), null, PrimitiveTypes.BOOLEAN, this.valueReadOnly, "Check the box if the query must be read-only", "true");
        PrimitiveType p3 = new PrimitiveType(Boolean.class.getName(), null, PrimitiveTypes.BOOLEAN, this.smartCorrection, "Check the box for smart correction", "true");
        PrimitiveType p4 = new PrimitiveType(Enum.class.getName(), (Object)SmartCorrectionEnum.values(), PrimitiveTypes.ENUMERATED, this.dialect, "Language", SmartCorrectionEnum.NONE.name());
        PrimitiveType p5 = new PrimitiveType(String.class.getName(), (Object)"", PrimitiveTypes.STRING, "Query", "query");
        parameters.add((StatisticalType)p0);
        parameters.add((StatisticalType)p1);
        parameters.add((StatisticalType)p2);
        parameters.add((StatisticalType)p3);
        parameters.add((StatisticalType)p4);
        parameters.add((StatisticalType)p5);
        return parameters;
    }

    protected void setInputParameters() {
    }

    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"In SubmitQuery->Shutdown");
        try {
            if (this.dbconnection != null) {
                this.dbconnection.close();
                AnalysisLogger.getLogger().debug((Object)"In SubmitQuery-> Connection closed");
                this.dbconnection = null;
            }
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("In SubmitQuery->Unable to close connection " + e.getMessage()));
        }
    }

    private List<String> retrieveInfo() throws Exception, IllegalStateException, DiscoveryException, InvalidResultException {
        this.resourceName = this.getInputParameter("ResourceName");
        if (this.resourceName != null) {
            this.resourceName = this.getInputParameter("ResourceName").trim();
        }
        if (this.resourceName == null || this.resourceName.equals("")) {
            throw new Exception("Warning: insert the resource name");
        }
        this.databaseName = this.getInputParameter("DatabaseName");
        if (this.databaseName != null) {
            this.databaseName = this.getInputParameter("DatabaseName").trim();
        }
        if (this.databaseName == null || this.databaseName.equals("")) {
            throw new Exception("Warning: insert the database name");
        }
        DatabasesDiscoverer discovery = new DatabasesDiscoverer();
        List resources = discovery.discover();
        AnalysisLogger.getLogger().debug((Object)("In SubmitQuery->number of elements: " + resources.size()));
        ArrayList<String> info = new ArrayList<String>();
        block0: for (int i = 0; i < resources.size(); ++i) {
            if (!((DBResource)resources.get(i)).getResourceName().toLowerCase().equals(this.resourceName.toLowerCase())) continue;
            this.normalizeDBInfo((DBResource)resources.get(i));
            for (int j = 0; j < ((DBResource)resources.get(i)).getAccessPoints().size(); ++j) {
                if (!((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDatabaseName().toLowerCase().equals(this.databaseName.toLowerCase())) continue;
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getUsername());
                AnalysisLogger.getLogger().debug((Object)("In SubmitQuery->username: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getUsername()));
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getPassword());
                AnalysisLogger.getLogger().debug((Object)("In SubmitQuery->password: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getPassword()));
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDriver());
                this.driverInfo = ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDriver();
                AnalysisLogger.getLogger().debug((Object)("In SubmitQuery->driver: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDriver()));
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDialect());
                AnalysisLogger.getLogger().debug((Object)("In SubmitQuery->dialect: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDialect()));
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).address());
                AnalysisLogger.getLogger().debug((Object)("In SubmitQuery->url: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).address()));
                info.add(this.databaseName);
                AnalysisLogger.getLogger().debug((Object)("In SubmitQuery->databasename: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDatabaseName()));
                break block0;
            }
        }
        AnalysisLogger.getLogger().debug((Object)"In SubmitQuery->information useful for connection: retrieved");
        return info;
    }

    private Connection getConnection(List<String> Info) throws Exception {
        Iterator<String> iterator = Info.iterator();
        String DatabaseUserName = iterator.next();
        String DatabasePassword = iterator.next();
        String DatabaseDriver = iterator.next();
        String DatabaseDialect = iterator.next();
        String DatabaseURL = iterator.next();
        String DatabaseName = iterator.next();
        Class.forName(DatabaseDriver);
        Connection conn = DriverManager.getConnection(DatabaseURL, DatabaseUserName, DatabasePassword);
        if (conn != null) {
            AnalysisLogger.getLogger().debug((Object)("In SubmitQuery->database " + DatabaseName + ": connected"));
        }
        return conn;
    }

    private LinkedHashMap<String, StatisticalType> submitQuery() throws Exception, ParseException, ConvertException {
        LinkedHashMap<String, StatisticalType> mapResults = new LinkedHashMap<String, StatisticalType>();
        this.query = this.getInputParameter("Query");
        if (this.query == null || this.query.equals("")) {
            throw new Exception("Warning: insert the query");
        }
        AnalysisLogger.getLogger().debug((Object)("In SubmitQuery->valueRO: " + this.valueRO));
        if (this.valueRO.equals("true")) {
            AnalysisLogger.getLogger().debug((Object)("In SubmitQuery->Analyzing the query: " + this.query));
            this.NotAllowedQuery = this.analyzeQuery(this.query);
        }
        if (!this.NotAllowedQuery) {
            List result = new ArrayList();
            AnalysisLogger.getLogger().debug((Object)("In SubmitQuery->valueSC: " + this.valueSC));
            this.valueDialect = this.getInputParameter(this.dialect);
            AnalysisLogger.getLogger().debug((Object)("In SubmitQuery->valueDialect: " + this.valueDialect));
            if (this.valueSC.equals("true") && !this.valueDialect.equals("NONE")) {
                String smartCorrectedQuery = "";
                AnalysisLogger.getLogger().debug((Object)("In SubmitQuery->applying smart correction on the query: " + this.query));
                if (this.valueDialect.equals("POSTGRES")) {
                    smartCorrectedQuery = this.mgt.smartCorrectionOnQuery(this.query, 4);
                }
                if (this.valueDialect.equals("MYSQL")) {
                    smartCorrectedQuery = this.mgt.smartCorrectionOnQuery(this.query, 5);
                }
                AnalysisLogger.getLogger().debug((Object)("In SubmitQuery-> query converted: " + smartCorrectedQuery));
                this.query = smartCorrectedQuery;
                if (!smartCorrectedQuery.equals("")) {
                    PrimitiveType valQuery = new PrimitiveType(String.class.getName(), (Object)smartCorrectedQuery, PrimitiveTypes.STRING, "Converted Query", "Query Converted");
                    mapResults.put("Query Converted", (StatisticalType)valQuery);
                }
            }
            AnalysisLogger.getLogger().debug((Object)("In SubmitQuery->Submitting the query: " + this.query));
            if (this.driverInfo.toLowerCase().contains("postgres")) {
                result = this.mgt.submitQuery(this.query, this.dbconnection, this.config.getPersistencePath());
            }
            if (this.driverInfo.toLowerCase().contains("mysql")) {
                result = this.mgt.submitQuery(this.query, this.dbconnection, this.config.getPersistencePath());
            }
            if (result == null) {
                throw new Exception("Warning: the table has not rows");
            }
            AnalysisLogger.getLogger().debug((Object)"In SubmitQuery->Query's Result retrieved");
            HashMap mapResult = new HashMap();
            mapResult = this.mgt.getMapQueryResult();
            String encoded = null;
            encoded = new String(((String)mapResult.get("HEADERS")).getBytes(), "UTF-8");
            PrimitiveType val = new PrimitiveType(String.class.getName(), (Object)encoded, PrimitiveTypes.STRING, "Row Header", "Row Header");
            mapResults.put("HEADERS", (StatisticalType)val);
            for (int i = 0; i < mapResult.size() - 1; ++i) {
                encoded = new String(((String)mapResult.get(String.valueOf(i))).getBytes(), "UTF-8");
                String row = "Row " + Integer.toString(i + 1);
                PrimitiveType val1 = new PrimitiveType(String.class.getName(), (Object)encoded, PrimitiveTypes.STRING, row, row);
                mapResults.put(String.valueOf(i), (StatisticalType)val1);
            }
            PrimitiveType fileResult = new PrimitiveType(File.class.getName(), (Object)this.mgt.getFile(), PrimitiveTypes.FILE, FILE, FILE);
            mapResults.put(FILE, (StatisticalType)fileResult);
            PrimitiveType totalRows = new PrimitiveType(String.class.getName(), (Object)String.valueOf(this.mgt.getSubmitQueryTotalRows()), PrimitiveTypes.STRING, TOTAL_ROWS, TOTAL_ROWS);
            mapResults.put(TOTAL_ROWS, (StatisticalType)totalRows);
        }
        return mapResults;
    }

    private boolean analyzeQuery(String query) throws Exception {
        PostgresLexicalAnalyzer obj;
        boolean NotAllowed = false;
        if (this.driverInfo.toLowerCase().contains("postgres")) {
            obj = new PostgresLexicalAnalyzer();
            NotAllowed = obj.analyze(query);
        }
        if (this.driverInfo.toLowerCase().contains("mysql")) {
            obj = new MySQLLexicalAnalyzer();
            NotAllowed = obj.analyze(query);
        }
        AnalysisLogger.getLogger().debug((Object)("In SubmitQuery->Warning: query filtered: " + NotAllowed));
        return NotAllowed;
    }

    private void normalizeDBInfo(DBResource resource) throws Exception {
        try {
            int ap = resource.getAccessPoints().size();
            for (int i = 0; i < ap; ++i) {
                resource.normalize(i);
            }
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("In SubmitQuery->: Error in normalization process" + e.getMessage()));
            throw e;
        }
    }

    private class ExecutionStopper
    extends TimerTask {
        private ExecutionStopper() {
        }

        @Override
        public void run() {
            AnalysisLogger.getLogger().debug((Object)"ExecutionStopper: Stopping execution");
            SubmitQuery.this.shutdown();
        }
    }
}

