/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.dataminer.poolmanager.util.impl;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.util.Properties;
import org.gcube.dataanalysis.dataminer.poolmanager.clients.configuration.Configuration;
import org.gcube.dataanalysis.dataminer.poolmanager.clients.configuration.DMPMClientConfiguratorManager;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Algorithm;
import org.gcube.dataanalysis.dataminer.poolmanager.util.CheckMethod;
import org.gcube.dataanalysis.dataminer.poolmanager.util.impl.SVNUpdaterStaging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckMethodStaging
extends CheckMethod {
    private Logger logger = LoggerFactory.getLogger(CheckMethodStaging.class);

    public boolean algoExists(Algorithm algo) throws Exception {
        this.logger.debug("Looking if algo " + algo.getName() + " exists");
        Configuration stagingConfiguration = DMPMClientConfiguratorManager.getInstance().getStagingConfiguration();
        File file = new File(stagingConfiguration.getGhostAlgoDirectory() + "/" + algo.getName() + ".jar");
        File file2 = new File(stagingConfiguration.getGhostAlgoDirectory() + "/" + algo.getName() + "_interface.jar");
        this.logger.debug("Looking for files " + file.getPath() + " " + file.getPath());
        System.out.println("First file is located to: " + file.getPath());
        System.out.println("Second file is located to: " + file2.getPath());
        if (this.doesExist(file.getPath()) && this.doesExist(file2.getPath())) {
            this.logger.debug("Files found");
            this.copyFromDmToSVN(file);
            this.copyFromDmToSVN(file2);
            System.out.println("Files have been copied to SVN");
            return true;
        }
        this.logger.debug("Files not found");
        System.out.println("Algorithm " + algo.getName() + ".jar and " + algo.getName() + "_interface.jar files are not present at the expected path");
        return false;
    }

    public void deleteFiles(Algorithm a) throws Exception {
        JSch jsch = new JSch();
        Session session = null;
        Channel channel = null;
        ChannelSftp c = null;
        Configuration stagingConfiguration = DMPMClientConfiguratorManager.getInstance().getStagingConfiguration();
        System.out.println("checking existing in env: " + stagingConfiguration.getHost());
        File file = new File(stagingConfiguration.getGhostAlgoDirectory() + "/" + a.getName() + ".jar");
        File file2 = new File(stagingConfiguration.getGhostAlgoDirectory() + "/" + a.getName() + "_interface.jar");
        System.out.println("First file is located to: " + file.getPath());
        System.out.println("Second file is located to: " + file2.getPath());
        jsch.setKnownHosts("~/.ssh/known_hosts");
        String privateKey = "~/.ssh/id_rsa";
        jsch.addIdentity(privateKey);
        System.out.println("Private Key Added.");
        session = jsch.getSession("root", stagingConfiguration.getHost());
        System.out.println("session created.");
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        session.setConfig(config);
        session.connect();
        channel = session.openChannel("sftp");
        channel.connect();
        System.out.println("shell channel connected....");
        c = (ChannelSftp)channel;
        if (this.doesExist(file.getPath()) && this.doesExist(file2.getPath())) {
            c.rm(file.getPath());
            c.rm(file2.getPath());
            System.out.println("Both the files have been deleted");
        } else {
            System.out.println("Files not found");
        }
        channel.disconnect();
        c.disconnect();
        session.disconnect();
    }

    public boolean doesExist(String path) throws Exception {
        boolean success;
        ChannelSftp c;
        Channel channel;
        Session session;
        block2: {
            this.logger.debug("Looking if file " + path + " exists");
            JSch jsch = new JSch();
            session = null;
            channel = null;
            c = null;
            success = false;
            Configuration stagingConfiguration = DMPMClientConfiguratorManager.getInstance().getStagingConfiguration();
            jsch.setKnownHosts("~/.ssh/known_hosts");
            String privateKey = "~/.ssh/id_rsa";
            jsch.addIdentity(privateKey);
            System.out.println("Private Key Added.");
            this.logger.debug("Staging configuration host " + stagingConfiguration.getHost());
            session = jsch.getSession("root", stagingConfiguration.getHost());
            System.out.println("session created.");
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            session.setConfig(config);
            session.connect();
            channel = session.openChannel("sftp");
            channel.connect();
            System.out.println("shell channel connected....");
            c = (ChannelSftp)channel;
            System.out.println(path);
            try {
                c.lstat(path);
                this.logger.debug("File found");
                success = true;
            }
            catch (SftpException e) {
                this.logger.error("File not found", (Throwable)e);
                if (e.id != 2) break block2;
                success = false;
            }
        }
        channel.disconnect();
        c.disconnect();
        session.disconnect();
        this.logger.debug("Operation result " + success);
        return success;
    }

    public void copyFromDmToSVN(File a) throws Exception {
        JSch jsch = new JSch();
        Session session = null;
        SVNUpdaterStaging svnUpdater = new SVNUpdaterStaging();
        Configuration stagingConfiguration = DMPMClientConfiguratorManager.getInstance().getStagingConfiguration();
        jsch.setKnownHosts("~/.ssh/known_hosts");
        String privateKey = "~/.ssh/id_rsa";
        jsch.addIdentity(privateKey);
        System.out.println("Private Key Added.");
        session = jsch.getSession("root", stagingConfiguration.getHost());
        System.out.println("session created.");
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        session.setConfig(config);
        session.connect();
        Channel channel = session.openChannel("sftp");
        channel.connect();
        ChannelSftp sftp = (ChannelSftp)channel;
        sftp.cd(stagingConfiguration.getGhostAlgoDirectory());
        System.out.println("REMOTE : " + stagingConfiguration.getGhostAlgoDirectory() + "/" + a.getName());
        System.out.println("LOCAL : /tmp/" + a.getName());
        sftp.get(stagingConfiguration.getGhostAlgoDirectory() + "/" + a.getName(), "/tmp/" + a.getName());
        channel.disconnect();
        session.disconnect();
        File f = new File("/tmp/" + a.getName());
        svnUpdater.updateAlgorithmFiles(f);
        f.delete();
    }

    public static void main(String[] args) throws Exception {
        CheckMethodStaging a = new CheckMethodStaging();
        System.out.println(a.checkMethod("dataminer-ghost-d.dev.d4science.org", "708e7eb8-11a7-4e9a-816b-c9ed7e7e99fe-98187548"));
    }
}

