/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.dataminer.poolmanager.clients.configuration;

import java.io.IOException;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.dataanalysis.dataminer.poolmanager.clients.ScopedCacheMap;
import org.gcube.dataanalysis.dataminer.poolmanager.clients.configuration.ClientConfigurationCache;
import org.gcube.dataanalysis.dataminer.poolmanager.clients.configuration.Configuration;
import org.gcube.dataanalysis.dataminer.poolmanager.clients.configuration.ConfigurationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNException;

public class DMPMClientConfiguratorManager {
    private final Logger logger;
    static DMPMClientConfiguratorManager instance;
    private ScopedCacheMap cacheMap = new ScopedCacheMap();

    private DMPMClientConfiguratorManager() {
        this.logger = LoggerFactory.getLogger(DMPMClientConfiguratorManager.class);
    }

    private ClientConfigurationCache getCurrentCache() {
        String currentScope = ScopeProvider.instance.get();
        this.logger.debug("Current scope = " + currentScope);
        this.logger.debug("Getting current configuration cache");
        ClientConfigurationCache cache = (ClientConfigurationCache)this.cacheMap.get((Object)currentScope);
        if (cache == null) {
            this.logger.debug("Cache not created yet, creating...");
            cache = new ClientConfigurationCache();
            this.cacheMap.put((Object)currentScope, (Object)cache);
        }
        return cache;
    }

    public static DMPMClientConfiguratorManager getInstance() {
        if (instance == null) {
            instance = new DMPMClientConfiguratorManager();
        }
        return instance;
    }

    public Configuration getProductionConfiguration() {
        return new ConfigurationImpl(ConfigurationImpl.CONFIGURATIONS.PROD, this.getCurrentCache());
    }

    public Configuration getStagingConfiguration() {
        return new ConfigurationImpl(ConfigurationImpl.CONFIGURATIONS.STAGE, this.getCurrentCache());
    }

    public static void main(String[] args) throws IOException, SVNException {
        DMPMClientConfiguratorManager a = new DMPMClientConfiguratorManager();
        ScopeProvider.instance.set("/gcube/devNext/NextNext");
        System.out.println("RESULT 1" + a.getStagingConfiguration().getSVNCRANDepsList());
        System.out.println("RESULT 2" + a.getProductionConfiguration().getRepository());
        System.out.println("RESULT 3" + a.getStagingConfiguration().getSVNMainAlgoRepo());
    }
}

