package org.gcube.dataanalysis.dataminer.poolmanager.util;

import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumInputStream;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.*;

/**
 * Created by ggiammat on 5/9/17.
 */
public class SVNUpdater {


  private SVNRepository svnRepository;

  public SVNUpdater(String rootURL) throws SVNException {
    this.svnRepository = this.getSvnRepository(
        rootURL);
  }


  private SVNRepository getSvnRepository(String url) throws SVNException {
    SVNRepository repository = SVNRepositoryFactory.create(SVNURL.parseURIEncoded(url));
    ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager();
    repository.setAuthenticationManager(authManager);
    System.out.println(repository.getLocation());

    return repository;
  }




  public void updateSVN(String file, List<String> ldep) {
    try {
      final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
      svnRepository.getFile(file, SVNRepository.INVALID_REVISION, null, byteArrayOutputStream);
      String lines[] = byteArrayOutputStream.toString().split("\\r?\\n");
      List<String> aa = this.checkMatch(lines, ldep);
      Collections.sort(aa);

      final SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();

      byte[] originalContents = byteArrayOutputStream.toByteArray();

      final ISVNEditor commitEditor = svnRepository.getCommitEditor("update dependencies", null);
      commitEditor.openRoot(-1);
      commitEditor.openFile(file, -1);

      ByteArrayOutputStream baos = new ByteArrayOutputStream();

      for (String line : aa) {
        baos.write(line.getBytes());
        baos.write("\n".getBytes());
      }
      byte[] bytes = baos.toByteArray();

      commitEditor.applyTextDelta(file,md5(originalContents));

      final String checksum = deltaGenerator.sendDelta(file, new ByteArrayInputStream(originalContents), 0,
          new ByteArrayInputStream(bytes), commitEditor, true);
      commitEditor.closeFile(file, checksum);
      commitEditor.closeEdit();
   
      
    }catch(Exception ex){
		  ex.printStackTrace();
	  }

    finally {
      svnRepository.closeSession();
    }
  }




  public static String md5(byte[] contents) {
    final byte[] tmp = new byte[1024];
    final SVNChecksumInputStream checksumStream = new SVNChecksumInputStream(new ByteArrayInputStream(contents), "md5");
    try {
      while (checksumStream.read(tmp) > 0) {
        //
      }
      return checksumStream.getDigest();
    } catch (IOException e) {
      //never happens
      e.printStackTrace();
      return null;
    } finally {
      SVNFileUtil.closeFile(checksumStream);
    }
  }

  public List<String> checkMatch(String[] lines, List<String> ls) {
    Set<String> ss = new HashSet<String>(ls);
    ss.addAll(Arrays.asList(lines));
    return new ArrayList<>(ss);
  }


}
