/**
 *
 */
package org.gcube.datatransfer.resolver.catalogue.resource;

import java.io.Serializable;
import java.util.Map;

import org.gcube.datacatalogue.ckanutillibrary.server.DataCatalogueRunningCluster.ACCESS_LEVEL_TO_CATALOGUE_PORTLET;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;


/**
 * The Class GatewayCKANCatalogueReference.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR (francesco.mangiacrapa@isti.cnr.it)
 * 
 * Nov 12, 2019
 */


@AllArgsConstructor
@NoArgsConstructor
@Getter
@Setter
@ToString
public class GatewayCKANCatalogueReference implements Serializable{

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;
	
	private String scope;
	
	private String privateVREPortletURL;
	private String publicVREPortletURL;
	private String publicGatewayPortletURL;
	
	private String ckanURL;
	
	public Map<ACCESS_LEVEL_TO_CATALOGUE_PORTLET, String> mapAccessURLToCatalogue;
	
}
