/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.gcube.data.transfer.common.CopyStreamHandler;
import org.gcube.data.transfer.common.Utils;
import org.gcube.data.transfer.common.VFileSystemManager;

public class TransferUtil {
    public static int bufferSize = 1024000;
    private long bytesTransferredForCurrent;
    static int connectiontimeout = 100000000;
    static int transferTimeout = 100000000;
    VFileSystemManager localFSManager = null;
    private ExecutorService pool;
    CopyStreamListener listener = new CopyStreamListener(){

        public void bytesTransferred(long arg0, int arg1, long arg2) {
            TransferUtil.this.bytesTransferredForCurrent = TransferUtil.this.bytesTransferredForCurrent + (long)arg1;
        }

        public void bytesTransferred(CopyStreamEvent arg0) {
        }
    };

    public TransferUtil() throws FileSystemException {
        this.localFSManager = new VFileSystemManager("/");
        this.pool = Executors.newFixedThreadPool(1);
    }

    public int getConnectiontimeout() {
        return connectiontimeout;
    }

    public void setConnectiontimeout(int connectiontimeout) {
        TransferUtil.connectiontimeout = connectiontimeout;
    }

    public int getTransferTimeout() {
        return transferTimeout;
    }

    public void setTransferTimeout(int transferTimeout) {
        TransferUtil.transferTimeout = transferTimeout;
    }

    public static InputStream getInputStream(URI uri, int connectionTimeout) throws FileSystemException {
        connectiontimeout = connectionTimeout;
        FileObject inputFile = TransferUtil.prepareFileObject(uri.toString());
        return inputFile.getContent().getInputStream();
    }

    public synchronized long transfer(URI uri, String outfile) throws Exception {
        this.bytesTransferredForCurrent = 0L;
        FileObject inputFile = TransferUtil.prepareFileObject(uri.toString());
        InputStream sourceFileIn = inputFile.getContent().getInputStream();
        FileOutputStream out = new FileOutputStream(new File(outfile));
        boolean terminate = false;
        this.bytesTransferredForCurrent = 0L;
        CopyStreamHandler handler = new CopyStreamHandler(sourceFileIn, out, inputFile.getContent().getSize(), this.listener);
        try {
            this.pool.execute(handler);
            this.pool.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.pool.shutdownNow();
            throw new Exception("Error while executing the transfer", e);
        }
        terminate = this.pool.awaitTermination(transferTimeout, TimeUnit.MILLISECONDS);
        sourceFileIn.close();
        out.close();
        return this.bytesTransferredForCurrent;
    }

    public synchronized void performTransfer(URI uri, String outfile) throws Exception {
        this.bytesTransferredForCurrent = 0L;
        boolean terminate = false;
        FileObject inputFile = TransferUtil.prepareFileObject(uri.toString());
        InputStream sourceFileIn = inputFile.getContent().getInputStream();
        FileOutputStream out = new FileOutputStream(new File(outfile));
        CopyStreamHandler handler = new CopyStreamHandler(sourceFileIn, out, inputFile.getContent().getSize(), this.listener);
        try {
            this.pool.execute(handler);
            this.pool.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.pool.shutdownNow();
            throw new Exception("Error while executing the transfer", e);
        }
        terminate = this.pool.awaitTermination(transferTimeout, TimeUnit.MILLISECONDS);
        sourceFileIn.close();
        out.close();
    }

    public synchronized void performTransferToFolder(URI uri, String outPath) throws Exception {
        FileObject inputFile = TransferUtil.prepareFileObject(uri.toString());
        InputStream sourceFileIn = inputFile.getContent().getInputStream();
        String outputFile = inputFile.getName().getBaseName();
        if (outPath.endsWith("/")) {
            outPath = outPath.substring(0, outPath.length() - 1);
        }
        String relativeOutputFile = outPath + File.separator + outputFile;
        FileObject absoluteOutputFile = this.localFSManager.resolveFile(relativeOutputFile);
        FileObject absolutePath = this.localFSManager.resolveFile(outPath);
        absolutePath.createFolder();
        boolean terminate = false;
        OutputStream destinationFileOut = absoluteOutputFile.getContent().getOutputStream();
        this.bytesTransferredForCurrent = 0L;
        CopyStreamHandler handler = new CopyStreamHandler(sourceFileIn, destinationFileOut, inputFile.getContent().getSize(), this.listener);
        try {
            this.pool.execute(handler);
            this.pool.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.pool.shutdownNow();
            absoluteOutputFile.delete();
            throw new Exception("Error while executing the transfer", e);
        }
        terminate = this.pool.awaitTermination(transferTimeout, TimeUnit.MILLISECONDS);
        sourceFileIn.close();
        destinationFileOut.close();
    }

    private static FileObject prepareFileObject(String URI2) throws FileSystemException {
        return VFS.getManager().resolveFile(URI2, Utils.createDefaultOptions(URI2, connectiontimeout));
    }
}

