package org.gcube.data.transfer.plugins.thredds;

import static java.util.Collections.singletonMap;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.xml.bind.JAXBException;
import javax.xml.transform.stream.StreamResult;

import org.apache.sis.xml.MarshallerPool;
import org.apache.sis.xml.XML;
import org.opengis.metadata.Metadata;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;

import lombok.Synchronized;

public class ISOMetadataMarshalling {

	private static MarshallerPool pool=null;
	
	
	@Synchronized
	private static MarshallerPool getPool() throws JAXBException {
		if(pool==null)
			pool=new MarshallerPool(
					singletonMap(XML.METADATA_VERSION,"2007"));
		
		return pool;
	}
	
	public static final File asXML(Metadata meta) throws JAXBException, IOException {
		File tmp=File.createTempFile("tmp_meta_", ".xml");
		try (FileWriter fw=new FileWriter(tmp)){

			getPool().acquireMarshaller().marshal(meta,new StreamResult(fw));
			
//			XML.marshal(meta, new StreamResult(fw), singletonMap(XML.METADATA_VERSION,"2007"));
		}
		return tmp;		
	}
	
	
	public static class Mapper  extends NamespacePrefixMapper {
		
		private Map<String, String> namespaceMap = new HashMap<>();

		/**
		 * Create mappings.
		 */
		public Mapper() {
			
			
			
			
			namespaceMap.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
			namespaceMap.put("https://www.intertech.com/software-consulting-services/", "consult");
			namespaceMap.put("http://www.w3.org/2003/05/soap-envelope/", "soap");
		}

		/* (non-Javadoc)
		 * Returning null when not found based on spec.
		 * @see com.sun.xml.bind.marshaller.NamespacePrefixMapper#getPreferredPrefix(java.lang.String, java.lang.String, boolean)
		 */
		@Override
		public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
			return namespaceMap.getOrDefault(namespaceUri, suggestion);
		}
	}
}
