/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.plugins.thredds;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import javax.xml.transform.TransformerException;
import org.gcube.common.resources.gcore.utils.XPathHelper;
import org.gcube.data.transfer.model.plugins.thredds.CatalogCollection;
import org.gcube.data.transfer.model.plugins.thredds.DataSetRoot;
import org.gcube.data.transfer.model.plugins.thredds.DataSetScan;
import org.gcube.data.transfer.model.plugins.thredds.ThreddsCatalog;
import org.gcube.data.transfer.plugins.thredds.CommonXML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLCatalogHandler {
    private static final Logger log = LoggerFactory.getLogger(XMLCatalogHandler.class);
    private static final String DEDICATED_CATALOGS_DATASET_ID = "VRE_Catalogs";
    private static final String LINKED_CATALOGS_XPATH = "//*[local-name()='catalogRef' and parent::node()[local-name()='dataset']]";
    private static final String DECLARED_DATASETSCANS = "//*[local-name()='datasetScan']";
    private static final String DECLARED_DATASETROOT = "//*[local-name()='datasetRoot']";
    private static final String CATALOG_COLLECTION_XPATH = "//*[local-name()='dataset'][child::node()[local-name()='catalogRef']]|//*[@ID='VRE_Catalogs']";
    private static final String CATALOG_REFERENCE_BY_FILE = "//*[local-name()='catalogRef'][@xlink:href='%s']";
    private static final String ELEMENT_BY_ID = "//*[@ID='%s']";
    private static final String catalogReferenceXMLPiece = "<catalogRef xmlns=\"http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0\"\n         xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:title=\"%1$s\" xlink:href=\"%2$s\" ID=\"%3$s\" name=\"%1$s\"/>";
    private XPathHelper helper;
    private Document document;
    private File currentCatalogFile;

    public XMLCatalogHandler(File catalog) throws SAXException, IOException {
        this.currentCatalogFile = catalog;
        this.document = CommonXML.getDocument(catalog);
        this.helper = CommonXML.getHelper(this.document);
    }

    public void registerCatalog(File toRegisterCatalogFile, String toRegisterReference) throws SAXException, IOException {
        String filename = toRegisterCatalogFile.getName();
        String ID = filename.contains(".") ? filename.substring(0, filename.lastIndexOf(46)) : filename;
        String toSetString = String.format(catalogReferenceXMLPiece, toRegisterReference, filename, ID);
        log.info("Checking if file is already referenced..");
        log.debug("Checking by filname {} ", (Object)filename);
        String referenceByFilenameXPATH = String.format(CATALOG_REFERENCE_BY_FILE, filename);
        NodeList filenameReferencesNodelist = this.helper.evaluateForNodes(referenceByFilenameXPATH);
        if (filenameReferencesNodelist.getLength() > 0) {
            log.info("Filename {} is already declared. Updateing reference..", (Object)filename);
            CommonXML.addContent(referenceByFilenameXPATH, this.document, toSetString, this.helper, CommonXML.Position.replace);
        } else {
            log.debug("Checking by ID {} ", (Object)ID);
            String referenceByIDXPATH = String.format(ELEMENT_BY_ID, ID);
            NodeList IDReferencesNodelist = this.helper.evaluateForNodes(referenceByIDXPATH);
            if (IDReferencesNodelist.getLength() > 0) {
                log.info("ID {} found. Updateing reference..", (Object)ID);
                CommonXML.addContent(referenceByIDXPATH, this.document, toSetString, this.helper, CommonXML.Position.replace);
            } else {
                log.info("No similar entries found. Adding reference..");
                String catalogCollectionXPATH = String.format(ELEMENT_BY_ID, DEDICATED_CATALOGS_DATASET_ID);
                CommonXML.addContent(catalogCollectionXPATH, this.document, toSetString, this.helper, CommonXML.Position.last_child);
            }
        }
    }

    public void close() throws IOException, TransformerException {
        CommonXML.writeOut(this.document, this.currentCatalogFile);
    }

    public ThreddsCatalog getCatalogDescriptor() {
        log.debug("loading catalogs from {} ", (Object)this.currentCatalogFile.getAbsolutePath());
        ThreddsCatalog toReturn = new ThreddsCatalog();
        toReturn.setCatalogFile(this.currentCatalogFile.getName());
        log.debug("Checking declared datasets in {} ", (Object)this.currentCatalogFile.getAbsolutePath());
        NodeList datasetRootNodes = this.helper.evaluateForNodes(DECLARED_DATASETROOT);
        if (datasetRootNodes.getLength() > 0) {
            Element rootNode = (Element)datasetRootNodes.item(0);
            DataSetRoot root = new DataSetRoot();
            root.setLocation(rootNode.getAttribute("location"));
            root.setPath(rootNode.getAttribute("path"));
            toReturn.setDeclaredDataSetRoot(root);
        }
        NodeList datasetScans = this.helper.evaluateForNodes(DECLARED_DATASETSCANS);
        toReturn.setDeclaredDataSetScan(new HashSet());
        int i = 0;
        while (i < datasetScans.getLength()) {
            Element scanNode = (Element)datasetScans.item(i);
            DataSetScan scan = new DataSetScan();
            scan.setID(scanNode.getAttribute("ID"));
            scan.setLocation(scanNode.getAttribute("location"));
            scan.setName(scanNode.getAttribute("name"));
            scan.setPath(scanNode.getAttribute("path"));
            toReturn.getDeclaredDataSetScan().add(scan);
            ++i;
        }
        NodeList catalogCollectionNodes = this.helper.evaluateForNodes(CATALOG_COLLECTION_XPATH);
        if (catalogCollectionNodes.getLength() > 0) {
            Element catalogCollectionNode = (Element)catalogCollectionNodes.item(0);
            CatalogCollection collection = new CatalogCollection();
            collection.setID(catalogCollectionNode.getAttribute("ID"));
            collection.setName(catalogCollectionNode.getAttribute("name"));
            log.debug("Found catalog collection ID {} , NAME {} ", (Object)collection.getID(), (Object)collection.getName());
            collection.setLinkedCatalogs(new HashSet());
            NodeList linkedCatalogsNodelist = this.helper.evaluateForNodes(LINKED_CATALOGS_XPATH);
            int i2 = 0;
            while (i2 < linkedCatalogsNodelist.getLength()) {
                Element linkedCatalogElement = (Element)linkedCatalogsNodelist.item(i2);
                String linkedCatalogFile = linkedCatalogElement.getAttribute("xlink:href");
                String linkedCatalogName = linkedCatalogElement.getAttribute("name");
                String linkedCatalogTitle = linkedCatalogElement.getAttribute("xlink:title");
                String linkedCatalogID = linkedCatalogElement.getAttribute("ID");
                try {
                    ThreddsCatalog linkedCatalog = new XMLCatalogHandler(new File(this.currentCatalogFile.getParentFile(), linkedCatalogFile)).getCatalogDescriptor();
                    linkedCatalog.setCatalogFile(linkedCatalogFile);
                    linkedCatalog.setName(linkedCatalogName);
                    linkedCatalog.setTitle(linkedCatalogTitle);
                    linkedCatalog.setID(linkedCatalogID);
                    collection.getLinkedCatalogs().add(linkedCatalog);
                }
                catch (Throwable t) {
                    log.warn("Unable to parse {} ", (Object)linkedCatalogFile, (Object)t);
                }
                ++i2;
            }
            toReturn.setSubCatalogs(collection);
        }
        return toReturn;
    }
}

