package org.gcube.data.transfer.plugins.thredds;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map.Entry;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;

import org.gcube.common.resources.gcore.utils.XPathHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class XMLCatalogHandler {

	static Transformer transformer =null;
	static DocumentBuilder docBuilder =null;


	static HashMap<String,String> namespaces=new HashMap<String,String>();
	
	static{
		try{
			DocumentBuilderFactory factory=DocumentBuilderFactory.newInstance();
			factory.setNamespaceAware(true);

			docBuilder =  factory.newDocumentBuilder();


			TransformerFactory transformerFactory = TransformerFactory.newInstance();
			transformer = transformerFactory.newTransformer();


			namespaces.put("xmlns", "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0");
			namespaces.put("xlink", "http://www.w3.org/1999/xlink");
			namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
			namespaces.put("gml", "http://www.opengis.net/gml");
			namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
			namespaces.put("gmi", "http://www.isotc211.org/2005/gmi");
			namespaces.put("gmx", "http://www.isotc211.org/2005/gmx");




		}catch(Exception e){
			throw new RuntimeException("Unable to init Fixer ",e);
		}
	}
	
	private static XPathHelper getHelper(Node root){
		XPathHelper toReturn =new XPathHelper(root);
		for(Entry<String,String> entry:namespaces.entrySet())
			toReturn.addNamespace(entry.getKey(), entry.getValue());
		return toReturn;
	}
	
	private XPathHelper helper;
	
	
	public XMLCatalogHandler(File catalog) throws SAXException, IOException {
		log.debug("Parsing {} ",catalog.getAbsolutePath());
		InputSource inputSource = new InputSource(new FileInputStream(catalog));
		//Get document owner
		Document document=null;
		Element documentNode=null;
		documentNode = docBuilder.parse(inputSource).getDocumentElement();
		document=documentNode.getOwnerDocument();
		helper=getHelper(document);
	}
	
	public void registerCatalog(String toRegisterCatalogFile,String toRegisterReference) {
		
	}
	
}
