package org.gcube.data.transfer.plugins.thredds;

import org.gcube.data.transfer.plugin.fails.PluginInitializationException;
import org.gcube.data.transfer.plugin.model.DataTransferContext;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class Commons {

	
	
	
	public static ThreddsInitDetails getThreddsInitDetails(DataTransferContext ctx) throws PluginInitializationException {
		log.trace("Loading configuration .. ");		
		String threddsContentRoot=null;
//		String threddsContentRoot=System.getenv("THREDDS_CONTENT_ROOT")+File.separator+"thredds";
//		log.info("Thredds catalog base path from ENV is {} ",threddsContentRoot);
		
		for(ApplicationConfiguration app:ctx.getCtx().container().configuration().apps()) {
			log.debug("Found app {} ",app.context());
			if(app.context().equals("thredds")||app.context().equals("/thredds")) {
				threddsContentRoot=app.persistence().location();
				log.info("Thredds catalog base path from Context is {} ",threddsContentRoot);
		
				// Found thredds
				// Get catalog base folder
//				app.persistence().
			}
		}
		if(threddsContentRoot==null) throw new PluginInitializationException("No Thredds instance found in context");
		
		ThreddsInitDetails details=new ThreddsInitDetails(
				threddsContentRoot, 
				threddsContentRoot+"/public/netcdf/",
				threddsContentRoot+"/catalog.xml");
		log.trace("ThreddsInitDeteails will be {}",details);
		return details;
		
	}
	
	
	
		
}
