package org.gcube.data.transfer.plugins.sis;

import java.util.HashMap;
import java.util.Map;

import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.plugin.AbstractPluginFactory;
import org.gcube.data.transfer.plugin.fails.ParameterException;
import org.gcube.data.transfer.plugin.fails.PluginInitializationException;
import org.gcube.data.transfer.plugin.fails.PluginShutDownException;

public class SISPluginFactory extends AbstractPluginFactory<SisPlugin> {

	static final String PLUGIN_ID="SIS/GEOTK";
	
	public static final String SOURCE_PARAMETER="SOURCE_FILE";
	public static final String GEONETWORK_CATEGORY="GEONETWORK_CATEGORY";
	public static final String GEONETWORK_STYLESHEET="GEONETWORK_STYLESHEET";
	
	static final Map<String,String> PARAMETERS_DESCRIPTION= new HashMap<String,String>();
	
	static{
		PARAMETERS_DESCRIPTION.put(SOURCE_PARAMETER, "[String value] Absolute path of source archive file.");
		PARAMETERS_DESCRIPTION.put(GEONETWORK_CATEGORY, "[String value] GeoNetwork category for publiehd metadata. Default is 'Dataset'.");
		PARAMETERS_DESCRIPTION.put(GEONETWORK_STYLESHEET, "[String value] GeoNetwork stylesheet for publiehd metadata. Default is '_none_'.");
	}
	
	
	public SISPluginFactory() {
		
	}

	@Override
	public void checkInvocation(PluginInvocation arg0) throws ParameterException {
		// TODO Auto-generated method stub

	}

	@Override
	public SisPlugin createWorker(PluginInvocation arg0) {
		return new SisPlugin(arg0);
	}

	@Override
	public String getDescription() {
		return String.format("Extracts ISO metadata file from <%s> and publishes to GeoNetwork.", SOURCE_PARAMETER);
	}

	@Override
	public String getID() {
		return PLUGIN_ID;
	}

	@Override
	public Map<String,String> getParameters() {
		return PARAMETERS_DESCRIPTION;
	}

	@Override
	public boolean init() throws PluginInitializationException {
		return true;
	}

	@Override
	public boolean shutDown() throws PluginShutDownException {
		return true;
	}

}
