/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.portlets.user.server;

import com.google.gson.Gson;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import org.gcube.datatransfer.portlets.user.client.SchedulerService;
import org.gcube.datatransfer.portlets.user.server.MappingWorker;
import org.gcube.datatransfer.portlets.user.shared.ConnectionFTP;
import org.gcube.datatransfer.portlets.user.shared.ConnectionHTTP;
import org.gcube.datatransfer.portlets.user.shared.ListFiles;
import org.gcube.datatransfer.portlets.user.shared.SchedulerProxy;
import org.gcube.datatransfer.portlets.user.shared.obj.CallingManagementResult;
import org.gcube.datatransfer.portlets.user.shared.obj.CallingSchedulerResult;
import org.gcube.datatransfer.portlets.user.shared.obj.FolderDto;
import org.gcube.datatransfer.portlets.user.shared.obj.SchedulerObj;

public class SchedulerServiceImpl
extends RemoteServiceServlet
implements SchedulerService {
    public String listFiles(String input) throws IllegalArgumentException {
        String rootPath = input;
        ListFiles listFiles = new ListFiles(rootPath);
        FolderDto folder = listFiles.process();
        Gson gson = new Gson();
        if (folder != null) {
            System.out.println("returned folder!=null");
        }
        return gson.toJson((Object)folder);
    }

    public String getTransfers(String scope, String resourceName) throws IllegalArgumentException {
        SchedulerProxy schedulerProxy = new SchedulerProxy();
        MappingWorker mappingWorker = new MappingWorker();
        CallingManagementResult callingManagementResult = mappingWorker.mappedcallingManagementResult(schedulerProxy.getTransfers(resourceName, scope));
        Gson gson = new Gson();
        return gson.toJson((Object)callingManagementResult);
    }

    public String schedule(String Obj) throws IllegalArgumentException {
        SchedulerObj schedulerObj = new SchedulerObj();
        SchedulerProxy schedulerProxy = new SchedulerProxy();
        Gson gson = new Gson();
        schedulerObj = (SchedulerObj)gson.fromJson(Obj, SchedulerObj.class);
        schedulerProxy.retrieveSchedulerLibrary(schedulerObj.getScope(), schedulerObj.getSubmitter());
        MappingWorker mappingWorker = new MappingWorker();
        String transferId = schedulerProxy.schedule(mappingWorker.mappedSchedulerObj(schedulerObj), schedulerObj.getScope(), schedulerObj.getSubmitter());
        return transferId;
    }

    public String monitor(String scope, String resourceName, String transferId) throws IllegalArgumentException {
        CallingSchedulerResult callingSchedulerResult = new CallingSchedulerResult();
        SchedulerProxy schedulerProxy = new SchedulerProxy();
        schedulerProxy.retrieveSchedulerLibrary(scope, resourceName);
        MappingWorker mappingWorker = new MappingWorker();
        callingSchedulerResult = mappingWorker.mappedCallingSchedulerResult(schedulerProxy.monitor(transferId));
        Gson gson = new Gson();
        return gson.toJson((Object)callingSchedulerResult);
    }

    public String getOutcomes(String scope, String resourceName, String transferId) throws IllegalArgumentException {
        CallingSchedulerResult callingSchedulerResult = new CallingSchedulerResult();
        SchedulerProxy schedulerProxy = new SchedulerProxy();
        schedulerProxy.retrieveSchedulerLibrary(scope, resourceName);
        MappingWorker mappingWorker = new MappingWorker();
        callingSchedulerResult = mappingWorker.mappedCallingSchedulerResult(schedulerProxy.getOutcomes(transferId));
        Gson gson = new Gson();
        return gson.toJson((Object)callingSchedulerResult);
    }

    public String cancel(String scope, String resourceName, String transferId, boolean force) throws IllegalArgumentException {
        CallingSchedulerResult callingSchedulerResult = new CallingSchedulerResult();
        SchedulerProxy schedulerProxy = new SchedulerProxy();
        schedulerProxy.retrieveSchedulerLibrary(scope, resourceName);
        MappingWorker mappingWorker = new MappingWorker();
        callingSchedulerResult = mappingWorker.mappedCallingSchedulerResult(schedulerProxy.cancel(transferId, force));
        Gson gson = new Gson();
        return gson.toJson((Object)callingSchedulerResult);
    }

    private String escapeHtml(String html) {
        if (html == null) {
            return null;
        }
        return html.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "<br>");
    }

    public String getObjectsFromIS(String type, String scope, String resourceName) throws IllegalArgumentException {
        SchedulerProxy schedulerProxy = new SchedulerProxy();
        String result = schedulerProxy.getObjectsFromIS(type, resourceName, scope);
        if (result == null) {
            System.out.println("GET OBJECTS FROM IS: PROBLEM result from service=null");
        } else {
            System.out.println("GET OBJECTS FROM IS: result from service=" + result);
        }
        return result;
    }

    public String getFileListOfDataSource(String dataSourceId, String specificPath, String scope, String resourceName) {
        SchedulerProxy schedulerProxy = new SchedulerProxy();
        String name = null;
        String description = null;
        String host = null;
        String user = null;
        String pass = null;
        String specificFolder = null;
        String result = schedulerProxy.getObjectsFromIS("DataSource", resourceName, scope);
        if (result == null) {
            System.out.println("GET FILE LIST OF DATASOURCE - getObjectsFromIS(DataSource) result=null");
            return null;
        }
        String[] sourcesArray = result.split("\n");
        String[] stringArray = sourcesArray;
        int n = sourcesArray.length;
        int n2 = 0;
        while (n2 < n) {
            String tmp = stringArray[n2];
            String[] partsOfInfo = tmp.split("--");
            if (partsOfInfo[0].compareTo(dataSourceId) == 0) {
                name = partsOfInfo[1];
                description = partsOfInfo[2];
                host = partsOfInfo[3];
                user = partsOfInfo[4];
                pass = partsOfInfo[5];
                specificFolder = specificPath == null || specificPath.compareTo("") == 0 ? partsOfInfo[6] : specificPath;
                if (specificFolder.compareTo(".") == 0) {
                    specificFolder = "./";
                    break;
                }
                if (!specificFolder.startsWith("./")) {
                    specificFolder = "./" + specificFolder;
                }
                if (!specificFolder.endsWith("/")) {
                    specificFolder = specificFolder.concat("/");
                }
                specificFolder = specificFolder.replaceAll("/{1,}", "/");
                break;
            }
            ++n2;
        }
        if (host == null || name == null) {
            System.out.println("GET FILE LIST OF DATASOURCE - cannot find the datasource in IS");
            return null;
        }
        FolderDto rootFolder = null;
        if (name.startsWith("FTP")) {
            if (user == null || pass == null) {
                System.out.println("GET FILE LIST OF DATASOURCE - FTP datasource does not have 'username' or/and 'password' in IS");
                return null;
            }
            String[] partsOfEndpoint = host.split("//");
            host = partsOfEndpoint[1];
            ConnectionFTP connectionFTP = null;
            connectionFTP = new ConnectionFTP(host, specificFolder, user, pass);
            rootFolder = connectionFTP.browse();
            if (rootFolder == null) {
                System.out.println("GET LIST OF DATASOURCE: PROBLEM result(from FTP) =null\nERRORS:\n");
                for (String err : connectionFTP.getErrors()) {
                    System.out.println(err);
                }
                connectionFTP.disconnect();
                return null;
            }
            connectionFTP.printFolder(rootFolder, 0);
            if (connectionFTP.getErrors().size() > 0) {
                System.out.println("GET LIST OF DATASOURCE: ERRORS in connectionFTP:\n");
                for (String err : connectionFTP.getErrors()) {
                    System.out.println(err);
                }
            }
            connectionFTP.disconnect();
        } else if (name.startsWith("HTTP") || name.startsWith("HTTPS")) {
            ConnectionHTTP connectionHTTP = new ConnectionHTTP(host, specificFolder, user, pass);
            rootFolder = connectionHTTP.process();
            if (rootFolder == null) {
                System.out.println("GET LIST OF DATASOURCE: PROBLEM result(from HTTP/HTTPS) =null\nERRORS:\n");
                for (String err : connectionHTTP.getErrors()) {
                    System.out.println(err);
                }
                connectionHTTP.disconnect();
                return null;
            }
            connectionHTTP.printFolder(rootFolder, 0);
            if (connectionHTTP != null && connectionHTTP.getErrors().size() > 0) {
                System.out.println("GET LIST OF DATASOURCE: ERRORS in connectionHTTP:\n");
                for (String err : connectionHTTP.getErrors()) {
                    System.out.println(err);
                }
            }
            connectionHTTP.disconnect();
        }
        Gson gson = new Gson();
        String jsonString = gson.toJson(rootFolder);
        if (rootFolder != null) {
            System.out.println("returned folder!=null");
            System.out.println("GET LIST OF DATASOURCE: gson folder length= " + jsonString.length());
        }
        return jsonString;
    }
}

