/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.state;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datatransfer.common.messaging.MSGClientFactory;
import org.gcube.datatransfer.scheduler.impl.check.CheckIS;
import org.gcube.datatransfer.scheduler.impl.context.ServiceContext;
import org.gcube.datatransfer.scheduler.impl.newhandler.TransferResponseSubscription;
import org.gcube.datatransfer.scheduler.is.ISManager;

public class SchedulerRIResourceConsumer
extends GCUBEResource.ResourceConsumer {
    GCUBELog logger = new GCUBELog((Object)this);

    protected void onAddScope(GCUBEResource.AddScopeEvent event) {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (GCUBEScope scope : (GCUBEScope[])event.getPayload()) {
            String address;
            ScopeProvider.instance.set(scope.toString());
            ISManager isManagerForAgents = new ISManager("Agent", ServiceContext.getContext().getDbManager(), scope.toString());
            ServiceContext.getContext().setIsManagerForAgents(isManagerForAgents);
            ISManager isManagerForSources = new ISManager("DataSource", ServiceContext.getContext().getDbManager(), scope.toString());
            ServiceContext.getContext().setIsManagerForSources(isManagerForSources);
            ISManager isManagerForStorages = new ISManager("DataStorage", ServiceContext.getContext().getDbManager(), scope.toString());
            ServiceContext.getContext().setIsManagerForStorages(isManagerForStorages);
            this.logger.debug((Object)("RIResourceConsumer - onAddScope(" + scope.toString() + ").. just created a CheckISThread and three ISManagers(for Agents-Sources-Storages) in scope=" + scope.toString()));
            CheckIS checkIS = new CheckIS();
            checkIS.start();
            boolean isMessagingEnabled = ServiceContext.getContext().isMessagingEnabled();
            this.logger.debug((Object)("RIResourceConsumer - onAddScope(" + scope.toString() + ").. isMessagingEnabled=" + isMessagingEnabled));
            if (!isMessagingEnabled) continue;
            ScopeProvider.instance.set(scope.toString());
            try {
                ServiceContext.getContext().setMsgClient(MSGClientFactory.getMSGClientInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (ServiceContext.getContext().getMsgClient() != null) {
                this.logger.debug((Object)("RIResourceConsumer - onAddScope(" + scope.toString() + ") - MSGClient has been created..."));
            } else {
                this.logger.error((Object)("RIResourceConsumer - onAddScope(" + scope.toString() + ") - MSGClient is not created !!"));
            }
            EndpointReferenceType endpoint = ServiceContext.getContext().getInstance().getAccessPoint().getEndpoint("gcube/datatransfer/scheduler/Scheduler");
            String sourceEndpoint = address = endpoint.getAddress().toString();
            String[] parts = address.split("/");
            if (parts.length >= 3) {
                sourceEndpoint = parts[0] + "//" + parts[2];
            }
            this.logger.debug((Object)("RIResourceConsumer - onAddScope(" + scope.toString() + ") - Current address of scheduler service: " + sourceEndpoint));
            TransferResponseSubscription subscriber = new TransferResponseSubscription(sourceEndpoint);
            subscriber.setScope(scope);
            try {
                subscriber.subscribe();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

