/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.porttype;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jdo.Extent;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.common.scheduler.Types;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.AgentStatistics;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.db.model.TransferObject;
import org.gcube.datatransfer.scheduler.db.model.TypeOfSchedule;
import org.gcube.datatransfer.scheduler.db.utils.Utils;
import org.gcube.datatransfer.scheduler.impl.context.ManagementContext;
import org.gcube.datatransfer.scheduler.impl.context.ServiceContext;
import org.gcube.datatransfer.scheduler.is.ISManager;
import org.gcube.datatransfer.scheduler.library.obj.ManuallyScheduled;
import org.gcube.datatransfer.scheduler.library.obj.PeriodicallyScheduled;
import org.gcube.datatransfer.scheduler.library.outcome.CallingManagementResult;
import org.gcube.datatransfer.scheduler.library.outcome.TransferInfo;
import org.gcube.datatransfer.scheduler.library.outcome.TransferObjectInfo;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.SampleFault;

public class Management
extends GCUBEPortType {
    GCUBELog logger = new GCUBELog((Object)this);
    public DataTransferDBManager dbManager;

    public String about(String name) throws GCUBEFault, SampleFault {
        StringBuilder output = new StringBuilder();
        GHNContext nctx = GHNContext.getContext();
        ServiceContext sctx = ServiceContext.getContext();
        ManagementContext pctx = ManagementContext.getContext();
        try {
            output.append("Hello " + name).append(", you have invoked porttype ").append(pctx.getName() + " of service " + sctx.getName()).append(", which you found ").append(" on the GHN " + nctx.getGHNID()).append(" at " + pctx.getEPR() + " in the gCube infrastructure " + nctx.getGHN().getInfrastructure());
        }
        catch (GCUBEException e) {
            this.logger.error((Object)"Problem in about():", (Throwable)e);
            throw e.toFault(new String[0]);
        }
        catch (Exception e) {
            this.logger.error((Object)"Problem in about()", (Throwable)e);
            throw sctx.getDefaultException("Problem in about()", e).toFault(new String[0]);
        }
        return output.toString();
    }

    public String getAddr(String tmp) throws GCUBEFault, SampleFault {
        ServiceContext sctx = ServiceContext.getContext();
        ManagementContext pctx = ManagementContext.getContext();
        try {
            return pctx.getEPR().toString().replaceFirst("Address: ", "").replaceAll("\n", "");
        }
        catch (Exception e) {
            this.logger.error((Object)"Problem in about()", (Throwable)e);
            throw sctx.getDefaultException("Problem in about()", e).toFault(new String[0]);
        }
    }

    public String getAllTransfersInfo(String name) throws GCUBEFault, SampleFault {
        TransferInfo temp;
        this.dbManager = ServiceContext.getContext().getDbManager();
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<TransferInfo> transfersInfo = new ArrayList<TransferInfo>();
        ArrayList<TransferInfo> transfersObjsInfo = new ArrayList<TransferInfo>();
        CallingManagementResult callingManagementResult = new CallingManagementResult();
        try {
            Extent transferExtent = ServiceContext.getContext().getDbManager().getPersistenceManager().getExtent(Transfer.class, true);
            for (Object obj : transferExtent) {
                if (name.compareTo("ALL") != 0 && ((Transfer)obj).getSubmitter().compareTo(name) != 0) continue;
                temp = new TransferInfo();
                temp.setTransferId(((Transfer)obj).getTransferId());
                temp.setTransferIdOfAgent(((Transfer)obj).getTransferIdOfAgent());
                temp.setTransferError(((Transfer)obj).getTransferError());
                temp.setStatus(((Transfer)obj).getStatus());
                temp.setObjectFailedIDs(((Transfer)obj).getObjectFailedIDs());
                temp.setObjectTrasferredIDs(((Transfer)obj).getObjectTrasferredIDs());
                temp.setSubmitter(((Transfer)obj).getSubmitter());
                temp.setSubmittedDate(((Transfer)obj).getSubmittedDate());
                temp.setTotal_size(((Transfer)obj).getTotal_size());
                temp.setBytes_have_been_transferred(((Transfer)obj).getBytes_have_been_transferred());
                String idOfScheduler = ((Transfer)obj).getTypeOfScheduleId();
                TypeOfSchedule typeOfSchedule = (TypeOfSchedule)this.dbManager.getPersistenceManager().getObjectById(TypeOfSchedule.class, (Object)idOfScheduler);
                if (typeOfSchedule.isDirectedScheduled()) {
                    temp.getTypeOfSchedule().setDirectedScheduled(typeOfSchedule.isDirectedScheduled());
                } else if (typeOfSchedule.getManuallyScheduledId() != null) {
                    org.gcube.datatransfer.scheduler.db.model.ManuallyScheduled manuallyScheduled = new org.gcube.datatransfer.scheduler.db.model.ManuallyScheduled();
                    manuallyScheduled = (org.gcube.datatransfer.scheduler.db.model.ManuallyScheduled)this.dbManager.getPersistenceManager().getObjectById(org.gcube.datatransfer.scheduler.db.model.ManuallyScheduled.class, (Object)typeOfSchedule.getManuallyScheduledId());
                    temp.getTypeOfSchedule().setManuallyScheduled(new ManuallyScheduled());
                    temp.getTypeOfSchedule().getManuallyScheduled().setCalendar(manuallyScheduled.getCalendar());
                    if (manuallyScheduled.getCalendarString() != null) {
                        temp.getTypeOfSchedule().getManuallyScheduled().setInstanceString(manuallyScheduled.getCalendarString());
                    }
                } else if (typeOfSchedule.getPeriodicallyScheduledId() != null) {
                    org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled periodicallyScheduled = new org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled();
                    periodicallyScheduled = (org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled)this.dbManager.getPersistenceManager().getObjectById(org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled.class, (Object)typeOfSchedule.getPeriodicallyScheduledId());
                    temp.getTypeOfSchedule().setPeriodicallyScheduled(new PeriodicallyScheduled());
                    if (periodicallyScheduled.getFrequency() == Utils.FrequencyType.perMinute) {
                        temp.getTypeOfSchedule().getPeriodicallyScheduled().setFrequency(Types.FrequencyType.perMinute);
                    }
                    if (periodicallyScheduled.getFrequency() == Utils.FrequencyType.perHour) {
                        temp.getTypeOfSchedule().getPeriodicallyScheduled().setFrequency(Types.FrequencyType.perHour);
                    }
                    if (periodicallyScheduled.getFrequency() == Utils.FrequencyType.perDay) {
                        temp.getTypeOfSchedule().getPeriodicallyScheduled().setFrequency(Types.FrequencyType.perDay);
                    }
                    if (periodicallyScheduled.getFrequency() == Utils.FrequencyType.perWeek) {
                        temp.getTypeOfSchedule().getPeriodicallyScheduled().setFrequency(Types.FrequencyType.perWeek);
                    }
                    if (periodicallyScheduled.getFrequency() == Utils.FrequencyType.perMonth) {
                        temp.getTypeOfSchedule().getPeriodicallyScheduled().setFrequency(Types.FrequencyType.perMonth);
                    }
                    if (periodicallyScheduled.getFrequency() == Utils.FrequencyType.perYear) {
                        temp.getTypeOfSchedule().getPeriodicallyScheduled().setFrequency(Types.FrequencyType.perYear);
                    }
                    temp.getTypeOfSchedule().getPeriodicallyScheduled().setStartInstance(periodicallyScheduled.getStartInstance());
                    if (periodicallyScheduled.getStartInstanceString() != null) {
                        temp.getTypeOfSchedule().getPeriodicallyScheduled().setStartInstanceString(periodicallyScheduled.getStartInstanceString());
                    }
                }
                transfersInfo.add(temp);
            }
            callingManagementResult.setAllTheTransfersInDB(transfersInfo);
        }
        catch (Exception e1) {
            errors.add("Management Service(getAllTransfersInfo) - Exception in retrieving all the transfers\n" + e1.getMessage());
            callingManagementResult.setErrors(errors);
            String msgStr = callingManagementResult.toXML();
            e1.printStackTrace();
            return msgStr;
        }
        try {
            Extent transferobjExtent = ServiceContext.getContext().getDbManager().getPersistenceManager().getExtent(TransferObject.class, true);
            for (Object obj : transferobjExtent) {
                temp = new TransferObjectInfo();
                temp.setObjectId(((TransferObject)obj).getObjectId());
                if (((TransferObject)obj).getSize() != null) {
                    temp.setSize(((TransferObject)obj).getSize());
                } else {
                    temp.setSize(Long.valueOf(0L));
                }
                temp.setTransferid(((TransferObject)obj).getTransferid());
                if (((TransferObject)obj).getSrcURI() != null) {
                    temp.setURI(new URI(((TransferObject)obj).getSrcURI()));
                } else {
                    temp.setURI(null);
                }
                transfersObjsInfo.add(temp);
            }
            callingManagementResult.setAllTheTransferObjectsInDB(transfersObjsInfo);
        }
        catch (Exception e1) {
            errors.add("Management Service(getAllTransfersInfo) - Exception in retrieving all the transfer objects\n" + e1.getMessage());
            callingManagementResult.setErrors(errors);
            String msgStr = callingManagementResult.toXML();
            e1.printStackTrace();
            return msgStr;
        }
        callingManagementResult.setGetAllTransfersInfoResult("DONE");
        String msgStr = callingManagementResult.toXML();
        return msgStr;
    }

    public String getObjectsFromIS(String type) {
        if (type.compareTo("Agent") == 0) {
            ISManager isManagerForAgents = ServiceContext.getContext().getIsManagerForAgents();
            List agents = isManagerForAgents.getObjsFromIS();
            String agentsString = "";
            for (String tmp : agents) {
                agentsString = agentsString.concat(tmp + "\n");
            }
            return agentsString;
        }
        if (type.compareTo("DataSource") == 0) {
            ISManager isManagerForSources = ServiceContext.getContext().getIsManagerForSources();
            List dataSources = isManagerForSources.getObjsFromIS();
            String sourcesString = "";
            for (String tmp : dataSources) {
                sourcesString = sourcesString.concat(tmp + "\n");
            }
            return sourcesString;
        }
        if (type.compareTo("DataStorage") == 0) {
            ISManager isManagerForStorages = ServiceContext.getContext().getIsManagerForStorages();
            List storages = isManagerForStorages.getObjsFromIS();
            String storagesString = "";
            for (String tmp : storages) {
                storagesString = storagesString.concat(tmp + "\n");
            }
            return storagesString;
        }
        return null;
    }

    public String existAgentInIS(String agent) {
        ISManager isManagerForAgents = ServiceContext.getContext().getIsManagerForAgents();
        String idOfAgent = isManagerForAgents.checkIfObjExistsInIS_ByHostname(agent);
        return idOfAgent;
    }

    public String existAgentInDB(String agent) {
        ISManager isManagerForAgents = ServiceContext.getContext().getIsManagerForAgents();
        String idOfAgent = isManagerForAgents.checkIfObjExistsInIS_ByHostname(agent);
        if (idOfAgent != null) {
            return isManagerForAgents.checkIfObjExistsInDB_ById(idOfAgent);
        }
        return null;
    }

    public String getAgentStatistics(String nothing) {
        Extent statsExtent = ServiceContext.getContext().getDbManager().getPersistenceManager().getExtent(AgentStatistics.class, true);
        Iterator iter = statsExtent.iterator();
        String all = "";
        while (iter.hasNext()) {
            AgentStatistics obj = (AgentStatistics)iter.next();
            all = all.concat(obj.getAgentIdOfIS() + "--" + obj.getOngoingTransfers() + "--" + obj.getFailedTransfers() + "--" + obj.getSucceededTransfers() + "--" + obj.getCanceledTransfers() + "--" + obj.getTotalFinishedTransfers() + "\n");
        }
        return all;
    }

    public GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }
}

