/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.check;

import java.util.List;
import javax.jdo.Query;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.impl.check.CheckDBForTransfers;
import org.gcube.datatransfer.scheduler.impl.context.ServiceContext;
import org.gcube.datatransfer.scheduler.impl.state.SchedulerResource;

public class CheckDBForTransfersThread
extends Thread {
    public DataTransferDBManager dbManager = null;
    public SchedulerResource resource = null;
    public long checkForTransfersIntervalMS;
    public boolean immediateCheck;
    GCUBELog logger = new GCUBELog(CheckDBForTransfersThread.class);

    public CheckDBForTransfersThread(GCUBEWSResource ws) {
        this.dbManager = ServiceContext.getContext().getDbManager();
        this.resource = (SchedulerResource)ws;
        this.checkForTransfersIntervalMS = 1000 * Integer.valueOf((String)ServiceContext.getContext().getProperty("checkForTransfersIntervalInSeconds", new boolean[]{true}));
        this.immediateCheck = true;
    }

    @Override
    public void run() {
        int runs = 0;
        long initialInterval = 0L;
        long tempInterval = 0L;
        this.logger.debug((Object)("\nCheckDBForTransfersThread - " + this.resource.getName() + " -- Thread has started"));
        do {
            if (++runs == 1) {
                this.sleepFiveSec();
            }
            initialInterval = this.checkForTransfersIntervalMS;
            tempInterval = this.checkForTransfersIntervalMS;
            do {
                this.sleepFiveSec();
            } while ((tempInterval -= 5000L) > 0L && initialInterval == this.checkForTransfersIntervalMS && !this.immediateCheck);
            if (this.immediateCheck) {
                this.sleepFiveSec();
                this.logger.debug((Object)"\nCheckDBForTransfersThread -- immediate check");
                this.immediateCheck = false;
            } else if (initialInterval != this.checkForTransfersIntervalMS) {
                this.logger.debug((Object)("\nCheckDBForTransfersThread -- interval has been changed from " + initialInterval + " MS to " + this.checkForTransfersIntervalMS + " MS"));
            }
            Query query = null;
            List list = null;
            query = ServiceContext.getContext().getDbManager().getPersistenceManager().newQuery(Transfer.class);
            try {
                query.setFilter("status == \"STANDBY\" && submitter == \"" + this.resource.getName() + "\"");
            }
            catch (Exception e) {
                this.logger.error((Object)"\nCheckDBForTransfersThread -- Exception in retrieving all the activated transfers by query");
                e.printStackTrace();
            }
            list = (List)query.execute();
            CheckDBForTransfers checkDBForTransfers = new CheckDBForTransfers(this.resource, list);
            checkDBForTransfers.check();
        } while (!Thread.interrupted());
    }

    public void sleepFiveSec() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            this.logger.error((Object)"\nCheckDBForTransfersThread (sleepFiveSec)-- InterruptedException-Unable to sleep");
            e.printStackTrace();
        }
    }

    public long getCheckForTransfersIntervalMS() {
        return this.checkForTransfersIntervalMS;
    }

    public void setCheckForTransfersIntervalMS(long checkForTransfersIntervalMS) {
        this.checkForTransfersIntervalMS = checkForTransfersIntervalMS;
    }

    public boolean isImmediateCheck() {
        return this.immediateCheck;
    }

    public void setImmediateCheck(boolean immediateCheck) {
        this.immediateCheck = immediateCheck;
    }

    public void resetCheckForTransfersInterval() {
        this.checkForTransfersIntervalMS = 1000 * Integer.valueOf((String)ServiceContext.getContext().getProperty("checkForTransfersIntervalInSeconds", new boolean[]{true}));
    }
}

