/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.porttype;

import java.util.ArrayList;
import javax.jdo.Extent;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.db.model.TransferObject;
import org.gcube.datatransfer.scheduler.db.model.TypeOfSchedule;
import org.gcube.datatransfer.scheduler.db.utils.Utils;
import org.gcube.datatransfer.scheduler.impl.context.ManagementContext;
import org.gcube.datatransfer.scheduler.impl.context.ServiceContext;
import org.gcube.datatransfer.scheduler.library.obj.ManuallyScheduled;
import org.gcube.datatransfer.scheduler.library.obj.PeriodicallyScheduled;
import org.gcube.datatransfer.scheduler.library.outcome.CallingManagementResult;
import org.gcube.datatransfer.scheduler.library.outcome.TransferInfo;
import org.gcube.datatransfer.scheduler.library.outcome.TransferObjectInfo;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.FrequencyType;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.SampleFault;

public class Management
extends GCUBEPortType {
    private static GCUBELog logger = new GCUBELog(Management.class);
    public DataTransferDBManager dbManager;

    public String about(String name) throws GCUBEFault, SampleFault {
        StringBuilder output = new StringBuilder();
        GHNContext nctx = GHNContext.getContext();
        ServiceContext sctx = ServiceContext.getContext();
        ManagementContext pctx = ManagementContext.getContext();
        try {
            output.append("Hello " + name).append(", you have invoked porttype ").append(pctx.getName() + " of service " + sctx.getName()).append(", which you found ").append(" on the GHN " + nctx.getGHNID()).append(" at " + pctx.getEPR() + " in the gCube infrastructure " + nctx.getGHN().getInfrastructure());
        }
        catch (GCUBEException e) {
            logger.error((Object)"Problem in about():", (Throwable)e);
            throw e.toFault(new String[0]);
        }
        catch (Exception e) {
            logger.error((Object)"Problem in about()", (Throwable)e);
            throw sctx.getDefaultException("Problem in about()", e).toFault(new String[0]);
        }
        return output.toString();
    }

    public String getAddr(String tmp) throws GCUBEFault, SampleFault {
        ServiceContext sctx = ServiceContext.getContext();
        ManagementContext pctx = ManagementContext.getContext();
        try {
            return pctx.getEPR().toString().replaceFirst("Address: ", "").replaceAll("\n", "");
        }
        catch (Exception e) {
            logger.error((Object)"Problem in about()", (Throwable)e);
            throw sctx.getDefaultException("Problem in about()", e).toFault(new String[0]);
        }
    }

    public String getAllTransfersInfo(String name) throws GCUBEFault, SampleFault {
        TransferInfo temp;
        this.dbManager = ServiceContext.getContext().getDbManager();
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<TransferInfo> transfersInfo = new ArrayList<TransferInfo>();
        ArrayList<TransferInfo> transfersObjsInfo = new ArrayList<TransferInfo>();
        CallingManagementResult callingManagementResult = new CallingManagementResult();
        try {
            Extent transferExtent = ServiceContext.getContext().getDbManager().getPersistenceManager().getExtent(Transfer.class, true);
            for (Object obj : transferExtent) {
                if (name.compareTo("ALL") != 0 && ((Transfer)obj).getSubmitter().compareTo(name) != 0) continue;
                temp = new TransferInfo();
                temp.setTransferId(((Transfer)obj).getTransferId());
                temp.setTransferIdOfAgent(((Transfer)obj).getTransferIdOfAgent());
                temp.setTransferError(((Transfer)obj).getTransferError());
                temp.setStatus(((Transfer)obj).getStatus());
                temp.setObjectFailedIDs(((Transfer)obj).getObjectFailedIDs());
                temp.setObjectTrasferredIDs(((Transfer)obj).getObjectTrasferredIDs());
                temp.setSubmitter(((Transfer)obj).getSubmitter());
                String idOfScheduler = ((Transfer)obj).getTypeOfScheduleId();
                TypeOfSchedule typeOfSchedule = (TypeOfSchedule)this.dbManager.getPersistenceManager().getObjectById(TypeOfSchedule.class, (Object)idOfScheduler);
                if (typeOfSchedule.isDirectedScheduled()) {
                    temp.getTypeOfSchedule().setDirectedScheduled(typeOfSchedule.isDirectedScheduled());
                } else if (typeOfSchedule.getManuallyScheduledId() != null) {
                    org.gcube.datatransfer.scheduler.db.model.ManuallyScheduled manuallyScheduled = new org.gcube.datatransfer.scheduler.db.model.ManuallyScheduled();
                    manuallyScheduled = (org.gcube.datatransfer.scheduler.db.model.ManuallyScheduled)this.dbManager.getPersistenceManager().getObjectById(org.gcube.datatransfer.scheduler.db.model.ManuallyScheduled.class, (Object)typeOfSchedule.getManuallyScheduledId());
                    temp.getTypeOfSchedule().setManuallyScheduled(new ManuallyScheduled());
                    temp.getTypeOfSchedule().getManuallyScheduled().setCalendar(manuallyScheduled.getCalendar());
                } else if (typeOfSchedule.getPeriodicallyScheduledId() != null) {
                    org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled periodicallyScheduled = new org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled();
                    periodicallyScheduled = (org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled)this.dbManager.getPersistenceManager().getObjectById(org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled.class, (Object)typeOfSchedule.getPeriodicallyScheduledId());
                    temp.getTypeOfSchedule().setPeriodicallyScheduled(new PeriodicallyScheduled());
                    if (periodicallyScheduled.getFrequency() == Utils.FrequencyType.perMinute) {
                        temp.getTypeOfSchedule().getPeriodicallyScheduled().setFrequency(FrequencyType.perMinute);
                    }
                    if (periodicallyScheduled.getFrequency() == Utils.FrequencyType.perHour) {
                        temp.getTypeOfSchedule().getPeriodicallyScheduled().setFrequency(FrequencyType.perHour);
                    }
                    if (periodicallyScheduled.getFrequency() == Utils.FrequencyType.perDay) {
                        temp.getTypeOfSchedule().getPeriodicallyScheduled().setFrequency(FrequencyType.perDay);
                    }
                    if (periodicallyScheduled.getFrequency() == Utils.FrequencyType.perWeek) {
                        temp.getTypeOfSchedule().getPeriodicallyScheduled().setFrequency(FrequencyType.perWeek);
                    }
                    if (periodicallyScheduled.getFrequency() == Utils.FrequencyType.perMonth) {
                        temp.getTypeOfSchedule().getPeriodicallyScheduled().setFrequency(FrequencyType.perMonth);
                    }
                    if (periodicallyScheduled.getFrequency() == Utils.FrequencyType.perYear) {
                        temp.getTypeOfSchedule().getPeriodicallyScheduled().setFrequency(FrequencyType.perYear);
                    }
                    temp.getTypeOfSchedule().getPeriodicallyScheduled().setStartInstance(periodicallyScheduled.getStartInstance());
                }
                transfersInfo.add(temp);
            }
            callingManagementResult.setAllTheTransfersInDB(transfersInfo);
        }
        catch (Exception e1) {
            errors.add("Management Service(getAllTransfersInfo) - Exception in retrieving all the transfers\n" + e1.getMessage());
            callingManagementResult.setErrors(errors);
            String msgStr = callingManagementResult.toXML();
            e1.printStackTrace();
            return msgStr;
        }
        System.out.println("");
        try {
            Extent transferobjExtent = ServiceContext.getContext().getDbManager().getPersistenceManager().getExtent(TransferObject.class, true);
            for (Object obj : transferobjExtent) {
                temp = new TransferObjectInfo();
                temp.setObjectId(((TransferObject)obj).getObjectId());
                temp.setSize(((TransferObject)obj).getSize());
                temp.setTransferid(((TransferObject)obj).getTransferid());
                temp.setURI(((TransferObject)obj).getURI());
                transfersObjsInfo.add(temp);
            }
            callingManagementResult.setAllTheTransferObjectsInDB(transfersObjsInfo);
        }
        catch (Exception e1) {
            errors.add("Management Service(getAllTransfersInfo) - Exception in retrieving all the transfer objects\n" + e1.getMessage());
            callingManagementResult.setErrors(errors);
            String msgStr = callingManagementResult.toXML();
            e1.printStackTrace();
            return msgStr;
        }
        System.out.println("");
        callingManagementResult.setGetAllTransfersInfoResult("DONE");
        String msgStr = callingManagementResult.toXML();
        return msgStr;
    }

    public GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }
}

