/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.handler;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jdo.Query;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datatransfer.agent.library.AgentLibrary;
import org.gcube.datatransfer.agent.library.DataSource;
import org.gcube.datatransfer.agent.library.DataStorage;
import org.gcube.datatransfer.agent.library.TransferOptions;
import org.gcube.datatransfer.agent.library.outcome.FileTransferOutcome;
import org.gcube.datatransfer.agent.library.proxies.Proxies;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StorageManagerDetails;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StorageType;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.Agent;
import org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.db.model.TransferObject;
import org.gcube.datatransfer.scheduler.db.model.TypeOfSchedule;
import org.gcube.datatransfer.scheduler.db.utils.Utils;
import org.gcube.datatransfer.scheduler.impl.context.ServiceContext;
import org.gcube.datatransfer.scheduler.impl.state.SchedulerResource;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.SourceData;

public class TransferHandler
extends Thread {
    Transfer transfer;
    String submitter;
    String transferId;
    DataTransferDBManager dbManager = ServiceContext.getContext().getDbManager();
    SchedulerResource resource;
    String transferType;
    long checkForMonitorResultIntervalMS;

    public TransferHandler(String transferId, GCUBEWSResource ws, boolean isPeriodically) {
        this.transferId = transferId;
        this.resource = (SchedulerResource)ws;
        this.transfer = (Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)this.transferId);
        this.submitter = this.transfer.getSubmitter();
        this.transferType = this.transfer.getTransferType();
        this.checkForMonitorResultIntervalMS = 1000 * Integer.valueOf((String)ServiceContext.getContext().getProperty("checkForMonitorResultIntervalMS", new boolean[]{true}));
    }

    @Override
    public void run() {
        String retrivedStatus;
        System.out.println("\nTransferHandler - " + this.resource.getName() + " -- Thread has started");
        AgentLibrary agentLibrary = null;
        ArrayList<String> objectTrasferredIDs = new ArrayList<String>();
        ArrayList<String> objectFailedIDs = new ArrayList<String>();
        boolean failed = false;
        ArrayList<String> errorsInTransfer = new ArrayList<String>();
        String agentId = this.transfer.getAgentId();
        if (agentId == null) {
            System.out.println("TransferHandler - Error - agentId=null");
        }
        String hostAgent = ((Agent)this.dbManager.getPersistenceManager().getObjectById(Agent.class, (Object)agentId)).getHost();
        int portAgent = ((Agent)this.dbManager.getPersistenceManager().getObjectById(Agent.class, (Object)agentId)).getPort();
        this.addActiveTransferResource();
        if (this.transferType.compareTo("LocalFileBasedTransfer") == 0) {
            Query query = null;
            List list = null;
            query = ServiceContext.getContext().getDbManager().getPersistenceManager().newQuery(TransferObject.class);
            list = (List)query.execute();
            ArrayList<TransferObject> objectsToBeTransferred = new ArrayList<TransferObject>();
            for (TransferObject obj : list) {
                String transferIdOfSpecific = obj.getTransferid();
                if (transferIdOfSpecific != this.transferId) continue;
                objectsToBeTransferred.add(obj);
            }
            ArrayList<File> filesToBeTransferred = new ArrayList<File>();
            for (TransferObject obj : objectsToBeTransferred) {
                filesToBeTransferred.add(new File(obj.getURI()));
            }
            String destinationFolder = this.transfer.getDestinationFolder();
            boolean overwrite = this.transfer.isOverwrite();
            boolean unzipFile = this.transfer.isUnzipFile();
            String scope = this.transfer.getScope();
            ArrayList outcomes = null;
            try {
                System.out.println("TransferHandler -- scooooooooope=" + scope);
                ScopeProvider.instance.set(scope);
                agentLibrary = (AgentLibrary)Proxies.transferAgent().at(hostAgent, portAgent).build();
                outcomes = agentLibrary.copyLocalFiles(filesToBeTransferred, destinationFolder, overwrite, unzipFile);
                System.out.println("TransferHandler - After the agentLibrary.copyLocalFiles(...)");
            }
            catch (Exception e) {
                System.out.println("TransferHandler - Exception when call agentLibrary.copyLocalFiles(.....)");
                errorsInTransfer.add(e.getMessage());
                failed = true;
                e.printStackTrace();
            }
            try {
                int numOfObj = 0;
                for (FileTransferOutcome outcome : outcomes) {
                    System.out.println("Exception: " + outcome.getException());
                    System.out.println("FileName: " + outcome.getFilename());
                    System.out.println("Success?: " + outcome.isSuccess());
                    System.out.println("Failure?: " + outcome.isFailure());
                    if (outcome.isFailure()) {
                        objectFailedIDs.add(((TransferObject)objectsToBeTransferred.get(numOfObj)).getObjectId());
                    } else if (outcome.isSuccess()) {
                        objectTrasferredIDs.add(((TransferObject)objectsToBeTransferred.get(numOfObj)).getObjectId());
                    }
                    ++numOfObj;
                }
            }
            catch (Exception e) {
                System.out.println("TransferHandler - Exception when read the outcomes");
                errorsInTransfer.add(e.getMessage());
                failed = true;
                e.printStackTrace();
            }
            this.removeActiveTransferResource();
            if (failed) {
                try {
                    this.dbManager.updateTransferStatus(this.transferId, "FAILED");
                    this.dbManager.updateTransferError(this.transferId, errorsInTransfer);
                }
                catch (Exception e) {
                    System.out.println("TransferHandler -- IfFailed - Exception - " + this.submitter + " - id=" + this.transferId);
                    e.printStackTrace();
                }
            } else {
                try {
                    this.dbManager.updateTransferStatus(this.transferId, "COMPLETED");
                    String[] objectFailedIDsarray = objectFailedIDs.toArray(new String[objectFailedIDs.size()]);
                    String[] objectTrasferredIDsarray = objectTrasferredIDs.toArray(new String[objectTrasferredIDs.size()]);
                    this.dbManager.updateObjectTrasferredIDs(this.transferId, objectTrasferredIDsarray);
                    this.dbManager.updateObjectFailedIDs(this.transferId, objectFailedIDsarray);
                    System.out.println("TransferHandler -- Completed - " + this.submitter + " - id=" + this.transferId);
                }
                catch (Exception e) {
                    System.out.println("TransferHandler -- IfCompleted - Exception");
                    e.printStackTrace();
                }
                for (String objId : ((Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)this.transferId)).getObjectTrasferredIDs()) {
                    System.out.println("TransferHandler -- Completed - TransferredObjectID:" + objId);
                }
                for (String objId : ((Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)this.transferId)).getObjectFailedIDs()) {
                    System.out.println("TransferHandler -- Completed - FailedObjectID:" + objId);
                }
            }
        } else if (this.transferType.compareTo("FileBasedTransfer") == 0) {
            String transferIdOfAgent = null;
            ArrayList<TransferObject> objectsToBeTransferred = new ArrayList<TransferObject>();
            if (this.transfer.getSourceId() == null) {
                Query query = null;
                List list = null;
                query = ServiceContext.getContext().getDbManager().getPersistenceManager().newQuery(TransferObject.class);
                list = (List)query.execute();
                for (TransferObject obj : list) {
                    String transferIdOfSpecific = obj.getTransferid();
                    if (transferIdOfSpecific != this.transferId) continue;
                    objectsToBeTransferred.add(obj);
                }
                ArrayList<URI> inputUris = new ArrayList<URI>();
                for (TransferObject obj : objectsToBeTransferred) {
                    inputUris.add(obj.getURI());
                }
                StorageType storageType = null;
                StorageManagerDetails storageManagerDetails = new StorageManagerDetails();
                if (this.transfer.getStorageId() == null) {
                    storageType = StorageType.LocalGHN;
                    storageManagerDetails.setOwner("NickDrakopoulos");
                    storageManagerDetails.setServiceName("--");
                    storageManagerDetails.setServiceClass("--");
                } else {
                    storageType = StorageType.StorageManager;
                    storageManagerDetails.setOwner("NickDrakopoulos");
                    storageManagerDetails.setServiceName("--");
                    storageManagerDetails.setServiceClass("--");
                }
                String destinationFolder = this.transfer.getDestinationFolder();
                TransferOptions transferOptions = new TransferOptions();
                transferOptions.setType(storageType);
                transferOptions.setOverwriteFile(this.transfer.isOverwrite());
                transferOptions.setUnzipFile(this.transfer.isUnzipFile());
                transferOptions.setStorageManagerDetails(storageManagerDetails);
                String scope = this.transfer.getScope();
                System.out.println("TransferHandler -- scooooooooope=" + scope);
                try {
                    ScopeProvider.instance.set(scope);
                    agentLibrary = (AgentLibrary)Proxies.transferAgent().at(hostAgent, portAgent).build();
                    transferIdOfAgent = agentLibrary.startTransfer(inputUris, destinationFolder, transferOptions);
                    System.out.println("TransferHandler - After the agentLibrary.startTransfer(...)");
                }
                catch (Exception e) {
                    System.out.println("TransferHandler - Exception when call agentLibrary.startTransfer(.....)");
                    errorsInTransfer.add(e.getMessage());
                    failed = true;
                    e.printStackTrace();
                }
                try {
                    ServiceContext.getContext().getDbManager().updateTransferIdOfAgentInTransfer(this.transferId, transferIdOfAgent);
                }
                catch (Exception e) {
                    System.out.println("TransferHandler - Exception in storing the transferIdOfAgent inside the Transfer in DB\n");
                    e.printStackTrace();
                }
            } else {
                org.gcube.datatransfer.scheduler.db.model.DataSource dataSource = (org.gcube.datatransfer.scheduler.db.model.DataSource)this.dbManager.getPersistenceManager().getObjectById(org.gcube.datatransfer.scheduler.db.model.DataSource.class, (Object)this.transfer.getSourceId());
                DataSource dataSourceOfAgent = new DataSource();
                SourceData sourceData = new SourceData();
                DataStorage storageOfAgent = new DataStorage();
                DestData destData = new DestData();
                StorageType storageType = null;
                StorageManagerDetails storageManagerDetails = new StorageManagerDetails();
                if (this.transfer.getStorageId() == null) {
                    storageType = StorageType.LocalGHN;
                    storageManagerDetails.setOwner("NickDrakopoulos");
                    storageManagerDetails.setServiceName("--");
                    storageManagerDetails.setServiceClass("--");
                } else {
                    storageType = StorageType.StorageManager;
                    storageManagerDetails.setOwner("NickDrakopoulos");
                    storageManagerDetails.setServiceName("--");
                    storageManagerDetails.setServiceClass("--");
                }
                String destinationFolder = this.transfer.getDestinationFolder();
                TransferOptions transferOptions = new TransferOptions();
                transferOptions.setType(storageType);
                transferOptions.setOverwriteFile(this.transfer.isOverwrite());
                transferOptions.setUnzipFile(this.transfer.isUnzipFile());
                transferOptions.setStorageManagerDetails(storageManagerDetails);
                String scope = this.transfer.getScope();
                System.out.println("TransferHandler -- scooooooooope=" + scope);
                try {
                    ScopeProvider.instance.set(scope);
                    agentLibrary = (AgentLibrary)Proxies.transferAgent().at(hostAgent, portAgent).build();
                    System.out.println("TransferHandler - After the agentLibrary.startTransfer(...)");
                }
                catch (Exception e) {
                    System.out.println("TransferHandler - Exception when call agentLibrary.startTransfer(.....)");
                    errorsInTransfer.add(e.getMessage());
                    failed = true;
                    e.printStackTrace();
                }
                try {
                    ServiceContext.getContext().getDbManager().updateTransferIdOfAgentInTransfer(this.transferId, transferIdOfAgent);
                }
                catch (Exception e) {
                    System.out.println("TransferHandler - Exception in storing the transferIdOfAgent inside the Transfer in DB\n");
                    e.printStackTrace();
                }
            }
            String resultOfMonitoring = "";
            do {
                try {
                    resultOfMonitoring = agentLibrary.monitorTransfer(transferIdOfAgent);
                }
                catch (Exception e) {
                    System.out.println("TransferHandler - Exception when call agentLibrary.monitorTransfer(.....)");
                    errorsInTransfer.add(e.getMessage());
                    failed = true;
                    e.printStackTrace();
                }
                try {
                    Thread.sleep(this.checkForMonitorResultIntervalMS);
                }
                catch (InterruptedException e) {
                    System.out.println("TransferHandler -- InterruptedException-Unable to sleep");
                    e.printStackTrace();
                }
            } while (resultOfMonitoring.compareTo("STARTED") == 0);
            System.out.println("TransferHandler -- monitorTransfer result=" + resultOfMonitoring);
            retrivedStatus = ((Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)this.transferId)).getStatus();
            this.removeActiveTransferResource();
            if (retrivedStatus.compareTo("CANCELED") == 0) {
                System.out.println("TransferHandler -- Canceled");
                return;
            }
            if (resultOfMonitoring.compareTo("CANCEL") == 0) {
                try {
                    this.dbManager.updateTransferStatus(this.transferId, "CANCELED");
                    System.out.println("TransferHandler -- Canceled - " + this.submitter + " - id=" + this.transferId);
                    return;
                }
                catch (Exception e) {
                    System.out.println("TransferHandler -- IfCanceled - Exception");
                    e.printStackTrace();
                }
            }
            try {
                ArrayList outcomes = agentLibrary.getTransferOutcomes(transferIdOfAgent, FileTransferOutcome.class);
                int numOfObj = 0;
                for (FileTransferOutcome outcome : outcomes) {
                    if (numOfObj == 0) {
                        System.out.println("TransferHandler -- getTransferOutcomes:");
                    }
                    System.out.println("Exception: " + outcome.getException());
                    System.out.println("FileName: " + outcome.getFilename());
                    System.out.println("Success?: " + outcome.isSuccess());
                    System.out.println("Failure?: " + outcome.isFailure());
                    if (this.transfer.getSourceId() == null) {
                        if (outcome.isFailure()) {
                            objectFailedIDs.add(((TransferObject)objectsToBeTransferred.get(numOfObj)).getObjectId());
                        } else if (outcome.isSuccess()) {
                            objectTrasferredIDs.add(((TransferObject)objectsToBeTransferred.get(numOfObj)).getObjectId());
                        }
                    }
                    ++numOfObj;
                }
            }
            catch (Exception e) {
                System.out.println("TransferHandler - Exception when call agentLibrary.getTransferOutcomes(..) and read the outcomes");
                errorsInTransfer.add(e.getMessage());
                failed = true;
                e.printStackTrace();
            }
            if (resultOfMonitoring.compareTo("DONE") == 0) {
                try {
                    this.dbManager.updateTransferStatus(this.transferId, "COMPLETED");
                    System.out.println("TransferHandler -- Completed - " + this.submitter + " - id=" + this.transferId);
                    if (this.transfer.getSourceId() == null) {
                        String[] objectFailedIDsarray = objectFailedIDs.toArray(new String[objectFailedIDs.size()]);
                        String[] objectTrasferredIDsarray = objectTrasferredIDs.toArray(new String[objectTrasferredIDs.size()]);
                        this.dbManager.updateObjectTrasferredIDs(this.transferId, objectTrasferredIDsarray);
                        this.dbManager.updateObjectFailedIDs(this.transferId, objectFailedIDsarray);
                    }
                }
                catch (Exception e) {
                    System.out.println("TransferHandler -- IfCompleted - Exception");
                    e.printStackTrace();
                }
                if (this.transfer.getSourceId() == null) {
                    for (String objId : this.transfer.getObjectTrasferredIDs()) {
                        System.out.println("TransferHandler -- Completed - TransferredObjectID:" + objId);
                    }
                    for (String objId : this.transfer.getObjectFailedIDs()) {
                        System.out.println("TransferHandler -- Completed - FailedObjectID:" + objId);
                    }
                }
            } else {
                try {
                    this.dbManager.updateTransferStatus(this.transferId, "FAILED");
                    this.dbManager.updateTransferError(this.transferId, errorsInTransfer);
                    System.out.println("TransferHandler -- Failed - " + this.submitter + " - id=" + this.transferId);
                }
                catch (Exception e) {
                    System.out.println("TransferHandler -- IfFailed - Exception");
                    e.printStackTrace();
                }
            }
        } else if (this.transferType.compareTo("TreeBasedTransfer") == 0) {
            String scope = this.transfer.getScope();
            GCUBEScopeManager.DEFAULT.setScope(GCUBEScope.getScope((String)scope));
            this.removeActiveTransferResource();
        }
        String idTypeOfSchedule = this.transfer.getTypeOfScheduleId();
        TypeOfSchedule typeOfSchedule = (TypeOfSchedule)this.dbManager.getPersistenceManager().getObjectById(TypeOfSchedule.class, (Object)idTypeOfSchedule);
        String periodicallyScheduledId = typeOfSchedule.getPeriodicallyScheduledId();
        retrivedStatus = ((Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)this.transferId)).getStatus();
        if (periodicallyScheduledId != null && retrivedStatus != "CANCELED") {
            PeriodicallyScheduled periodicallyScheduled = (PeriodicallyScheduled)this.dbManager.getPersistenceManager().getObjectById(PeriodicallyScheduled.class, (Object)periodicallyScheduledId);
            Calendar startInstance = periodicallyScheduled.getStartInstance();
            try {
                this.dbManager.updateTransferStartInstance(this.transferId, Calendar.getInstance());
            }
            catch (Exception e) {
                System.out.println("\nCheckForTransfers -- Exception in updating the transfer startInstance (1)- " + this.submitter + " - id=" + this.transferId);
                e.printStackTrace();
            }
            try {
                Utils.FrequencyType frequencyType = periodicallyScheduled.getFrequency();
                if (frequencyType == Utils.FrequencyType.perYear) {
                    startInstance.add(1, 1);
                } else if (frequencyType == Utils.FrequencyType.perMonth) {
                    startInstance.add(2, 1);
                } else if (frequencyType == Utils.FrequencyType.perWeek) {
                    startInstance.add(5, 7);
                } else if (frequencyType == Utils.FrequencyType.perDay) {
                    startInstance.add(5, 1);
                } else if (frequencyType == Utils.FrequencyType.perHour) {
                    startInstance.add(11, 1);
                } else if (frequencyType == Utils.FrequencyType.perMinute) {
                    startInstance.add(12, 1);
                }
            }
            catch (Exception e) {
                System.out.println("\nTransferHandler -- Exception in forward the startInstance - " + this.submitter + " - id=" + this.transferId);
                e.printStackTrace();
            }
            try {
                Calendar tmpCalendar = Calendar.getInstance();
                tmpCalendar.set(1, startInstance.get(1));
                tmpCalendar.set(2, startInstance.get(2));
                tmpCalendar.set(5, startInstance.get(5));
                tmpCalendar.set(11, startInstance.get(11));
                tmpCalendar.set(12, startInstance.get(12));
                this.dbManager.updateTransferStartInstance(this.transferId, tmpCalendar);
            }
            catch (Exception e) {
                System.out.println("\nCheckForTransfers -- Exception in updating the transfer startInstance (2)- " + this.submitter + " - id=" + this.transferId);
                e.printStackTrace();
            }
            try {
                this.dbManager.updateTransferStatus(this.transferId, "STANDBY");
            }
            catch (Exception e) {
                System.out.println("\nTransferHandler -- Exception in updating the transfer status - " + this.submitter + " - id=" + this.transferId);
                e.printStackTrace();
            }
        }
    }

    public void addActiveTransferResource() {
        String[] alreadyActiveTransferIDs = this.resource.getActiveTransfers();
        String[] newActiveTransferIDS = new String[alreadyActiveTransferIDs.length + 1];
        int i = 0;
        String[] arr$ = alreadyActiveTransferIDs;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String temp;
            newActiveTransferIDS[i] = temp = arr$[i$];
            ++i;
        }
        newActiveTransferIDS[i] = this.transferId;
        try {
            this.resource.setActiveTransfers(newActiveTransferIDS);
            this.resource.store();
        }
        catch (Exception e) {
            System.out.println("TransferHandler (addResourceOfActiveTransfer)-- Exception in Storing the Resource Property 'ActiveTransfers'");
            e.printStackTrace();
        }
        try {
            int alreadyNumberOfActive = Integer.valueOf(this.resource.getNumOfActiveTransfers());
            String newNumberOfActive = alreadyNumberOfActive + 1 + "";
            this.resource.setNumOfActiveTransfers(newNumberOfActive);
            this.resource.store();
        }
        catch (Exception e) {
            System.out.println("TransferHandler (addResourceOfActiveTransfer) -- Exception in Storing the Resource Property 'NumOfActiveTransfers'");
            e.printStackTrace();
        }
    }

    public void removeActiveTransferResource() {
        String[] alreadyActiveTransferIDs = this.resource.getActiveTransfers();
        String[] newActiveTransferIDS = new String[alreadyActiveTransferIDs.length - 1];
        int i = 0;
        for (String temp : alreadyActiveTransferIDs) {
            if (this.transferId.compareTo(temp) == 0) continue;
            newActiveTransferIDS[i] = temp;
            ++i;
        }
        try {
            this.resource.setActiveTransfers(newActiveTransferIDS);
            this.resource.store();
        }
        catch (Exception e) {
            System.out.println("TransferHandler (removeActiveTransferResource)-- Exception in Storing the Resource Property 'ActiveTransfers'");
            e.printStackTrace();
        }
        try {
            int alreadyNumberOfActive = Integer.valueOf(this.resource.getNumOfActiveTransfers());
            String newNumberOfActive = alreadyNumberOfActive - 1 + "";
            this.resource.setNumOfActiveTransfers(newNumberOfActive);
            this.resource.store();
        }
        catch (Exception e) {
            System.out.println("TransferHandler (removeActiveTransferResource) -- Exception in Storing the Resource Property 'NumOfActiveTransfers'");
            e.printStackTrace();
        }
    }
}

