/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.porttype;

import java.util.Calendar;
import java.util.List;
import javax.jdo.Query;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.ManuallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.db.model.TypeOfSchedule;
import org.gcube.datatransfer.scheduler.impl.porttype.Resource;
import org.gcube.datatransfer.scheduler.impl.porttype.ServiceContext;
import org.gcube.datatransfer.scheduler.impl.porttype.TransferHandler;

public class CheckDBForTransfers
extends Thread {
    DataTransferDBManager dbManager = ServiceContext.getContext().getDbManager();
    Resource resource = null;
    long checkForTransfersIntervalMS = 4000L;

    public CheckDBForTransfers(GCUBEWSResource ws) {
        this.resource = (Resource)ws;
    }

    @Override
    public void run() {
        int runs = 0;
        System.out.println("\nCheckForTransfers - " + this.resource.getName() + " -- Thread has started");
        do {
            ++runs;
            try {
                Thread.sleep(this.checkForTransfersIntervalMS);
            }
            catch (InterruptedException e) {
                System.out.println("CheckForTransfers -- InterruptedException-Unable to sleep - circle of thread=" + runs);
                e.printStackTrace();
            }
            Query query = null;
            List list = null;
            query = ServiceContext.getContext().getDbManager().getPersistenceManager().newQuery(Transfer.class);
            try {
                query.setFilter("status == \"STANDBY\" && submitter == \"" + this.resource.getName() + "\"");
            }
            catch (Exception e) {
                System.out.println("CheckForTransfers -- Exception in retrieving all the activated transfers by query");
                e.printStackTrace();
            }
            list = (List)query.execute();
            for (Transfer obj : list) {
                PeriodicallyScheduled periodicallyScheduled;
                Calendar startInstance;
                TypeOfSchedule typeOfSchedule = null;
                String idTypeOfSchedule = null;
                try {
                    idTypeOfSchedule = obj.getTypeOfScheduleId();
                    typeOfSchedule = (TypeOfSchedule)this.dbManager.getPersistenceManager().getObjectById(TypeOfSchedule.class, (Object)idTypeOfSchedule);
                }
                catch (Exception e) {
                    System.out.println("CheckForTransfers -- Exception in retrieving the typeOfSchedule");
                    e.printStackTrace();
                }
                String periodicallyScheduledId = typeOfSchedule.getPeriodicallyScheduledId();
                String idManuallyScheduled = typeOfSchedule.getManuallyScheduledId();
                if (typeOfSchedule.isDirectedScheduled()) {
                    System.out.println("\nCheckForTransfers - " + obj.getSubmitter() + " -- A transfer (Direct Transfer) is happening today  - transferId:" + obj.getTransferId() + " -- submitter:" + obj.getSubmitter() + " -- status=" + obj.getStatus());
                    try {
                        this.dbManager.updateTransferStatus(obj.getTransferId(), "ONGOING");
                    }
                    catch (Exception e) {
                        System.out.println("\nCheckForTransfers -- Exception in updating the transfer status - " + obj.getSubmitter() + " - id=" + obj.getTransferId());
                        e.printStackTrace();
                    }
                    TransferHandler transferHandler = new TransferHandler(obj.getTransferId(), this.resource, false);
                    transferHandler.start();
                    continue;
                }
                if (idManuallyScheduled != null) {
                    ManuallyScheduled manuallyScheduled = (ManuallyScheduled)this.dbManager.getPersistenceManager().getObjectById(ManuallyScheduled.class, (Object)idManuallyScheduled);
                    Calendar calendarTmp = manuallyScheduled.getCalendar();
                    if (calendarTmp.get(1) != Calendar.getInstance().get(1) || calendarTmp.get(2) != Calendar.getInstance().get(2) || calendarTmp.get(5) != Calendar.getInstance().get(5)) continue;
                    System.out.println("\nCheckForTransfers - " + obj.getSubmitter() + " -- A transfer (Manually Scheduled) is happening today  - transferId:" + obj.getTransferId() + " -- submitter:" + obj.getSubmitter() + " -- status=" + obj.getStatus());
                    try {
                        this.dbManager.updateTransferStatus(obj.getTransferId(), "ONGOING");
                    }
                    catch (Exception e) {
                        System.out.println("\nCheckForTransfers -- Exception in updating the transfer status - " + obj.getSubmitter() + " - id=" + obj.getTransferId());
                        e.printStackTrace();
                    }
                    TransferHandler transferHandler = new TransferHandler(obj.getTransferId(), this.resource, false);
                    transferHandler.start();
                    continue;
                }
                if (periodicallyScheduledId == null || (startInstance = (periodicallyScheduled = (PeriodicallyScheduled)this.dbManager.getPersistenceManager().getObjectById(PeriodicallyScheduled.class, (Object)periodicallyScheduledId)).getStartInstance()).get(1) != Calendar.getInstance().get(1) || startInstance.get(2) != Calendar.getInstance().get(2) || startInstance.get(5) != Calendar.getInstance().get(5) || startInstance.get(10) != Calendar.getInstance().get(10) || startInstance.get(12) != Calendar.getInstance().get(12)) continue;
                System.out.println("\nCheckForTransfers - " + obj.getSubmitter() + " -- A transfer (Periodically Scheduled) is happening today  - transferId:" + obj.getTransferId() + " -- submitter:" + obj.getSubmitter() + " -- status=" + obj.getStatus());
                try {
                    this.dbManager.updateTransferStatus(obj.getTransferId(), "ONGOING");
                }
                catch (Exception e) {
                    System.out.println("\nCheckForTransfers -- Exception in updating the transfer status - " + obj.getSubmitter() + " - id=" + obj.getTransferId());
                    e.printStackTrace();
                }
                TransferHandler transferHandler = new TransferHandler(obj.getTransferId(), this.resource, true);
                transferHandler.start();
            }
        } while (!Thread.interrupted());
    }
}

