package org.gcube.datatransfer.scheduler.impl.porttype;


import static org.gcube.datatransfer.agent.library.proxies.Proxies.transferAgent;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

import javax.jdo.Query;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.datatransfer.agent.library.AgentLibrary;
import org.gcube.datatransfer.agent.library.outcome.FileTransferOutcome;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StorageManagerDetails;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StorageType;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.Agent;
import org.gcube.datatransfer.scheduler.db.model.DataSource;
import org.gcube.datatransfer.scheduler.db.model.DataStorage;
import org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.db.model.TransferObject;
import org.gcube.datatransfer.scheduler.db.model.TypeOfSchedule;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.FrequencyType;




public class TransferHandler extends Thread {
	Transfer transfer;
	String submitter;
	String transferId;
	DataTransferDBManager dbManager;
	Resource resource;
	String transferType;
	long checkTransferResultIntervalMS=3000;
	
	//private static GCUBELog logger = new GCUBELog(TransferHandler.class);
	
	public TransferHandler(String transferId, GCUBEWSResource ws,boolean isPeriodically){
		this.dbManager=ServiceContext.getContext().getDbManager();
		this.transferId=transferId;		
		this.resource=(Resource) ws;
		this.transfer=this.dbManager.getPersistenceManager().getObjectById(Transfer.class, this.transferId);
		
		this.submitter=this.dbManager.getPersistenceManager().getObjectById(Transfer.class, this.transferId).getSubmitter();		
		this.transferType=this.dbManager.getPersistenceManager().getObjectById(DataSource.class, this.transfer.getSourceId()).getType();		
		
	}
	
	public void run() {
		System.out.println("\nTransferHandler - "+this.resource.getName()+" -- Thread has started");
		
		Query query=null;
		List<TransferObject> list=null;
		query = ServiceContext.getContext().getDbManager().getPersistenceManager().newQuery(TransferObject.class);
		list = (List<TransferObject>) query.execute();
				
		 //collecting the right TransferObjects
		//check for the objects having the same trasferId with this one.
		List<TransferObject> objectsToBeTransferred= new ArrayList<TransferObject>();
		String transferIdOfSpecific;
		
		for(TransferObject obj : list){
			transferIdOfSpecific = obj.getTransferid();
			if((transferIdOfSpecific==this.transferId)){
				objectsToBeTransferred.add(obj); 				
			}
		}

		AgentLibrary agentLibrary = null;
		List<String> objectTrasferredIDs = new ArrayList<String>();
		List<String> objectFailedIDs = new ArrayList<String>();
		boolean failed=false;	
		List<String> errorsInTransfer = new ArrayList<String>();
		
		//retrieving the Agent Host and Port
		String agentId = this.transfer.getAgentId();
    	if(agentId==null)System.out.println("TransferHandler - Error - agentId=null");
		String hostAgent=this.dbManager.getPersistenceManager().getObjectById(Agent.class,agentId).getHost();
    	int portAgent = this.dbManager.getPersistenceManager().getObjectById(Agent.class,agentId).getPort();
    	
		
		
		//    *******TRANSFER*******    //

		if(this.transferType=="LocalFileBasedTransfer"){
			
			List<File> filesToBeTransferred = new ArrayList<File>();
			for(TransferObject obj : objectsToBeTransferred){
				filesToBeTransferred.add(new File(obj.getURI()));
			}			
			//first needed input for the agent method
			File[] files = filesToBeTransferred.toArray(new File[filesToBeTransferred.size()]);
			//second needed input for the agent method
			File destinationFolder = new File(this.dbManager.getPersistenceManager().getObjectById(DataStorage.class,this.transfer.getStorageId()).getOutputUrl());
			//third needed input for the agent method
			boolean overwrite = this.dbManager.getPersistenceManager().getObjectById(DataStorage.class,this.transfer.getStorageId()).isOverwrite();
		
			ArrayList<FileTransferOutcome> outcomes = null;			
			try {
			GCUBEScopeManager.DEFAULT.setScope(GCUBEScope.getScope("/gcube/devsec/"));

			agentLibrary =  transferAgent().at(hostAgent, portAgent).build();	

			// *** LocalFileBasedTransfer *** //
			outcomes = agentLibrary.copyLocalFiles(files, destinationFolder,overwrite);
			System.out.println("TransferHandler - After the agentLibrary.copyLocalFiles(...)");
			} catch (Exception e) {
				System.out.println("TransferHandler - Exception when call agentLibrary.copyLocalFiles(.....)");
				errorsInTransfer.add(e.getMessage());
				failed=true;
				e.printStackTrace();
			}	
			
			try{
				int numOfObj=0;
				for (FileTransferOutcome outcome : outcomes){
					System.out.println("Exception: "+outcome.getException());
					System.out.println("FileName: "+ outcome.getFilename());
					System.out.println("Success?: "+ outcome.isSuccess());
					System.out.println("Failure?: "+ outcome.isFailure());
				
					if(outcome.isFailure()==true){
						objectFailedIDs.add(objectsToBeTransferred.get(numOfObj).getObjectId());			
					}
					else if (outcome.isSuccess()==true){
						objectTrasferredIDs.add(objectsToBeTransferred.get(numOfObj).getObjectId());
					}
					numOfObj++;
				}
			} catch (Exception e) {
				System.out.println("TransferHandler - Exception when read the outcomes");
				errorsInTransfer.add(e.getMessage());
				failed=true;
				e.printStackTrace();
			}		

			 //check the status of transfer
			// if failed
			if(failed==true){
				try {	
				this.dbManager.updateTransferStatus(this.transferId, "FAILED");
				this.dbManager.updateTransferError(this.transferId, errorsInTransfer);
				}catch (Exception e) {
				System.out.println("TransferHandler -- IfFailed - Exception - "+this.submitter+" - id="+this.transferId);
				e.printStackTrace();
				}
			}
			else{
			// if completed
				try {						
				this.dbManager.updateTransferStatus(this.transferId, "COMPLETED");
				String[] objectFailedIDsarray=objectFailedIDs.toArray(new String[objectFailedIDs.size()]);
				String[] objectTrasferredIDsarray=objectTrasferredIDs.toArray(new String[objectTrasferredIDs.size()]);
				
				this.dbManager.updateObjectTrasferredIDs(this.transferId, objectTrasferredIDsarray);
				this.dbManager.updateObjectFailedIDs(this.transferId, objectFailedIDsarray);
				//System.out.println("TransferHandler -- Completed - "+this.submitter+" - id="+this.transferId);
				System.out.println("TransferHandler -- Completed - "+this.submitter+" - id="+this.transferId);			
				}catch (Exception e) {
				System.out.println("TransferHandler -- IfCompleted - Exception");

				e.printStackTrace();
				}
				//optional printing
				for(String objId : this.dbManager.getPersistenceManager().getObjectById(Transfer.class,this.transferId).getObjectTrasferredIDs())
					System.out.println("TransferHandler -- Completed - TransferredObjectID:"+objId);
				
				for(String objId : this.dbManager.getPersistenceManager().getObjectById(Transfer.class,this.transferId).getObjectFailedIDs())
					System.out.println("TransferHandler -- Completed - FailedObjectID:"+objId);
			}
		}
		else if(this.transferType=="FileBasedTransfer"){
			
			//first needed input for the agent method
			URL[] inputUrls=new URL[objectsToBeTransferred.size()];
			int i=0;
			for(TransferObject obj : objectsToBeTransferred){
				try {
					inputUrls[i]=new URL(obj.getURI());
				} catch (MalformedURLException e) {
					System.out.println("TransferHandler -- Exception when setting the inputUrls");
					errorsInTransfer.add(e.getMessage());
					failed=true;
					e.printStackTrace();
				}
				i++;
			}	

			//second needed input for the agent method
			String destinationFolder = this.dbManager.getPersistenceManager().getObjectById(DataStorage.class,this.transfer.getStorageId()).getOutputUrl();
			
			//third input for the agent method
			StorageType storageType=null;
			if(this.dbManager.getPersistenceManager().getObjectById(DataStorage.class,this.transfer.getStorageId()).getType()==StorageType.LocalGHN.getValue()){
				storageType=StorageType.LocalGHN;
			}
			else if(this.dbManager.getPersistenceManager().getObjectById(DataStorage.class,this.transfer.getStorageId()).getType()==StorageType.StorageManager.getValue()){
				storageType=StorageType.StorageManager;
			}

			//fourth needed input for the agent method
			boolean overwrite = this.dbManager.getPersistenceManager().getObjectById(DataStorage.class,this.transfer.getStorageId()).isOverwrite();

			  //fifth(last) input for the agent method
			 // storageManagerDetails has to be filled with the real info	
			StorageManagerDetails storageManagerDetails = new StorageManagerDetails();
			storageManagerDetails.setOwner("NickDrakopoulos");
			storageManagerDetails.setServiceName("--");
			storageManagerDetails.setServiceClass("--");
			StorageManagerDetails[] storageManagerDetailsArray= {storageManagerDetails};
			
			Future<String> transferIdOfAgent = null;			
			try {
			GCUBEScopeManager.DEFAULT.setScope(GCUBEScope.getScope("/gcube/devsec/"));

			agentLibrary =  transferAgent().at(hostAgent, portAgent).build();	

			// *** startTransfer *** //
			transferIdOfAgent = agentLibrary.startTransfer(inputUrls, destinationFolder, storageType, overwrite, storageManagerDetailsArray);
			System.out.println("TransferHandler - After the agentLibrary.startTransfer(...)");
			} catch (Exception e) {
				System.out.println("TransferHandler - Exception when call agentLibrary.startTransfer(.....)");
				errorsInTransfer.add(e.getMessage());
				failed=true;
				e.printStackTrace();
			}	
			
			try	{ // *** store the transferIdOfAgent inside the Transfer in DB ***
				ServiceContext.getContext().getDbManager().updateTransferIdOfAgentInTransfer(this.transferId,transferIdOfAgent.get());
				}
			catch(Exception e){
				System.out.println("TransferHandler "+
						"- Exception in storing the transferIdOfAgent inside the Transfer in DB\n");
				e.printStackTrace();
			}
			
			String resultOfMonitoring="";
			do{	
				try{
				// *** monitorTransfer *** //
				resultOfMonitoring = agentLibrary.monitorTransfer(transferIdOfAgent.get());
				//System.out.println("TransferHandler - After the agentLibrary.monitorTransfer(...)");
				} catch (Exception e) {
					System.out.println("TransferHandler - Exception when call agentLibrary.monitorTransfer(.....)");
					errorsInTransfer.add(e.getMessage());
					failed=true;
					e.printStackTrace();
				}
				try {
					Thread.sleep(checkTransferResultIntervalMS);
				} catch (InterruptedException e) {
					System.out.println("TransferHandler -- InterruptedException-Unable to sleep");
					e.printStackTrace();
				}		
			}while(resultOfMonitoring.compareTo("STARTED")==0);

			System.out.println("TransferHandler -- monitorTransfer result="+resultOfMonitoring);
			
			//*** getTransferOutcomes *** //
			try {
			ArrayList<FileTransferOutcome> outcomes = agentLibrary.getTransferOutcomes(transferIdOfAgent.get(), FileTransferOutcome.class);			
			int numOfObj=0;
			for (FileTransferOutcome outcome : outcomes){
				if(numOfObj==0)System.out.println("TransferHandler -- getTransferOutcomes:");
				System.out.println("Exception: "+outcome.getException());
				System.out.println("FileName: "+ outcome.getFilename());
				System.out.println("Success?: "+ outcome.isSuccess());
				System.out.println("Failure?: "+ outcome.isFailure());
			
				if(outcome.isFailure()==true){
					objectFailedIDs.add(objectsToBeTransferred.get(numOfObj).getObjectId());			
				}
				else if (outcome.isSuccess()==true){
					objectTrasferredIDs.add(objectsToBeTransferred.get(numOfObj).getObjectId());
				}
				numOfObj++;
			}
			} catch (Exception e) {
				System.out.println("TransferHandler - Exception when call agentLibrary.getTransferOutcomes(..) and read the outcomes");
				errorsInTransfer.add(e.getMessage());
				failed=true;
				e.printStackTrace();
			}		
			
			String retrivedStatus= this.dbManager.getPersistenceManager().getObjectById(Transfer.class,this.transferId).getStatus();

			if(retrivedStatus=="CANCELED"){
				System.out.println("TransferHandler -- Canceled");
				return;
			}

			//check the status of transfer
			if(resultOfMonitoring.compareTo("CANCEL")==0){
				try {					
				this.dbManager.updateTransferStatus(this.transferId, "CANCELED");
				System.out.println("TransferHandler -- Canceled - "+this.submitter+" - id="+this.transferId);			
				}catch (Exception e) {
				System.out.println("TransferHandler -- IfCanceled - Exception");
				e.printStackTrace();
				}
			}
			else if(resultOfMonitoring.compareTo("DONE")==0){
				try {					
				this.dbManager.updateTransferStatus(this.transferId, "COMPLETED");
				System.out.println("TransferHandler -- Completed - "+this.submitter+" - id="+this.transferId);			
				
				String[] objectFailedIDsarray=objectFailedIDs.toArray(new String[objectFailedIDs.size()]);
				String[] objectTrasferredIDsarray=objectTrasferredIDs.toArray(new String[objectTrasferredIDs.size()]);
				
				this.dbManager.updateObjectTrasferredIDs(this.transferId, objectTrasferredIDsarray);
				this.dbManager.updateObjectFailedIDs(this.transferId, objectFailedIDsarray);
			
				}catch (Exception e) {
				System.out.println("TransferHandler -- IfCompleted - Exception");
				e.printStackTrace();
				}

				//optional printing
				for(String objId : this.dbManager.getPersistenceManager().getObjectById(Transfer.class,this.transferId).getObjectTrasferredIDs())
					System.out.println("TransferHandler -- Completed - TransferredObjectID:"+objId);
				
				for(String objId : this.dbManager.getPersistenceManager().getObjectById(Transfer.class,this.transferId).getObjectFailedIDs())
					System.out.println("TransferHandler -- Completed - FailedObjectID:"+objId);

			}
			else { //"FAILED"
				try {					
				this.dbManager.updateTransferStatus(this.transferId, "FAILED");
				//check for the outcome!! call the agent library and get the outcome! 
				this.dbManager.updateTransferError(this.transferId, errorsInTransfer);
				System.out.println("TransferHandler -- Failed - "+this.submitter+" - id="+this.transferId);			
				}catch (Exception e) {
				System.out.println("TransferHandler -- IfFailed - Exception");
				e.printStackTrace();
				}
			}
		}
		else if(this.transferType=="TreeBasedTransfer"){
			// ##### empty for now #####
		}
		
		 //-------------------------------------------------------------------------------//
		//-------------------------------------------------------------------------------//
       //------------only in case of a periodically scheduled---------------------------//

		String idTypeOfSchedule=this.transfer.getTypeOfScheduleId();
		TypeOfSchedule typeOfSchedule = this.dbManager.getPersistenceManager().getObjectById(TypeOfSchedule.class,idTypeOfSchedule );
		String periodicallyScheduledId = typeOfSchedule.getPeriodicallyScheduledId();	
		String retrivedStatus= this.dbManager.getPersistenceManager().getObjectById(Transfer.class,this.transferId).getStatus();

		 // if it's periodically scheduled we change (refresh with a new value) the startInstance
		// and we make the status of the transfer STANDBY again
	   // but if it's been changed in CANCELED in the meantime we keep it as it is...
		if((periodicallyScheduledId!=null)&&(retrivedStatus!="CANCELED")){
			PeriodicallyScheduled periodicallyScheduled = this.dbManager.getPersistenceManager().getObjectById(PeriodicallyScheduled.class,periodicallyScheduledId );
			Calendar startInstance=periodicallyScheduled.getStartInstance();
			
			try {					
				FrequencyType frequencyType = periodicallyScheduled.getFrequency();
	
				if(frequencyType==FrequencyType.perYear)startInstance.roll(Calendar.YEAR, 1);
				else if(frequencyType==FrequencyType.perMonth)startInstance.roll(Calendar.MONTH, 1);
				else if(frequencyType==FrequencyType.perWeek)startInstance.roll(Calendar.DAY_OF_MONTH, 7);
				else if(frequencyType==FrequencyType.perDay)startInstance.roll(Calendar.DAY_OF_MONTH, 1);
				else if(frequencyType==FrequencyType.perHour)startInstance.roll(Calendar.HOUR, 1);
				else if(frequencyType==FrequencyType.perMinute)startInstance.roll(Calendar.MINUTE, 1);
			}catch (Exception e) {
			System.out.println("\nTransferHandler -- Exception in forward the startInstance - "+this.submitter +" - id="+this.transferId);
			e.printStackTrace();
			}

			try{				
				//i don't use the startInstance variable because it creates a problem when trying to store it in db 
				//it seems that there's an issue after using the 'roll' method.. that's why we copy
				//the values that we want in another calendar variable
				Calendar tmpCalendar=Calendar.getInstance();
				tmpCalendar.set(Calendar.YEAR,startInstance.get(Calendar.YEAR));
				tmpCalendar.set(Calendar.MONTH,startInstance.get(Calendar.MONTH));
				tmpCalendar.set(Calendar.DAY_OF_MONTH,startInstance.get(Calendar.DAY_OF_MONTH));
				tmpCalendar.set(Calendar.HOUR,startInstance.get(Calendar.HOUR));
				tmpCalendar.set(Calendar.MINUTE,startInstance.get(Calendar.MINUTE));
				
				this.dbManager.updateTransferStartInstance(this.transferId, tmpCalendar);
				}catch (Exception e) {
				System.out.println("\nCheckForTransfers -- Exception in updating the transfer startInstance - "+this.submitter +" - id="+this.transferId);
			e.printStackTrace();
			}

			try {	
			this.dbManager.updateTransferStatus(this.transferId, "STANDBY");
			}catch (Exception e) {
			System.out.println("\nTransferHandler -- Exception in updating the transfer status - "+this.submitter +" - id="+this.transferId);
			e.printStackTrace();
			}
		}
	
	}
	

}
