/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.porttype;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.Future;
import javax.jdo.Query;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.datatransfer.agent.library.AgentLibrary;
import org.gcube.datatransfer.agent.library.outcome.FileTransferOutcome;
import org.gcube.datatransfer.agent.library.proxies.Proxies;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StorageManagerDetails;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StorageType;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.Agent;
import org.gcube.datatransfer.scheduler.db.model.DataSource;
import org.gcube.datatransfer.scheduler.db.model.DataStorage;
import org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.db.model.TransferObject;
import org.gcube.datatransfer.scheduler.db.model.TypeOfSchedule;
import org.gcube.datatransfer.scheduler.impl.porttype.Resource;
import org.gcube.datatransfer.scheduler.impl.porttype.ServiceContext;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.FrequencyType;

public class TransferHandler
extends Thread {
    Transfer transfer;
    String submitter;
    String transferId;
    DataTransferDBManager dbManager = ServiceContext.getContext().getDbManager();
    Resource resource;
    String transferType;
    long checkTransferResultIntervalMS = 3000L;

    public TransferHandler(String transferId, GCUBEWSResource ws, boolean isPeriodically) {
        this.transferId = transferId;
        this.resource = (Resource)ws;
        this.transfer = (Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)this.transferId);
        this.submitter = ((Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)this.transferId)).getSubmitter();
        this.transferType = ((DataSource)this.dbManager.getPersistenceManager().getObjectById(DataSource.class, (Object)this.transfer.getSourceId())).getType();
    }

    @Override
    public void run() {
        Object destinationFolder;
        System.out.println("\nTransferHandler - " + this.resource.getName() + " -- Thread has started");
        Query query = null;
        List list = null;
        query = ServiceContext.getContext().getDbManager().getPersistenceManager().newQuery(TransferObject.class);
        list = (List)query.execute();
        ArrayList<TransferObject> objectsToBeTransferred = new ArrayList<TransferObject>();
        for (TransferObject obj : list) {
            String transferIdOfSpecific = obj.getTransferid();
            if (transferIdOfSpecific != this.transferId) continue;
            objectsToBeTransferred.add(obj);
        }
        AgentLibrary agentLibrary = null;
        ArrayList<String> objectTrasferredIDs = new ArrayList<String>();
        ArrayList<String> objectFailedIDs = new ArrayList<String>();
        boolean failed = false;
        ArrayList<String> errorsInTransfer = new ArrayList<String>();
        String agentId = this.transfer.getAgentId();
        if (agentId == null) {
            System.out.println("TransferHandler - Error - agentId=null");
        }
        String hostAgent = ((Agent)this.dbManager.getPersistenceManager().getObjectById(Agent.class, (Object)agentId)).getHost();
        int portAgent = ((Agent)this.dbManager.getPersistenceManager().getObjectById(Agent.class, (Object)agentId)).getPort();
        if (this.transferType == "LocalFileBasedTransfer") {
            ArrayList<File> filesToBeTransferred = new ArrayList<File>();
            for (TransferObject obj : objectsToBeTransferred) {
                filesToBeTransferred.add(new File(obj.getURI()));
            }
            File[] files = filesToBeTransferred.toArray(new File[filesToBeTransferred.size()]);
            destinationFolder = new File(((DataStorage)this.dbManager.getPersistenceManager().getObjectById(DataStorage.class, (Object)this.transfer.getStorageId())).getOutputUrl());
            boolean overwrite = ((DataStorage)this.dbManager.getPersistenceManager().getObjectById(DataStorage.class, (Object)this.transfer.getStorageId())).isOverwrite();
            ArrayList outcomes = null;
            try {
                GCUBEScopeManager.DEFAULT.setScope(GCUBEScope.getScope((String)"/gcube/devsec/"));
                agentLibrary = (AgentLibrary)Proxies.transferAgent().at(hostAgent, portAgent).build();
                outcomes = agentLibrary.copyLocalFiles(files, (File)destinationFolder, overwrite);
                System.out.println("TransferHandler - After the agentLibrary.copyLocalFiles(...)");
            }
            catch (Exception e) {
                System.out.println("TransferHandler - Exception when call agentLibrary.copyLocalFiles(.....)");
                errorsInTransfer.add(e.getMessage());
                failed = true;
                e.printStackTrace();
            }
            try {
                int numOfObj = 0;
                for (FileTransferOutcome outcome : outcomes) {
                    System.out.println("Exception: " + outcome.getException());
                    System.out.println("FileName: " + outcome.getFilename());
                    System.out.println("Success?: " + outcome.isSuccess());
                    System.out.println("Failure?: " + outcome.isFailure());
                    if (outcome.isFailure()) {
                        objectFailedIDs.add(((TransferObject)objectsToBeTransferred.get(numOfObj)).getObjectId());
                    } else if (outcome.isSuccess()) {
                        objectTrasferredIDs.add(((TransferObject)objectsToBeTransferred.get(numOfObj)).getObjectId());
                    }
                    ++numOfObj;
                }
            }
            catch (Exception e) {
                System.out.println("TransferHandler - Exception when read the outcomes");
                errorsInTransfer.add(e.getMessage());
                failed = true;
                e.printStackTrace();
            }
            if (failed) {
                try {
                    this.dbManager.updateTransferStatus(this.transferId, "FAILED");
                    this.dbManager.updateTransferError(this.transferId, errorsInTransfer);
                }
                catch (Exception e) {
                    System.out.println("TransferHandler -- IfFailed - Exception - " + this.submitter + " - id=" + this.transferId);
                    e.printStackTrace();
                }
            } else {
                String objId;
                try {
                    this.dbManager.updateTransferStatus(this.transferId, "COMPLETED");
                    String[] objectFailedIDsarray = objectFailedIDs.toArray(new String[objectFailedIDs.size()]);
                    String[] objectTrasferredIDsarray = objectTrasferredIDs.toArray(new String[objectTrasferredIDs.size()]);
                    this.dbManager.updateObjectTrasferredIDs(this.transferId, objectTrasferredIDsarray);
                    this.dbManager.updateObjectFailedIDs(this.transferId, objectFailedIDsarray);
                    System.out.println("TransferHandler -- Completed - " + this.submitter + " - id=" + this.transferId);
                }
                catch (Exception e) {
                    System.out.println("TransferHandler -- IfCompleted - Exception");
                    e.printStackTrace();
                }
                String[] stringArray = ((Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)this.transferId)).getObjectTrasferredIDs();
                int n = stringArray.length;
                int objectTrasferredIDsarray = 0;
                while (objectTrasferredIDsarray < n) {
                    objId = stringArray[objectTrasferredIDsarray];
                    System.out.println("TransferHandler -- Completed - TransferredObjectID:" + objId);
                    ++objectTrasferredIDsarray;
                }
                stringArray = ((Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)this.transferId)).getObjectFailedIDs();
                n = stringArray.length;
                objectTrasferredIDsarray = 0;
                while (objectTrasferredIDsarray < n) {
                    objId = stringArray[objectTrasferredIDsarray];
                    System.out.println("TransferHandler -- Completed - FailedObjectID:" + objId);
                    ++objectTrasferredIDsarray;
                }
            }
        } else if (this.transferType == "FileBasedTransfer") {
            URL[] inputUrls = new URL[objectsToBeTransferred.size()];
            int i = 0;
            for (TransferObject obj : objectsToBeTransferred) {
                try {
                    inputUrls[i] = new URL(obj.getURI());
                }
                catch (MalformedURLException e) {
                    System.out.println("TransferHandler -- Exception when setting the inputUrls");
                    errorsInTransfer.add(e.getMessage());
                    failed = true;
                    e.printStackTrace();
                }
                ++i;
            }
            destinationFolder = ((DataStorage)this.dbManager.getPersistenceManager().getObjectById(DataStorage.class, (Object)this.transfer.getStorageId())).getOutputUrl();
            StorageType storageType = null;
            if (((DataStorage)this.dbManager.getPersistenceManager().getObjectById(DataStorage.class, (Object)this.transfer.getStorageId())).getType() == StorageType.LocalGHN.getValue()) {
                storageType = StorageType.LocalGHN;
            } else if (((DataStorage)this.dbManager.getPersistenceManager().getObjectById(DataStorage.class, (Object)this.transfer.getStorageId())).getType() == StorageType.StorageManager.getValue()) {
                storageType = StorageType.StorageManager;
            }
            boolean overwrite = ((DataStorage)this.dbManager.getPersistenceManager().getObjectById(DataStorage.class, (Object)this.transfer.getStorageId())).isOverwrite();
            StorageManagerDetails storageManagerDetails = new StorageManagerDetails();
            storageManagerDetails.setOwner("NickDrakopoulos");
            storageManagerDetails.setServiceName("--");
            storageManagerDetails.setServiceClass("--");
            StorageManagerDetails[] storageManagerDetailsArray = new StorageManagerDetails[]{storageManagerDetails};
            Future transferIdOfAgent = null;
            try {
                GCUBEScopeManager.DEFAULT.setScope(GCUBEScope.getScope((String)"/gcube/devsec/"));
                agentLibrary = (AgentLibrary)Proxies.transferAgent().at(hostAgent, portAgent).build();
                transferIdOfAgent = agentLibrary.startTransfer(inputUrls, (String)destinationFolder, storageType, overwrite, storageManagerDetailsArray);
                System.out.println("TransferHandler - After the agentLibrary.startTransfer(...)");
            }
            catch (Exception e) {
                System.out.println("TransferHandler - Exception when call agentLibrary.startTransfer(.....)");
                errorsInTransfer.add(e.getMessage());
                failed = true;
                e.printStackTrace();
            }
            try {
                ServiceContext.getContext().getDbManager().updateTransferIdOfAgentInTransfer(this.transferId, (String)transferIdOfAgent.get());
            }
            catch (Exception e) {
                System.out.println("TransferHandler - Exception in storing the transferIdOfAgent inside the Transfer in DB\n");
                e.printStackTrace();
            }
            String resultOfMonitoring = "";
            do {
                try {
                    resultOfMonitoring = agentLibrary.monitorTransfer((String)transferIdOfAgent.get());
                }
                catch (Exception e) {
                    System.out.println("TransferHandler - Exception when call agentLibrary.monitorTransfer(.....)");
                    errorsInTransfer.add(e.getMessage());
                    failed = true;
                    e.printStackTrace();
                }
                try {
                    Thread.sleep(this.checkTransferResultIntervalMS);
                }
                catch (InterruptedException e) {
                    System.out.println("TransferHandler -- InterruptedException-Unable to sleep");
                    e.printStackTrace();
                }
            } while (resultOfMonitoring.compareTo("STARTED") == 0);
            System.out.println("TransferHandler -- monitorTransfer result=" + resultOfMonitoring);
            try {
                ArrayList outcomes = agentLibrary.getTransferOutcomes((String)transferIdOfAgent.get(), FileTransferOutcome.class);
                int numOfObj = 0;
                for (FileTransferOutcome outcome : outcomes) {
                    if (numOfObj == 0) {
                        System.out.println("TransferHandler -- getTransferOutcomes:");
                    }
                    System.out.println("Exception: " + outcome.getException());
                    System.out.println("FileName: " + outcome.getFilename());
                    System.out.println("Success?: " + outcome.isSuccess());
                    System.out.println("Failure?: " + outcome.isFailure());
                    if (outcome.isFailure()) {
                        objectFailedIDs.add(((TransferObject)objectsToBeTransferred.get(numOfObj)).getObjectId());
                    } else if (outcome.isSuccess()) {
                        objectTrasferredIDs.add(((TransferObject)objectsToBeTransferred.get(numOfObj)).getObjectId());
                    }
                    ++numOfObj;
                }
            }
            catch (Exception e) {
                System.out.println("TransferHandler - Exception when call agentLibrary.getTransferOutcomes(..) and read the outcomes");
                errorsInTransfer.add(e.getMessage());
                failed = true;
                e.printStackTrace();
            }
            String retrivedStatus = ((Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)this.transferId)).getStatus();
            if (retrivedStatus == "CANCELED") {
                System.out.println("TransferHandler -- Canceled");
                return;
            }
            if (resultOfMonitoring.compareTo("CANCEL") == 0) {
                try {
                    this.dbManager.updateTransferStatus(this.transferId, "CANCELED");
                    System.out.println("TransferHandler -- Canceled - " + this.submitter + " - id=" + this.transferId);
                }
                catch (Exception e) {
                    System.out.println("TransferHandler -- IfCanceled - Exception");
                    e.printStackTrace();
                }
            } else if (resultOfMonitoring.compareTo("DONE") == 0) {
                String objId;
                try {
                    this.dbManager.updateTransferStatus(this.transferId, "COMPLETED");
                    System.out.println("TransferHandler -- Completed - " + this.submitter + " - id=" + this.transferId);
                    String[] objectFailedIDsarray = objectFailedIDs.toArray(new String[objectFailedIDs.size()]);
                    String[] objectTrasferredIDsarray = objectTrasferredIDs.toArray(new String[objectTrasferredIDs.size()]);
                    this.dbManager.updateObjectTrasferredIDs(this.transferId, objectTrasferredIDsarray);
                    this.dbManager.updateObjectFailedIDs(this.transferId, objectFailedIDsarray);
                }
                catch (Exception e) {
                    System.out.println("TransferHandler -- IfCompleted - Exception");
                    e.printStackTrace();
                }
                String[] stringArray = ((Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)this.transferId)).getObjectTrasferredIDs();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    objId = stringArray[n2];
                    System.out.println("TransferHandler -- Completed - TransferredObjectID:" + objId);
                    ++n2;
                }
                stringArray = ((Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)this.transferId)).getObjectFailedIDs();
                n = stringArray.length;
                n2 = 0;
                while (n2 < n) {
                    objId = stringArray[n2];
                    System.out.println("TransferHandler -- Completed - FailedObjectID:" + objId);
                    ++n2;
                }
            } else {
                try {
                    this.dbManager.updateTransferStatus(this.transferId, "FAILED");
                    this.dbManager.updateTransferError(this.transferId, errorsInTransfer);
                    System.out.println("TransferHandler -- Failed - " + this.submitter + " - id=" + this.transferId);
                }
                catch (Exception e) {
                    System.out.println("TransferHandler -- IfFailed - Exception");
                    e.printStackTrace();
                }
            }
        }
        String idTypeOfSchedule = this.transfer.getTypeOfScheduleId();
        TypeOfSchedule typeOfSchedule = (TypeOfSchedule)this.dbManager.getPersistenceManager().getObjectById(TypeOfSchedule.class, (Object)idTypeOfSchedule);
        String periodicallyScheduledId = typeOfSchedule.getPeriodicallyScheduledId();
        String retrivedStatus = ((Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)this.transferId)).getStatus();
        if (periodicallyScheduledId != null && retrivedStatus != "CANCELED") {
            PeriodicallyScheduled periodicallyScheduled = (PeriodicallyScheduled)this.dbManager.getPersistenceManager().getObjectById(PeriodicallyScheduled.class, (Object)periodicallyScheduledId);
            Calendar startInstance = periodicallyScheduled.getStartInstance();
            try {
                FrequencyType frequencyType = periodicallyScheduled.getFrequency();
                if (frequencyType == FrequencyType.perYear) {
                    startInstance.roll(1, 1);
                } else if (frequencyType == FrequencyType.perMonth) {
                    startInstance.roll(2, 1);
                } else if (frequencyType == FrequencyType.perWeek) {
                    startInstance.roll(5, 7);
                } else if (frequencyType == FrequencyType.perDay) {
                    startInstance.roll(5, 1);
                } else if (frequencyType == FrequencyType.perHour) {
                    startInstance.roll(10, 1);
                } else if (frequencyType == FrequencyType.perMinute) {
                    startInstance.roll(12, 1);
                }
            }
            catch (Exception e) {
                System.out.println("\nTransferHandler -- Exception in forward the startInstance - " + this.submitter + " - id=" + this.transferId);
                e.printStackTrace();
            }
            try {
                Calendar tmpCalendar = Calendar.getInstance();
                tmpCalendar.set(1, startInstance.get(1));
                tmpCalendar.set(2, startInstance.get(2));
                tmpCalendar.set(5, startInstance.get(5));
                tmpCalendar.set(10, startInstance.get(10));
                tmpCalendar.set(12, startInstance.get(12));
                this.dbManager.updateTransferStartInstance(this.transferId, tmpCalendar);
            }
            catch (Exception e) {
                System.out.println("\nCheckForTransfers -- Exception in updating the transfer startInstance - " + this.submitter + " - id=" + this.transferId);
                e.printStackTrace();
            }
            try {
                this.dbManager.updateTransferStatus(this.transferId, "STANDBY");
            }
            catch (Exception e) {
                System.out.println("\nTransferHandler -- Exception in updating the transfer status - " + this.submitter + " - id=" + this.transferId);
                e.printStackTrace();
            }
        }
    }
}

