package org.gcube.datatransfer.scheduler.library.plugins;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.datatransfer.scheduler.library.SchedulerLibrary;
import org.gcube.datatransfer.scheduler.library.utils.Constants;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.SchedulerPortType;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.service.SchedulerServiceAddressingLocator;

public class SchedulerServicePlugin extends SchedulerAbstractPlugin<SchedulerPortType,SchedulerLibrary> {

	public SchedulerServicePlugin() {
		super(Constants.SERVICE_NAME);
	}

	public SchedulerPortType resolve(EndpointReferenceType address,ProxyConfig<?,?> config) throws Exception {
		return new SchedulerServiceAddressingLocator().getSchedulerPortTypePort(address);
	}
	
	@Override
	public SchedulerLibrary newProxy(ProxyDelegate<SchedulerPortType> delegate) {
		return new SchedulerLibrary(delegate);
		//return null;
	}

	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> arg1) {
		if (fault instanceof GCUBEFault)
			return new Exception();
		//if (fault instanceof TransferFault)
		//	return new TransferException();
		//if (fault instanceof CancelTransferFault)
		//	return new CancelTransferException();
		//if (fault instanceof MonitorTransferFault)
		//	return new MonitorTransferException();
		//if (fault instanceof GetTransferOutcomesFault)
		//	return new GetTransferOutcomesException();
		
		return fault;
	}



}