package org.gcube.datatransfer.scheduler.library.plugins;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.datatransfer.scheduler.library.ManagementLibrary;
import org.gcube.datatransfer.scheduler.library.utils.Constants;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.ManagementPortType;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.service.ManagementServiceAddressingLocator;

public class ManagementServicePlugin extends ManagementAbstractPlugin<ManagementPortType,ManagementLibrary> {

	public ManagementServicePlugin() {
		super(Constants.SERVICE_NAME);
	}

	public ManagementPortType resolve(EndpointReferenceType address,ProxyConfig<?,?> config) throws Exception {
		return new ManagementServiceAddressingLocator().getManagementPortTypePort(address);
	}
	
	@Override
	public ManagementLibrary newProxy(ProxyDelegate<ManagementPortType> delegate) {
		return new ManagementLibrary(delegate);
	}

	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> arg1) {
		if (fault instanceof GCUBEFault)
			return new Exception();
		//if (fault instanceof TransferFault)
		//	return new TransferException();
		//if (fault instanceof CancelTransferFault)
		//	return new CancelTransferException();
		//if (fault instanceof MonitorTransferFault)
		//	return new MonitorTransferException();
		//if (fault instanceof GetTransferOutcomesFault)
		//	return new GetTransferOutcomesException();
		
		return fault;
	}


}