/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.scheduler.db.DBManager;
import org.gcube.datatransfer.scheduler.db.model.Agent;
import org.gcube.datatransfer.scheduler.db.model.AgentStatistics;
import org.gcube.datatransfer.scheduler.db.model.DataSource;
import org.gcube.datatransfer.scheduler.db.model.DataStorage;
import org.gcube.datatransfer.scheduler.db.model.ManuallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.db.model.TransferObject;
import org.gcube.datatransfer.scheduler.db.model.TransferOutcome;
import org.gcube.datatransfer.scheduler.db.model.TypeOfSchedule;

public class DataTransferDBManager
extends DBManager
implements Runnable {
    GCUBELog logger = new GCUBELog(DataTransferDBManager.class);

    public DataTransferDBManager(String dbConfigurationFileName, String persistenceRootPath, String propertyConfig) {
        this.dbFileBaseFolder = persistenceRootPath + File.separator + "DataTransferDB";
        this.dbName = "data_transfer";
        this.dbFileName = this.dbFileBaseFolder + File.separator + this.dbName + ".db";
        backupFolder = new File(System.getenv("HOME") + File.separator + "DataTransferDBBackup");
        Properties prop = new Properties();
        String propFile = GHNContext.getContext().getLocation() + File.separator + propertyConfig + File.separator + dbConfigurationFileName;
        try {
            prop.load(new FileInputStream(new File(propFile)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logger.debug((Object)("DataTransferDBManager (General constructor) has been created : \nproperties File=" + propFile));
        this.persistenceFactory = JDOHelper.getPersistenceManagerFactory((Map)prop);
        Thread t = new Thread(this);
        t.start();
    }

    public DataTransferDBManager() {
        this.dbFileBaseFolder = "/home/nick/DataNucleus/transfer-scheduler-db" + File.separator + "DataTransferDB";
        this.dbName = "data_transfer";
        this.dbFileName = this.dbFileBaseFolder + File.separator + this.dbName + ".db";
        backupFolder = new File(System.getenv("HOME") + File.separator + "DataTransferDBBackup");
        Properties prop = new Properties();
        URL properties = null;
        properties = Thread.currentThread().getContextClassLoader().getResource("db.properties");
        try {
            prop.load(properties.openStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logger.debug((Object)"DataTransferDBManager (For testing inside the eclipse) has been created : \nproperties File=db.properties");
        this.persistenceFactory = JDOHelper.getPersistenceManagerFactory((Map)prop);
        Thread t = new Thread(this);
        t.start();
    }

    public void storeTransfer(Transfer transfer) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            persistenceManager.makePersistent((Object)transfer);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void storeTransferObject(Set<TransferObject> transferObjects) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            for (TransferObject obj : transferObjects) {
                persistenceManager.currentTransaction().begin();
                persistenceManager.makePersistent((Object)obj);
                persistenceManager.currentTransaction().commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void storeTypeOfSchedule(TypeOfSchedule typeOfSchedule) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            persistenceManager.makePersistent((Object)typeOfSchedule);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void storePeriodicallyScheduled(PeriodicallyScheduled periodicallyScheduled) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            persistenceManager.makePersistent((Object)periodicallyScheduled);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void storeManuallyScheduled(ManuallyScheduled manuallyScheduled) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            persistenceManager.makePersistent((Object)manuallyScheduled);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void storeAgent(Agent agent) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            persistenceManager.makePersistent((Object)agent);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void storeSource(DataSource source) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            persistenceManager.makePersistent((Object)source);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void storeStorage(DataStorage storage) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            persistenceManager.makePersistent((Object)storage);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void storeAgentStatistics(AgentStatistics agentStatistics) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            persistenceManager.makePersistent((Object)agentStatistics);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void storeTransferOutcomes(TransferOutcome transferOutcome) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            persistenceManager.makePersistent((Object)transferOutcome);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void deleteTransfer(Transfer transfer) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            persistenceManager.deletePersistent((Object)transfer);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void deleteTransferObject(Set<TransferObject> transferObjects) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            for (TransferObject obj : transferObjects) {
                persistenceManager.currentTransaction().begin();
                persistenceManager.deletePersistent((Object)obj);
                persistenceManager.currentTransaction().commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void deleteAgent(Agent agent) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            persistenceManager.deletePersistent((Object)agent);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateTransferStatus(String transferId, String status) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            t.setStatus(status);
            persistenceManager.makePersistent((Object)t);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateTransferBytes(String transferId, long total_size, long transferredBytes) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            t.setTotal_size(total_size);
            t.setBytes_have_been_transferred(transferredBytes);
            persistenceManager.makePersistent((Object)t);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateTransferError(String transferId, List<String> errors) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            t.setTransferError(errors);
            persistenceManager.makePersistent((Object)t);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateObjectTrasferredIDs(String transferId, String[] objectTrasferredIDs) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            t.setObjectTrasferredIDs(objectTrasferredIDs);
            persistenceManager.makePersistent((Object)t);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateObjectFailedIDs(String transferId, String[] objectFailedIDs) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            t.setObjectFailedIDs(objectFailedIDs);
            persistenceManager.makePersistent((Object)t);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateAgentInTransfer(String transferId, String agentid) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            Transfer transfer = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            transfer.setAgentId(agentid);
            persistenceManager.makePersistent((Object)transfer);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateStartTimeInTransfer(String transferId, long startTime) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            Transfer transfer = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            transfer.setStartTime(startTime);
            persistenceManager.makePersistent((Object)transfer);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateTotalTimeInTransfer(String transferId, long totalTime) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            Transfer transfer = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            transfer.setStartTime(-1L);
            transfer.setTotalTime(totalTime);
            persistenceManager.makePersistent((Object)transfer);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateStorageInTransfer(String transferId, String storageid) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            Transfer transfer = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            transfer.setStorageId(storageid);
            persistenceManager.makePersistent((Object)transfer);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateSourceInTransfer(String transferId, String sourceid) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            Transfer transfer = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            transfer.setSourceId(sourceid);
            persistenceManager.makePersistent((Object)transfer);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateTransferIdOfAgentInTransfer(String transferId, String transferIdOfAgent) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            Transfer transfer = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            transfer.setTransferIdOfAgent(transferIdOfAgent);
            persistenceManager.makePersistent((Object)transfer);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateTransferStartInstance(String transferId, Calendar startInstance) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            String idTypeOfSchedule = t.getTypeOfScheduleId();
            TypeOfSchedule typeOfSchedule = (TypeOfSchedule)persistenceManager.getObjectById(TypeOfSchedule.class, (Object)idTypeOfSchedule);
            String idperiodicallyScheduled = typeOfSchedule.getPeriodicallyScheduledId();
            PeriodicallyScheduled periodicallyScheduled = (PeriodicallyScheduled)persistenceManager.getObjectById(PeriodicallyScheduled.class, (Object)idperiodicallyScheduled);
            periodicallyScheduled.setStartInstance(startInstance);
            persistenceManager.makePersistent((Object)periodicallyScheduled);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateTransferReadyObjects(String transferId, boolean flag) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            Transfer transfer = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            transfer.setReadyObjects(flag);
            persistenceManager.makePersistent((Object)transfer);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateOutcomesInTransfer(String transferId, List<String> outcomes) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            t.setOutcomes(outcomes);
            persistenceManager.makePersistent((Object)t);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateEverythingInAgent(String agentId, String agentIdOfIs, String host, int port) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            Agent agent = (Agent)persistenceManager.getObjectById(Agent.class, (Object)agentId);
            agent.setAgentIdOfIS(agentIdOfIs);
            agent.setHost(host);
            agent.setPort(port);
            persistenceManager.makePersistent((Object)agent);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateEverythingInSource(String sourceId, String dataSourceIdOfIS, String dataSourceName, String description, String endpoint, String username, String pass, String folder) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            DataSource source = (DataSource)persistenceManager.getObjectById(DataSource.class, (Object)sourceId);
            source.setDataSourceIdOfIS(dataSourceIdOfIS);
            source.setDataSourceName(dataSourceName);
            source.setDescription(description);
            source.setEndpoint(endpoint);
            source.setFolder(folder);
            source.setUsername(username);
            source.setPass(pass);
            persistenceManager.makePersistent((Object)source);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateEverythingInStorage(String id, String idOfIS, String dataStorageName, String description, String endpoint, String username, String pass) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            DataStorage storage = (DataStorage)persistenceManager.getObjectById(DataStorage.class, (Object)id);
            storage.setDataStorageIdOfIS(idOfIS);
            storage.setDataStorageName(dataStorageName);
            storage.setDescription(description);
            storage.setEndpoint(endpoint);
            storage.setUsername(username);
            storage.setPass(pass);
            persistenceManager.makePersistent((Object)storage);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateAgentStatistics(String id, int ongoing, int failed, int succeeded, int canceled, int total) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            AgentStatistics stats = (AgentStatistics)persistenceManager.getObjectById(AgentStatistics.class, (Object)id);
            stats.setOngoingTransfers(ongoing);
            stats.setFailedTransfers(failed);
            stats.setSucceededTransfers(succeeded);
            stats.setCanceledTransfers(canceled);
            stats.setTotalFinishedTransfers(total);
            persistenceManager.makePersistent((Object)stats);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    @Override
    public void run() {
        do {
            try {
                Thread.sleep(backupIntervalMS);
                this.backup();
            }
            catch (InterruptedException e) {
                this.logger.error((Object)"Unable to sleep", (Throwable)e);
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to backup", (Throwable)e);
            }
        } while (!Thread.interrupted());
    }

    public PersistenceManager getPersistenceManager() {
        return this.persistenceFactory.getPersistenceManager();
    }
}

