/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.scheduler.db.DBManager;
import org.gcube.datatransfer.scheduler.db.model.Agent;
import org.gcube.datatransfer.scheduler.db.model.DataSource;
import org.gcube.datatransfer.scheduler.db.model.DataStorage;
import org.gcube.datatransfer.scheduler.db.model.ManuallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.db.model.TransferObject;
import org.gcube.datatransfer.scheduler.db.model.TypeOfSchedule;

public class DataTransferDBManager
extends DBManager
implements Runnable {
    GCUBELog logger = new GCUBELog(DataTransferDBManager.class);

    public DataTransferDBManager(String dbConfigurationFileName, String persistenceRootPath, String propertyConfig) {
        this.dbFileBaseFolder = persistenceRootPath + File.separator + "DataTransferDB";
        this.dbName = "data_transfer";
        this.dbFileName = this.dbFileBaseFolder + File.separator + this.dbName + ".db";
        backupFolder = new File(System.getenv("HOME") + File.separator + "DataTransferDBBackup");
        Properties prop = new Properties();
        String propFile = GHNContext.getContext().getLocation() + File.separator + propertyConfig + File.separator + dbConfigurationFileName;
        try {
            prop.load(new FileInputStream(new File(propFile)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("DataTransferDBManager (General constructor) has been created : \nproperties File=" + propFile);
        this.persistenceFactory = JDOHelper.getPersistenceManagerFactory((Map)prop);
        Thread t = new Thread(this);
        t.start();
    }

    public DataTransferDBManager() {
        this.dbFileBaseFolder = "/home/nick/DataNucleus/transfer-scheduler-db" + File.separator + "DataTransferDB";
        this.dbName = "data_transfer";
        this.dbFileName = this.dbFileBaseFolder + File.separator + this.dbName + ".db";
        backupFolder = new File(System.getenv("HOME") + File.separator + "DataTransferDBBackup");
        Properties prop = new Properties();
        URL properties = null;
        properties = Thread.currentThread().getContextClassLoader().getResource("db.properties");
        try {
            prop.load(properties.openStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("DataTransferDBManager (For testing inside the eclipse) has been created : \nproperties File=db.properties");
        this.persistenceFactory = JDOHelper.getPersistenceManagerFactory((Map)prop);
        Thread t = new Thread(this);
        t.start();
    }

    public void storeTransfer(Transfer transfer) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            persistenceManager.makePersistent((Object)transfer);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void storeTransferObject(Set<TransferObject> transferObjects) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            for (TransferObject obj : transferObjects) {
                persistenceManager.currentTransaction().begin();
                persistenceManager.makePersistent((Object)obj);
                persistenceManager.currentTransaction().commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void storeTypeOfSchedule(TypeOfSchedule typeOfSchedule) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            persistenceManager.makePersistent((Object)typeOfSchedule);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void storePeriodicallyScheduled(PeriodicallyScheduled periodicallyScheduled) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            persistenceManager.makePersistent((Object)periodicallyScheduled);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void storeManuallyScheduled(ManuallyScheduled manuallyScheduled) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            persistenceManager.makePersistent((Object)manuallyScheduled);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void storeAgent(Agent agent) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            persistenceManager.makePersistent((Object)agent);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void storeSource(DataSource source) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            persistenceManager.makePersistent((Object)source);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void storeStorage(DataStorage storage) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            persistenceManager.makePersistent((Object)storage);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void deleteTransfer(Transfer transfer) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            persistenceManager.deletePersistent((Object)transfer);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void deleteTransferObject(Set<TransferObject> transferObjects) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            for (TransferObject obj : transferObjects) {
                persistenceManager.currentTransaction().begin();
                persistenceManager.deletePersistent((Object)obj);
                persistenceManager.currentTransaction().commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void deleteAgent(Agent agent) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            persistenceManager.deletePersistent((Object)agent);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateTransferStatus(String transferId, String status) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            t.setStatus(status);
            persistenceManager.makePersistent((Object)t);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateTransferError(String transferId, List<String> errors) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            t.setTransferError(errors);
            persistenceManager.makePersistent((Object)t);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateObjectTrasferredIDs(String transferId, String[] objectTrasferredIDs) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            t.setObjectTrasferredIDs(objectTrasferredIDs);
            persistenceManager.makePersistent((Object)t);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateObjectFailedIDs(String transferId, String[] objectFailedIDs) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            t.setObjectFailedIDs(objectFailedIDs);
            persistenceManager.makePersistent((Object)t);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateAgentInTransfer(String transferId, String agentid) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            Transfer transfer = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            transfer.setAgentId(agentid);
            persistenceManager.makePersistent((Object)transfer);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateStorageInTransfer(String transferId, String storageid) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            Transfer transfer = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            transfer.setStorageId(storageid);
            persistenceManager.makePersistent((Object)transfer);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateSourceInTransfer(String transferId, String sourceid) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            Transfer transfer = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            transfer.setSourceId(sourceid);
            persistenceManager.makePersistent((Object)transfer);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateTransferIdOfAgentInTransfer(String transferId, String transferIdOfAgent) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            Transfer transfer = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            transfer.setTransferIdOfAgent(transferIdOfAgent);
            persistenceManager.makePersistent((Object)transfer);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateTransferStartInstance(String transferId, Calendar startInstance) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
            String idTypeOfSchedule = t.getTypeOfScheduleId();
            TypeOfSchedule typeOfSchedule = (TypeOfSchedule)persistenceManager.getObjectById(TypeOfSchedule.class, (Object)idTypeOfSchedule);
            String idperiodicallyScheduled = typeOfSchedule.getPeriodicallyScheduledId();
            PeriodicallyScheduled periodicallyScheduled = (PeriodicallyScheduled)persistenceManager.getObjectById(PeriodicallyScheduled.class, (Object)idperiodicallyScheduled);
            periodicallyScheduled.setStartInstance(startInstance);
            persistenceManager.makePersistent((Object)periodicallyScheduled);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateAgentStatus(String agentId, String status) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            Agent agent = (Agent)persistenceManager.getObjectById(Agent.class, (Object)agentId);
            agent.setStatus(status);
            persistenceManager.makePersistent((Object)agent);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateSourceStatus(String sourceId, String status) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            DataSource source = (DataSource)persistenceManager.getObjectById(DataSource.class, (Object)sourceId);
            source.setStatus(status);
            persistenceManager.makePersistent((Object)source);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateStorageStatus(String storageId, String status) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            DataStorage storage = (DataStorage)persistenceManager.getObjectById(DataStorage.class, (Object)storageId);
            storage.setStatus(status);
            persistenceManager.makePersistent((Object)storage);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    @Override
    public void run() {
        do {
            try {
                Thread.sleep(backupIntervalMS);
                this.backup();
            }
            catch (InterruptedException e) {
                this.logger.error((Object)"Unable to sleep", (Throwable)e);
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to backup", (Throwable)e);
            }
        } while (!Thread.interrupted());
    }

    public PersistenceManager getPersistenceManager() {
        return this.persistenceFactory.getPersistenceManager();
    }
}

