/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.plugins.decompress;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.plugin.AbstractPluginFactory;
import org.gcube.data.transfer.plugin.fails.ParameterException;
import org.gcube.data.transfer.plugin.fails.PluginInitializationException;
import org.gcube.data.transfer.plugin.fails.PluginShutDownException;
import org.gcube.data.transfer.plugin.model.DataTransferContext;
import org.gcube.data.transfer.plugins.decompress.DecompressPlugin;

public class DecompressPluginFactory
extends AbstractPluginFactory<DecompressPlugin> {
    static final String PLUGIN_ID = "DECOMPRESS";
    public static final String SOURCE_PARAMETER = "SOURCE_ARCHIVE";
    public static final String DESTINATION_PARAMETER = "DESTINATION";
    public static final String OVERWRITE_DESTINATION = "OVERWITE_DESTINATION";
    public static final String DELETE_ARCHIVE = "DELETE_ARCHIVE";
    public static final String ARCHIVE_TYPE = "ARCHIVE_TYPE";
    static final Map<String, String> PARAMETERS_DESCRIPTION = new HashMap<String, String>();

    public String getID() {
        return PLUGIN_ID;
    }

    public String getDescription() {
        return String.format("Decompress a <%s> archive file to a given <%s>.", SOURCE_PARAMETER, DESTINATION_PARAMETER);
    }

    public Map<String, String> getParameters() {
        return PARAMETERS_DESCRIPTION;
    }

    public boolean init(DataTransferContext ctx) throws PluginInitializationException {
        return true;
    }

    public DecompressPlugin createWorker(PluginInvocation invocation) {
        return new DecompressPlugin(invocation);
    }

    public PluginInvocation checkInvocation(PluginInvocation invocation, String transferredFile) throws ParameterException {
        try {
            File source;
            HashMap<String, String> params = invocation.getParameters();
            if (params == null || params.isEmpty()) {
                params = new HashMap<String, String>();
            }
            if (!params.containsKey(SOURCE_PARAMETER)) {
                params.put(SOURCE_PARAMETER, transferredFile);
            }
            if (!params.containsKey(OVERWRITE_DESTINATION)) {
                params.put(OVERWRITE_DESTINATION, "false");
            }
            if (!params.containsKey(DELETE_ARCHIVE)) {
                params.put(DELETE_ARCHIVE, "false");
            }
            if (!(source = new File((String)params.get(SOURCE_PARAMETER))).exists()) {
                throw new ParameterException("Source file " + (String)params.get(SOURCE_PARAMETER) + " not found.");
            }
            if (!source.canRead()) {
                throw new ParameterException("Cannot read Source file " + (String)params.get(SOURCE_PARAMETER) + ".");
            }
            String destinationPath = source.getParent() + (params.containsKey(DESTINATION_PARAMETER) ? File.pathSeparator + (String)params.get(DESTINATION_PARAMETER) : "");
            new File(destinationPath);
            try {
                Boolean.parseBoolean((String)params.get(OVERWRITE_DESTINATION));
            }
            catch (Throwable t) {
                throw new ParameterException("Unable to evaluate parameter OVERWITE_DESTINATION", t);
            }
            try {
                Boolean.parseBoolean((String)params.get(DELETE_ARCHIVE));
            }
            catch (Throwable t) {
                throw new ParameterException("Unable to evaluate parameter DELETE_ARCHIVE", t);
            }
            invocation.setParameters(params);
            return invocation;
        }
        catch (ParameterException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ParameterException("Unable to check invocation parameters ", t);
        }
    }

    public boolean shutDown() throws PluginShutDownException {
        return true;
    }

    static {
        PARAMETERS_DESCRIPTION.put(DESTINATION_PARAMETER, "[String value] The folder destination of uncompressed content expressed as a path relative to <SOURCE_ARCHIVE>. Default is same directory of <SOURCE_ARCHIVE>.");
        PARAMETERS_DESCRIPTION.put(OVERWRITE_DESTINATION, "[Boolean value] Set true in order to overwrite <DESTINATION> content. Default is false");
        PARAMETERS_DESCRIPTION.put(DELETE_ARCHIVE, "[Boolean value] Set true in order to delete <SOURCE_ARCHIVE> after extracting content. Default is false");
    }
}

