/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.service.transfers;

import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.gcube.data.transfer.model.TransferTicket;
import org.gcube.data.transfer.service.DTServiceAppManager;
import org.gcube.data.transfer.service.transfers.engine.TicketManager;
import org.gcube.data.transfer.service.transfers.engine.faults.TicketNotFoundException;
import org.gcube.smartgears.annotations.ManagedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="TransferStatus")
@ManagedBy(value=DTServiceAppManager.class)
public class TransferStatus {
    private static final Logger log = LoggerFactory.getLogger(TransferStatus.class);
    @Inject
    private TicketManager manager;

    @GET
    @Path(value="/{transfer-id}")
    @Produces(value={"application/json"})
    public TransferTicket getTicket(@PathParam(value="transfer-id") @NotNull String requestId) {
        try {
            log.debug("Returning status for id " + requestId);
            return this.manager.get(requestId);
        }
        catch (TicketNotFoundException e) {
            throw new NotFoundException();
        }
        catch (Throwable t) {
            log.error("Unexpected exception ", t);
            throw new InternalServerErrorException();
        }
    }
}

