/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.service.transfers;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.data.transfer.model.TransferCapabilities;
import org.gcube.data.transfer.service.DTServiceAppManager;
import org.gcube.data.transfer.service.transfers.engine.CapabilitiesProvider;
import org.gcube.data.transfer.service.transfers.engine.PluginManager;
import org.gcube.data.transfer.service.transfers.engine.faults.PluginNotFoundException;
import org.gcube.smartgears.annotations.ManagedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="Capabilities")
@ManagedBy(value=DTServiceAppManager.class)
public class Capabilities {
    private static final Logger log = LoggerFactory.getLogger(Capabilities.class);
    @Inject
    CapabilitiesProvider provider;
    PluginManager plugins = PluginManager.get();

    @GET
    @Produces(value={"application/json"})
    public TransferCapabilities getCapabilities() {
        log.debug("Serving get capabilities");
        try {
            TransferCapabilities toReturn = this.provider.get();
            log.debug("No exceptions here.. returning " + toReturn);
            return toReturn;
        }
        catch (Exception e) {
            log.debug("Unable to return capabilities.", (Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="pluginInfo/{pluginId}")
    @Produces(value={"application/json"})
    public Response getPluginInfo(@PathParam(value="pluginId") String pluginID) {
        log.trace("Getting plugin info for plugin ID : {} ", (Object)pluginID);
        try {
            return Response.ok((Object)this.plugins.getPluginInfo(pluginID), (String)"application/json").build();
        }
        catch (PluginNotFoundException e) {
            throw new WebApplicationException("Plugin " + pluginID + " has not been found", Response.Status.NOT_FOUND);
        }
        catch (Throwable t) {
            throw new WebApplicationException("Unexpected error. ", t, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

