/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.service.transfers;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import javax.activation.MimetypesFileTypeMap;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.gcube.data.transfer.model.DeletionReport;
import org.gcube.data.transfer.model.Destination;
import org.gcube.data.transfer.model.DestinationClashPolicy;
import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.model.TransferRequest;
import org.gcube.data.transfer.model.TransferTicket;
import org.gcube.data.transfer.model.options.FileUploadOptions;
import org.gcube.data.transfer.model.options.HttpDownloadOptions;
import org.gcube.data.transfer.model.options.TransferOptions;
import org.gcube.data.transfer.model.settings.FileUploadSettings;
import org.gcube.data.transfer.model.settings.HttpDownloadSettings;
import org.gcube.data.transfer.model.settings.TransferSettings;
import org.gcube.data.transfer.service.transfers.REST;
import org.gcube.data.transfer.service.transfers.engine.PersistenceProvider;
import org.gcube.data.transfer.service.transfers.engine.RequestManager;
import org.gcube.data.transfer.service.transfers.engine.faults.DestinationAccessException;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="REST/{destinationId}/{subPath : \\S*}")
public class REST {
    private static final Logger log = LoggerFactory.getLogger(REST.class);
    @PathParam(value="destinationId")
    String destinationID;
    @PathParam(value="subPath")
    String subPath;
    @Inject
    RequestManager requests;
    @Inject
    PersistenceProvider persistence;

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    public Object serveFileUpload(@QueryParam(value="method") @DefaultValue(value="FileUpload") String methodString, @QueryParam(value="destination-file-name") String destinationFileName, @QueryParam(value="create-dirs") @DefaultValue(value="true") Boolean createDirs, @QueryParam(value="on-existing-file") @DefaultValue(value="ADD_SUFFIX") DestinationClashPolicy onExistingFile, @QueryParam(value="on-existing-dir") @DefaultValue(value="APPEND") DestinationClashPolicy onExistingDirectory, @QueryParam(value="source-id") String sourceID, @FormDataParam(value="uploadedFile") InputStream uploadedFile, @FormDataParam(value="uploadedFile") FormDataContentDisposition uploadedFileDetails, @FormDataParam(value="plugin-invocations") Set<PluginInvocation> pluginInvocations) {
        try {
            String pathString = "<" + this.destinationID + ">/" + this.subPath;
            log.info("Received POST request at {} ", (Object)pathString);
            log.debug("Plugin invocation set : {} ", pluginInvocations);
            TransferRequest request = this.formRequestFromREST(methodString, this.destinationID, this.subPath, pluginInvocations, createDirs, onExistingFile, onExistingDirectory, uploadedFile, uploadedFileDetails, destinationFileName, sourceID);
            log.info("Received REST Request {} ", (Object)request);
            TransferTicket ticket = this.requests.put(request);
            if (ticket.getSettings().getOptions().getMethod().equals((Object)TransferOptions.TransferMethod.FileUpload)) {
                log.debug("Resulting sync ticket {} ", (Object)ticket);
                return ticket;
            }
            return ticket;
        }
        catch (WebApplicationException e) {
            log.error("Unable to serve request", (Throwable)e);
            throw e;
        }
    }

    private TransferRequest formRequestFromREST(String methodString, String destinationID, String subPath, Set<PluginInvocation> pluginInvocations, Boolean createDirs, DestinationClashPolicy onExistingFile, DestinationClashPolicy onExistingDirectory, InputStream uploadedFile, FormDataContentDisposition uploadedFileDetails, String destinationFileName, String sourceID) {
        log.info("Creating TransferRequest from REST invocation method : {}, dest ID {}, sub Path {} ", new Object[]{methodString, destinationID, subPath});
        TransferOptions.TransferMethod method = null;
        try {
            method = TransferOptions.TransferMethod.valueOf((String)methodString);
        }
        catch (Throwable t) {
            throw new WebApplicationException("Invalid selected method " + methodString, t, Response.Status.BAD_REQUEST);
        }
        Destination destination = new Destination();
        destination.setCreateSubfolders(createDirs);
        destination.setPersistenceId(destinationID);
        destination.setSubFolder(subPath);
        destination.setOnExistingSubFolder(onExistingDirectory);
        destination.setOnExistingFileName(onExistingFile);
        TransferRequest resultingRequest = new TransferRequest();
        resultingRequest.setDestinationSettings(destination);
        resultingRequest.setPluginInvocations(pluginInvocations);
        switch (1.$SwitchMap$org$gcube$data$transfer$model$options$TransferOptions$TransferMethod[method.ordinal()]) {
            case 1: {
                if (uploadedFileDetails == null) {
                    throw new WebApplicationException("Missing multipart  uploadedFile details.", Response.Status.BAD_REQUEST);
                }
                if (uploadedFile == null) {
                    throw new WebApplicationException("Missing multipart  uploadedFile stream.", Response.Status.BAD_REQUEST);
                }
                destination.setDestinationFileName(destinationFileName != null ? destinationFileName : uploadedFileDetails.getFileName());
                FileUploadSettings uploadSettings = new FileUploadSettings(uploadedFile, new FileUploadOptions());
                resultingRequest.setSettings((TransferSettings)uploadSettings);
                break;
            }
            case 2: {
                throw new WebApplicationException("Unsupported selected method " + methodString, Response.Status.BAD_REQUEST);
            }
            case 3: {
                if (sourceID == null) {
                    throw new WebApplicationException("Parameter source-id is mandatory.", Response.Status.BAD_REQUEST);
                }
                destination.setDestinationFileName(destinationFileName);
                try {
                    HttpDownloadSettings settings = new HttpDownloadSettings(new URL(sourceID), new HttpDownloadOptions());
                    resultingRequest.setSettings((TransferSettings)settings);
                    break;
                }
                catch (MalformedURLException e) {
                    throw new WebApplicationException("Source " + sourceID + " is not a valid URL.", (Throwable)e, Response.Status.BAD_REQUEST);
                }
            }
            default: {
                throw new WebApplicationException("Unsupported selected method " + methodString, Response.Status.BAD_REQUEST);
            }
        }
        return resultingRequest;
    }

    @GET
    @Produces(value={"*/*"})
    public Response getFile(@QueryParam(value="descriptor") @DefaultValue(value="false") Boolean getDescriptor) {
        String pathString = "<" + this.destinationID + ">/" + this.subPath;
        log.info("Received GET request at {} , descriptor option is {} ", (Object)pathString, (Object)getDescriptor);
        try {
            if (getDescriptor.booleanValue()) {
                return Response.ok((Object)this.persistence.getDescriptor(this.destinationID, this.subPath), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
            }
            File persisted = this.persistence.getPersistedFile(this.destinationID, this.subPath);
            if (!persisted.exists()) {
                throw new WebApplicationException("File " + pathString + " doesn't exists.", Response.Status.NOT_FOUND);
            }
            if (persisted.isDirectory()) {
                throw new WebApplicationException("The selected path " + pathString + " is a directory.", Response.Status.BAD_REQUEST);
            }
            String mt = new MimetypesFileTypeMap().getContentType(persisted);
            return Response.ok((Object)persisted, (String)mt).build();
        }
        catch (DestinationAccessException e) {
            throw new WebApplicationException("Unable to access selected path " + pathString, (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    @Produces(value={"application/json"})
    public DeletionReport deleteFile() {
        String pathString = "<" + this.destinationID + ">/" + this.subPath;
        log.info("Received DELETE request at {}", (Object)pathString);
        try {
            return this.persistence.delete(this.destinationID, this.subPath);
        }
        catch (DestinationAccessException e) {
            throw new WebApplicationException("Unable to access selected path " + pathString, (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

