/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.service.transfers;

import java.io.File;
import java.io.InputStream;
import java.util.Set;
import javax.activation.MimetypesFileTypeMap;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.data.transfer.model.DestinationClashPolicy;
import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.model.TransferRequest;
import org.gcube.data.transfer.model.TransferTicket;
import org.gcube.data.transfer.model.options.TransferOptions;
import org.gcube.data.transfer.service.transfers.engine.PersistenceProvider;
import org.gcube.data.transfer.service.transfers.engine.RequestManager;
import org.gcube.data.transfer.service.transfers.engine.faults.DestinationAccessException;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="REST")
public class REST {
    private static final Logger log = LoggerFactory.getLogger(REST.class);
    @Inject
    RequestManager requests;
    @Inject
    PersistenceProvider persistence;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$data$transfer$model$options$TransferOptions$TransferMethod;

    @POST
    @Path(value="/{method}/{destinationId}/{subPath: .*}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    public Object serveFileUpload(@PathParam(value="method") String methodString, @PathParam(value="destinationId") String destinationID, @PathParam(value="subPath") String subPath, @QueryParam(value="destination-file-name") String destinationFileName, @QueryParam(value="create-dirs") @DefaultValue(value="true") Boolean createDirs, @QueryParam(value="on-existing-file") @DefaultValue(value="ADD_SUFFIX") DestinationClashPolicy onExistingFile, @QueryParam(value="on-existing-dir") @DefaultValue(value="APPEND") DestinationClashPolicy onExistingDirectory, @QueryParam(value="source-id") String sourceID, @FormDataParam(value="uploadedFile") InputStream uploadedFile, @FormDataParam(value="uploadedFile") FormDataContentDisposition uploadedFileDetails, @FormDataParam(value="plugin-invocations") Set<PluginInvocation> pluginInvocations) {
        try {
            log.debug("Plugin invocation set : {} ", pluginInvocations);
            TransferRequest request = this.formRequestFromREST(methodString, destinationID, subPath, pluginInvocations, createDirs, onExistingFile, onExistingDirectory, uploadedFile, uploadedFileDetails, destinationFileName, sourceID);
            log.info("Received REST Request {} ", (Object)request);
            TransferTicket ticket = this.requests.put(request);
            if (ticket.getSettings().getOptions().getMethod().equals((Object)TransferOptions.TransferMethod.FileUpload)) {
                log.debug("Resulting sync ticket {} ", (Object)ticket);
                return ticket;
            }
            return ticket;
        }
        catch (WebApplicationException e) {
            log.error("Unable to serve request", (Throwable)e);
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    private TransferRequest formRequestFromREST(String methodString, String destinationID, String subPath, Set<PluginInvocation> pluginInvocations, Boolean createDirs, DestinationClashPolicy onExistingFile, DestinationClashPolicy onExistingDirectory, InputStream uploadedFile, FormDataContentDisposition uploadedFileDetails, String destinationFileName, String sourceID) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Path(value="/{destinationId}/{subPath: .*}")
    @GET
    @Produces(value={"*/*"})
    public Response getFile(@PathParam(value="destinationId") String destinationId, @PathParam(value="subPath") String subPath) {
        String pathString = "<" + destinationId + ">" + "/" + subPath;
        log.trace("Serving file for path {} ", (Object)pathString);
        try {
            File persisted = this.persistence.getPersistedFile(destinationId, subPath);
            if (!persisted.exists()) {
                throw new WebApplicationException("File " + pathString + " doesn't exists.", Response.Status.NOT_FOUND);
            }
            if (persisted.isDirectory()) {
                throw new WebApplicationException("The selected path " + pathString + " is a directory.", Response.Status.BAD_REQUEST);
            }
            String mt = new MimetypesFileTypeMap().getContentType(persisted);
            return Response.ok((Object)persisted, (String)mt).build();
        }
        catch (DestinationAccessException e) {
            throw new WebApplicationException("Unable to access selected path " + pathString, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Path(value="/{destinationId}/{subPath: .*}")
    @HEAD
    @Produces(value={"*/*"})
    public Response getFileDescriptor(@PathParam(value="destinationId") String destinationId, @PathParam(value="subPath") String subPath) {
        String pathString = "<" + destinationId + ">" + "/" + subPath;
        try {
            File persisted = this.persistence.getPersistedFile(destinationId, subPath);
            if (!persisted.exists()) {
                throw new WebApplicationException("File " + pathString + " doesn't exists.", Response.Status.NOT_FOUND);
            }
            if (persisted.isDirectory()) {
                throw new WebApplicationException("The selected path " + pathString + " is a directory.", Response.Status.BAD_REQUEST);
            }
            String mt = new MimetypesFileTypeMap().getContentType(persisted);
            return Response.ok((Object)persisted, (String)mt).build();
        }
        catch (DestinationAccessException e) {
            throw new WebApplicationException("Unable to access selected path " + pathString, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$data$transfer$model$options$TransferOptions$TransferMethod() {
        if ($SWITCH_TABLE$org$gcube$data$transfer$model$options$TransferOptions$TransferMethod != null) {
            return $SWITCH_TABLE$org$gcube$data$transfer$model$options$TransferOptions$TransferMethod;
        }
        int[] nArray = new int[TransferOptions.TransferMethod.values().length];
        try {
            nArray[TransferOptions.TransferMethod.DirectTransfer.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TransferOptions.TransferMethod.FileUpload.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TransferOptions.TransferMethod.HTTPDownload.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$gcube$data$transfer$model$options$TransferOptions$TransferMethod = nArray;
        return nArray;
    }
}

