/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.service.transfers;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.data.transfer.model.Destination;
import org.gcube.data.transfer.model.DestinationClashPolicy;
import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.model.TransferRequest;
import org.gcube.data.transfer.model.TransferTicket;
import org.gcube.data.transfer.model.options.FileUploadOptions;
import org.gcube.data.transfer.model.options.HttpDownloadOptions;
import org.gcube.data.transfer.model.options.TransferOptions;
import org.gcube.data.transfer.model.settings.FileUploadSettings;
import org.gcube.data.transfer.model.settings.HttpDownloadSettings;
import org.gcube.data.transfer.model.settings.TransferSettings;
import org.gcube.data.transfer.service.transfers.REST;
import org.gcube.data.transfer.service.transfers.engine.RequestManager;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="REST")
public class REST {
    private static final Logger log = LoggerFactory.getLogger(REST.class);
    @Inject
    RequestManager requests;
    @QueryParam(value="destination-file-name")
    String destinationFileName;
    @QueryParam(value="create-dirs")
    @DefaultValue(value="true")
    Boolean createDirs;
    @QueryParam(value="on-existing-file")
    @DefaultValue(value="ADD_SUFFIX")
    DestinationClashPolicy onExistingFile;
    @QueryParam(value="on-existing-dir")
    @DefaultValue(value="APPEND")
    DestinationClashPolicy onExistingDirectory;
    @QueryParam(value="source-id")
    String sourceID;
    @FormDataParam(value="uploadedFile")
    InputStream uploadedFile;
    @FormDataParam(value="uploadedFile")
    FormDataContentDisposition uploadedFileDetails;
    @FormDataParam(value="plugin-invocations")
    Set<PluginInvocation> pluginInvocations;

    @POST
    @Path(value="/{method}/{destinationId}/{subPath: .*}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    public Object serveFileUpload(@PathParam(value="method") String methodString, @PathParam(value="destinationId") String destinationID, @PathParam(value="subPath") String subPath) {
        try {
            log.debug("Plugin invocation set : {} ", (Object)this.pluginInvocations);
            TransferRequest request = this.formRequestFromREST(methodString, destinationID, subPath, this.pluginInvocations);
            log.info("Received REST Request {} ", (Object)request);
            TransferTicket ticket = this.requests.put(request);
            if (ticket.getSettings().getOptions().getMethod().equals((Object)TransferOptions.TransferMethod.FileUpload)) {
                log.debug("Resulting sync ticket {} ", (Object)ticket);
                return ticket;
            }
            return ticket;
        }
        catch (WebApplicationException e) {
            log.error("Unable to serve request", (Throwable)e);
            throw e;
        }
    }

    private TransferRequest formRequestFromREST(String methodString, String destinationID, String subPath, Set<PluginInvocation> pluginInvocations) {
        log.info("Creating TransferRequest from REST invocation method : {}, dest ID {}, sub Path {} ", new Object[]{methodString, destinationID, subPath});
        TransferOptions.TransferMethod method = null;
        try {
            method = TransferOptions.TransferMethod.valueOf((String)methodString);
        }
        catch (Throwable t) {
            throw new WebApplicationException("Invalid selected method " + methodString, Response.Status.BAD_REQUEST);
        }
        Destination destination = new Destination();
        destination.setCreateSubfolders(this.createDirs);
        destination.setPersistenceId(destinationID);
        destination.setSubFolder(subPath);
        destination.setOnExistingSubFolder(this.onExistingDirectory);
        destination.setOnExistingFileName(this.onExistingFile);
        TransferRequest resultingRequest = new TransferRequest();
        resultingRequest.setDestinationSettings(destination);
        resultingRequest.setPluginInvocations(pluginInvocations);
        switch (1.$SwitchMap$org$gcube$data$transfer$model$options$TransferOptions$TransferMethod[method.ordinal()]) {
            case 1: {
                if (this.uploadedFileDetails == null) {
                    throw new WebApplicationException("Missing multipart  uploadedFile details.", Response.Status.BAD_REQUEST);
                }
                if (this.uploadedFile == null) {
                    throw new WebApplicationException("Missing multipart  uploadedFile stream.", Response.Status.BAD_REQUEST);
                }
                destination.setDestinationFileName(this.destinationFileName != null ? this.destinationFileName : this.uploadedFileDetails.getFileName());
                FileUploadSettings uploadSettings = new FileUploadSettings(this.uploadedFile, new FileUploadOptions());
                resultingRequest.setSettings((TransferSettings)uploadSettings);
                break;
            }
            case 2: {
                throw new WebApplicationException("Unsupported selected method " + methodString, Response.Status.BAD_REQUEST);
            }
            case 3: {
                if (this.sourceID == null) {
                    throw new WebApplicationException("Parameter source-id is mandatory.", Response.Status.BAD_REQUEST);
                }
                destination.setDestinationFileName(this.destinationFileName == null ? this.sourceID : this.destinationFileName);
                try {
                    HttpDownloadSettings settings = new HttpDownloadSettings(new URL(this.sourceID), new HttpDownloadOptions());
                    resultingRequest.setSettings((TransferSettings)settings);
                    break;
                }
                catch (MalformedURLException e) {
                    throw new WebApplicationException("Source " + this.sourceID + " is not a valid URL.", Response.Status.BAD_REQUEST);
                }
            }
            default: {
                throw new WebApplicationException("Unsupported selected method " + methodString, Response.Status.BAD_REQUEST);
            }
        }
        return resultingRequest;
    }
}

